/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Response;
import software.amazon.awssdk.services.securityhub.model.TrendsMetricsResult;

public class GetFindingsTrendsV2Publisher
implements SdkPublisher<GetFindingsTrendsV2Response> {
    private final SecurityHubAsyncClient client;
    private final GetFindingsTrendsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFindingsTrendsV2Publisher(SecurityHubAsyncClient client, GetFindingsTrendsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFindingsTrendsV2Publisher(SecurityHubAsyncClient client, GetFindingsTrendsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFindingsTrendsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFindingsTrendsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrendsMetricsResult> trendsMetrics() {
        Function<GetFindingsTrendsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.trendsMetrics() != null) {
                return response.trendsMetrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetFindingsTrendsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetFindingsTrendsV2ResponseFetcher
    implements AsyncPageFetcher<GetFindingsTrendsV2Response> {
        private GetFindingsTrendsV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsTrendsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFindingsTrendsV2Response> nextPage(GetFindingsTrendsV2Response previousPage) {
            if (previousPage == null) {
                return GetFindingsTrendsV2Publisher.this.client.getFindingsTrendsV2(GetFindingsTrendsV2Publisher.this.firstRequest);
            }
            return GetFindingsTrendsV2Publisher.this.client.getFindingsTrendsV2((GetFindingsTrendsV2Request)((Object)GetFindingsTrendsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

