/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource;
import software.amazon.awssdk.services.securitylake.model.AwsLogSourceResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeAutoEnableNewAccountConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeAutoEnableNewAccountConfiguration> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(DataLakeAutoEnableNewAccountConfiguration.getter(DataLakeAutoEnableNewAccountConfiguration::region)).setter(DataLakeAutoEnableNewAccountConfiguration.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<List<AwsLogSourceResource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(DataLakeAutoEnableNewAccountConfiguration.getter(DataLakeAutoEnableNewAccountConfiguration::sources)).setter(DataLakeAutoEnableNewAccountConfiguration.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsLogSourceResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, SOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String region;
    private final List<AwsLogSourceResource> sources;

    private DataLakeAutoEnableNewAccountConfiguration(BuilderImpl builder) {
        this.region = builder.region;
        this.sources = builder.sources;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<AwsLogSourceResource> sources() {
        return this.sources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeAutoEnableNewAccountConfiguration)) {
            return false;
        }
        DataLakeAutoEnableNewAccountConfiguration other = (DataLakeAutoEnableNewAccountConfiguration)obj;
        return Objects.equals(this.region(), other.region()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeAutoEnableNewAccountConfiguration").add("Region", (Object)this.region()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeAutoEnableNewAccountConfiguration, T> g) {
        return obj -> g.apply((DataLakeAutoEnableNewAccountConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private List<AwsLogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeAutoEnableNewAccountConfiguration model) {
            this.region(model.region);
            this.sources(model.sources);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<AwsLogSourceResource.Builder> getSources() {
            List<AwsLogSourceResource.Builder> result = AwsLogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<AwsLogSourceResource.BuilderImpl> sources) {
            this.sources = AwsLogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<AwsLogSourceResource> sources) {
            this.sources = AwsLogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(AwsLogSourceResource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<AwsLogSourceResource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (AwsLogSourceResource)((AwsLogSourceResource.Builder)AwsLogSourceResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataLakeAutoEnableNewAccountConfiguration build() {
            return new DataLakeAutoEnableNewAccountConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeAutoEnableNewAccountConfiguration> {
        public Builder region(String var1);

        public Builder sources(Collection<AwsLogSourceResource> var1);

        public Builder sources(AwsLogSourceResource ... var1);

        public Builder sources(Consumer<AwsLogSourceResource.Builder> ... var1);
    }
}

