/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterDefinition> {
    private static final SdkField<String> ALLOWED_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedPattern").getter(ParameterDefinition.getter(ParameterDefinition::allowedPattern)).setter(ParameterDefinition.setter(Builder::allowedPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedPattern").build()}).build();
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedValues").getter(ParameterDefinition.getter(ParameterDefinition::allowedValues)).setter(ParameterDefinition.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONSTRAINT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConstraintDescription").getter(ParameterDefinition.getter(ParameterDefinition::constraintDescription)).setter(ParameterDefinition.setter(Builder::constraintDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constraintDescription").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(ParameterDefinition.getter(ParameterDefinition::defaultValue)).setter(ParameterDefinition.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ParameterDefinition.getter(ParameterDefinition::description)).setter(ParameterDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> MAX_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxLength").getter(ParameterDefinition.getter(ParameterDefinition::maxLength)).setter(ParameterDefinition.setter(Builder::maxLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLength").build()}).build();
    private static final SdkField<Integer> MAX_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxValue").getter(ParameterDefinition.getter(ParameterDefinition::maxValue)).setter(ParameterDefinition.setter(Builder::maxValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxValue").build()}).build();
    private static final SdkField<Integer> MIN_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinLength").getter(ParameterDefinition.getter(ParameterDefinition::minLength)).setter(ParameterDefinition.setter(Builder::minLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLength").build()}).build();
    private static final SdkField<Integer> MIN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinValue").getter(ParameterDefinition.getter(ParameterDefinition::minValue)).setter(ParameterDefinition.setter(Builder::minValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minValue").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ParameterDefinition.getter(ParameterDefinition::name)).setter(ParameterDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> NO_ECHO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoEcho").getter(ParameterDefinition.getter(ParameterDefinition::noEcho)).setter(ParameterDefinition.setter(Builder::noEcho)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noEcho").build()}).build();
    private static final SdkField<List<String>> REFERENCED_BY_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferencedByResources").getter(ParameterDefinition.getter(ParameterDefinition::referencedByResources)).setter(ParameterDefinition.setter(Builder::referencedByResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referencedByResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ParameterDefinition.getter(ParameterDefinition::type)).setter(ParameterDefinition.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_PATTERN_FIELD, ALLOWED_VALUES_FIELD, CONSTRAINT_DESCRIPTION_FIELD, DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, MAX_LENGTH_FIELD, MAX_VALUE_FIELD, MIN_LENGTH_FIELD, MIN_VALUE_FIELD, NAME_FIELD, NO_ECHO_FIELD, REFERENCED_BY_RESOURCES_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allowedPattern;
    private final List<String> allowedValues;
    private final String constraintDescription;
    private final String defaultValue;
    private final String description;
    private final Integer maxLength;
    private final Integer maxValue;
    private final Integer minLength;
    private final Integer minValue;
    private final String name;
    private final Boolean noEcho;
    private final List<String> referencedByResources;
    private final String type;

    private ParameterDefinition(BuilderImpl builder) {
        this.allowedPattern = builder.allowedPattern;
        this.allowedValues = builder.allowedValues;
        this.constraintDescription = builder.constraintDescription;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.maxLength = builder.maxLength;
        this.maxValue = builder.maxValue;
        this.minLength = builder.minLength;
        this.minValue = builder.minValue;
        this.name = builder.name;
        this.noEcho = builder.noEcho;
        this.referencedByResources = builder.referencedByResources;
        this.type = builder.type;
    }

    public final String allowedPattern() {
        return this.allowedPattern;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public final String constraintDescription() {
        return this.constraintDescription;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String description() {
        return this.description;
    }

    public final Integer maxLength() {
        return this.maxLength;
    }

    public final Integer maxValue() {
        return this.maxValue;
    }

    public final Integer minLength() {
        return this.minLength;
    }

    public final Integer minValue() {
        return this.minValue;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean noEcho() {
        return this.noEcho;
    }

    public final boolean hasReferencedByResources() {
        return this.referencedByResources != null && !(this.referencedByResources instanceof SdkAutoConstructList);
    }

    public final List<String> referencedByResources() {
        return this.referencedByResources;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.constraintDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.minLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferencedByResources() ? this.referencedByResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition)obj;
        return Objects.equals(this.allowedPattern(), other.allowedPattern()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.constraintDescription(), other.constraintDescription()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.maxLength(), other.maxLength()) && Objects.equals(this.maxValue(), other.maxValue()) && Objects.equals(this.minLength(), other.minLength()) && Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.noEcho(), other.noEcho()) && this.hasReferencedByResources() == other.hasReferencedByResources() && Objects.equals(this.referencedByResources(), other.referencedByResources()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterDefinition").add("AllowedPattern", (Object)this.allowedPattern()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("ConstraintDescription", (Object)this.constraintDescription()).add("DefaultValue", (Object)this.defaultValue()).add("Description", (Object)this.description()).add("MaxLength", (Object)this.maxLength()).add("MaxValue", (Object)this.maxValue()).add("MinLength", (Object)this.minLength()).add("MinValue", (Object)this.minValue()).add("Name", (Object)this.name()).add("NoEcho", (Object)this.noEcho()).add("ReferencedByResources", this.hasReferencedByResources() ? this.referencedByResources() : null).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedPattern": {
                return Optional.ofNullable(clazz.cast(this.allowedPattern()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "ConstraintDescription": {
                return Optional.ofNullable(clazz.cast(this.constraintDescription()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MaxLength": {
                return Optional.ofNullable(clazz.cast(this.maxLength()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
            case "MinLength": {
                return Optional.ofNullable(clazz.cast(this.minLength()));
            }
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NoEcho": {
                return Optional.ofNullable(clazz.cast(this.noEcho()));
            }
            case "ReferencedByResources": {
                return Optional.ofNullable(clazz.cast(this.referencedByResources()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterDefinition, T> g) {
        return obj -> g.apply((ParameterDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allowedPattern;
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private String constraintDescription;
        private String defaultValue;
        private String description;
        private Integer maxLength;
        private Integer maxValue;
        private Integer minLength;
        private Integer minValue;
        private String name;
        private Boolean noEcho;
        private List<String> referencedByResources = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDefinition model) {
            this.allowedPattern(model.allowedPattern);
            this.allowedValues(model.allowedValues);
            this.constraintDescription(model.constraintDescription);
            this.defaultValue(model.defaultValue);
            this.description(model.description);
            this.maxLength(model.maxLength);
            this.maxValue(model.maxValue);
            this.minLength(model.minLength);
            this.minValue(model.minValue);
            this.name(model.name);
            this.noEcho(model.noEcho);
            this.referencedByResources(model.referencedByResources);
            this.type(model.type);
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = ___listOf__stringCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = ___listOf__stringCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final String getConstraintDescription() {
            return this.constraintDescription;
        }

        public final void setConstraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
        }

        @Override
        public final Builder constraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMaxLength() {
            return this.maxLength;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final Integer getMaxValue() {
            return this.maxValue;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final Integer getMinLength() {
            return this.minLength;
        }

        public final void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        @Override
        public final Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public final Integer getMinValue() {
            return this.minValue;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getNoEcho() {
            return this.noEcho;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final Collection<String> getReferencedByResources() {
            if (this.referencedByResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referencedByResources;
        }

        public final void setReferencedByResources(Collection<String> referencedByResources) {
            this.referencedByResources = ___listOf__stringCopier.copy(referencedByResources);
        }

        @Override
        public final Builder referencedByResources(Collection<String> referencedByResources) {
            this.referencedByResources = ___listOf__stringCopier.copy(referencedByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedByResources(String ... referencedByResources) {
            this.referencedByResources(Arrays.asList(referencedByResources));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public ParameterDefinition build() {
            return new ParameterDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterDefinition> {
        public Builder allowedPattern(String var1);

        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);

        public Builder constraintDescription(String var1);

        public Builder defaultValue(String var1);

        public Builder description(String var1);

        public Builder maxLength(Integer var1);

        public Builder maxValue(Integer var1);

        public Builder minLength(Integer var1);

        public Builder minValue(Integer var1);

        public Builder name(String var1);

        public Builder noEcho(Boolean var1);

        public Builder referencedByResources(Collection<String> var1);

        public Builder referencedByResources(String ... var1);

        public Builder type(String var1);
    }
}

