/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Author").getter(CreateApplicationRequest.getter(CreateApplicationRequest::author)).setter(CreateApplicationRequest.setter(Builder::author)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateApplicationRequest.getter(CreateApplicationRequest::description)).setter(CreateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> HOME_PAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomePageUrl").getter(CreateApplicationRequest.getter(CreateApplicationRequest::homePageUrl)).setter(CreateApplicationRequest.setter(Builder::homePageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePageUrl").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(CreateApplicationRequest.getter(CreateApplicationRequest::labels)).setter(CreateApplicationRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LICENSE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseBody").getter(CreateApplicationRequest.getter(CreateApplicationRequest::licenseBody)).setter(CreateApplicationRequest.setter(Builder::licenseBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseBody").build()}).build();
    private static final SdkField<String> LICENSE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseUrl").getter(CreateApplicationRequest.getter(CreateApplicationRequest::licenseUrl)).setter(CreateApplicationRequest.setter(Builder::licenseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseUrl").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateApplicationRequest.getter(CreateApplicationRequest::name)).setter(CreateApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> README_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadmeBody").getter(CreateApplicationRequest.getter(CreateApplicationRequest::readmeBody)).setter(CreateApplicationRequest.setter(Builder::readmeBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeBody").build()}).build();
    private static final SdkField<String> README_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadmeUrl").getter(CreateApplicationRequest.getter(CreateApplicationRequest::readmeUrl)).setter(CreateApplicationRequest.setter(Builder::readmeUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeUrl").build()}).build();
    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SemanticVersion").getter(CreateApplicationRequest.getter(CreateApplicationRequest::semanticVersion)).setter(CreateApplicationRequest.setter(Builder::semanticVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticVersion").build()}).build();
    private static final SdkField<String> SOURCE_CODE_ARCHIVE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCodeArchiveUrl").getter(CreateApplicationRequest.getter(CreateApplicationRequest::sourceCodeArchiveUrl)).setter(CreateApplicationRequest.setter(Builder::sourceCodeArchiveUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeArchiveUrl").build()}).build();
    private static final SdkField<String> SOURCE_CODE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCodeUrl").getter(CreateApplicationRequest.getter(CreateApplicationRequest::sourceCodeUrl)).setter(CreateApplicationRequest.setter(Builder::sourceCodeUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeUrl").build()}).build();
    private static final SdkField<String> SPDX_LICENSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpdxLicenseId").getter(CreateApplicationRequest.getter(CreateApplicationRequest::spdxLicenseId)).setter(CreateApplicationRequest.setter(Builder::spdxLicenseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spdxLicenseId").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(CreateApplicationRequest.getter(CreateApplicationRequest::templateBody)).setter(CreateApplicationRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateUrl").getter(CreateApplicationRequest.getter(CreateApplicationRequest::templateUrl)).setter(CreateApplicationRequest.setter(Builder::templateUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHOR_FIELD, DESCRIPTION_FIELD, HOME_PAGE_URL_FIELD, LABELS_FIELD, LICENSE_BODY_FIELD, LICENSE_URL_FIELD, NAME_FIELD, README_BODY_FIELD, README_URL_FIELD, SEMANTIC_VERSION_FIELD, SOURCE_CODE_ARCHIVE_URL_FIELD, SOURCE_CODE_URL_FIELD, SPDX_LICENSE_ID_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApplicationRequest.memberNameToFieldInitializer();
    private final String author;
    private final String description;
    private final String homePageUrl;
    private final List<String> labels;
    private final String licenseBody;
    private final String licenseUrl;
    private final String name;
    private final String readmeBody;
    private final String readmeUrl;
    private final String semanticVersion;
    private final String sourceCodeArchiveUrl;
    private final String sourceCodeUrl;
    private final String spdxLicenseId;
    private final String templateBody;
    private final String templateUrl;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.author = builder.author;
        this.description = builder.description;
        this.homePageUrl = builder.homePageUrl;
        this.labels = builder.labels;
        this.licenseBody = builder.licenseBody;
        this.licenseUrl = builder.licenseUrl;
        this.name = builder.name;
        this.readmeBody = builder.readmeBody;
        this.readmeUrl = builder.readmeUrl;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeArchiveUrl = builder.sourceCodeArchiveUrl;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.spdxLicenseId = builder.spdxLicenseId;
        this.templateBody = builder.templateBody;
        this.templateUrl = builder.templateUrl;
    }

    public final String author() {
        return this.author;
    }

    public final String description() {
        return this.description;
    }

    public final String homePageUrl() {
        return this.homePageUrl;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    public final String licenseBody() {
        return this.licenseBody;
    }

    public final String licenseUrl() {
        return this.licenseUrl;
    }

    public final String name() {
        return this.name;
    }

    public final String readmeBody() {
        return this.readmeBody;
    }

    public final String readmeUrl() {
        return this.readmeUrl;
    }

    public final String semanticVersion() {
        return this.semanticVersion;
    }

    public final String sourceCodeArchiveUrl() {
        return this.sourceCodeArchiveUrl;
    }

    public final String sourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public final String spdxLicenseId() {
        return this.spdxLicenseId;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final String templateUrl() {
        return this.templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.homePageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeArchiveUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.spdxLicenseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.author(), other.author()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.homePageUrl(), other.homePageUrl()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.licenseBody(), other.licenseBody()) && Objects.equals(this.licenseUrl(), other.licenseUrl()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.readmeBody(), other.readmeBody()) && Objects.equals(this.readmeUrl(), other.readmeUrl()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.sourceCodeArchiveUrl(), other.sourceCodeArchiveUrl()) && Objects.equals(this.sourceCodeUrl(), other.sourceCodeUrl()) && Objects.equals(this.spdxLicenseId(), other.spdxLicenseId()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateUrl(), other.templateUrl());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("Author", (Object)this.author()).add("Description", (Object)this.description()).add("HomePageUrl", (Object)this.homePageUrl()).add("Labels", this.hasLabels() ? this.labels() : null).add("LicenseBody", (Object)this.licenseBody()).add("LicenseUrl", (Object)this.licenseUrl()).add("Name", (Object)this.name()).add("ReadmeBody", (Object)this.readmeBody()).add("ReadmeUrl", (Object)this.readmeUrl()).add("SemanticVersion", (Object)this.semanticVersion()).add("SourceCodeArchiveUrl", (Object)this.sourceCodeArchiveUrl()).add("SourceCodeUrl", (Object)this.sourceCodeUrl()).add("SpdxLicenseId", (Object)this.spdxLicenseId()).add("TemplateBody", (Object)this.templateBody()).add("TemplateUrl", (Object)this.templateUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HomePageUrl": {
                return Optional.ofNullable(clazz.cast(this.homePageUrl()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "LicenseBody": {
                return Optional.ofNullable(clazz.cast(this.licenseBody()));
            }
            case "LicenseUrl": {
                return Optional.ofNullable(clazz.cast(this.licenseUrl()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ReadmeBody": {
                return Optional.ofNullable(clazz.cast(this.readmeBody()));
            }
            case "ReadmeUrl": {
                return Optional.ofNullable(clazz.cast(this.readmeUrl()));
            }
            case "SemanticVersion": {
                return Optional.ofNullable(clazz.cast(this.semanticVersion()));
            }
            case "SourceCodeArchiveUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeArchiveUrl()));
            }
            case "SourceCodeUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeUrl()));
            }
            case "SpdxLicenseId": {
                return Optional.ofNullable(clazz.cast(this.spdxLicenseId()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "TemplateUrl": {
                return Optional.ofNullable(clazz.cast(this.templateUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("author", AUTHOR_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("homePageUrl", HOME_PAGE_URL_FIELD);
        map.put("labels", LABELS_FIELD);
        map.put("licenseBody", LICENSE_BODY_FIELD);
        map.put("licenseUrl", LICENSE_URL_FIELD);
        map.put("name", NAME_FIELD);
        map.put("readmeBody", README_BODY_FIELD);
        map.put("readmeUrl", README_URL_FIELD);
        map.put("semanticVersion", SEMANTIC_VERSION_FIELD);
        map.put("sourceCodeArchiveUrl", SOURCE_CODE_ARCHIVE_URL_FIELD);
        map.put("sourceCodeUrl", SOURCE_CODE_URL_FIELD);
        map.put("spdxLicenseId", SPDX_LICENSE_ID_FIELD);
        map.put("templateBody", TEMPLATE_BODY_FIELD);
        map.put("templateUrl", TEMPLATE_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String author;
        private String description;
        private String homePageUrl;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private String licenseBody;
        private String licenseUrl;
        private String name;
        private String readmeBody;
        private String readmeUrl;
        private String semanticVersion;
        private String sourceCodeArchiveUrl;
        private String sourceCodeUrl;
        private String spdxLicenseId;
        private String templateBody;
        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.author(model.author);
            this.description(model.description);
            this.homePageUrl(model.homePageUrl);
            this.labels(model.labels);
            this.licenseBody(model.licenseBody);
            this.licenseUrl(model.licenseUrl);
            this.name(model.name);
            this.readmeBody(model.readmeBody);
            this.readmeUrl(model.readmeUrl);
            this.semanticVersion(model.semanticVersion);
            this.sourceCodeArchiveUrl(model.sourceCodeArchiveUrl);
            this.sourceCodeUrl(model.sourceCodeUrl);
            this.spdxLicenseId(model.spdxLicenseId);
            this.templateBody(model.templateBody);
            this.templateUrl(model.templateUrl);
        }

        public final String getAuthor() {
            return this.author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHomePageUrl() {
            return this.homePageUrl;
        }

        public final void setHomePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
        }

        @Override
        public final Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ___listOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final String getLicenseBody() {
            return this.licenseBody;
        }

        public final void setLicenseBody(String licenseBody) {
            this.licenseBody = licenseBody;
        }

        @Override
        public final Builder licenseBody(String licenseBody) {
            this.licenseBody = licenseBody;
            return this;
        }

        public final String getLicenseUrl() {
            return this.licenseUrl;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReadmeBody() {
            return this.readmeBody;
        }

        public final void setReadmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
        }

        @Override
        public final Builder readmeBody(String readmeBody) {
            this.readmeBody = readmeBody;
            return this;
        }

        public final String getReadmeUrl() {
            return this.readmeUrl;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getSourceCodeArchiveUrl() {
            return this.sourceCodeArchiveUrl;
        }

        public final void setSourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
        }

        @Override
        public final Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
            return this;
        }

        public final String getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final String getSpdxLicenseId() {
            return this.spdxLicenseId;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateUrl() {
            return this.templateUrl;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder author(String var1);

        public Builder description(String var1);

        public Builder homePageUrl(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder licenseBody(String var1);

        public Builder licenseUrl(String var1);

        public Builder name(String var1);

        public Builder readmeBody(String var1);

        public Builder readmeUrl(String var1);

        public Builder semanticVersion(String var1);

        public Builder sourceCodeArchiveUrl(String var1);

        public Builder sourceCodeUrl(String var1);

        public Builder spdxLicenseId(String var1);

        public Builder templateBody(String var1);

        public Builder templateUrl(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

