/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a principal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Principal implements SdkPojo, Serializable, ToCopyableBuilder<Principal.Builder, Principal> {
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalARN").getter(getter(Principal::principalARN)).setter(setter(Builder::principalARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalARN").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalType").getter(getter(Principal::principalTypeAsString)).setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ARN_FIELD,
            PRINCIPAL_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String principalARN;

    private final String principalType;

    private Principal(BuilderImpl builder) {
        this.principalARN = builder.principalARN;
        this.principalType = builder.principalType;
    }

    /**
     * <p>
     * The ARN of the principal (user, role, or group). This field allows for an ARN with no <code>accountID</code>,
     * with or without wildcard characters if the <code>PrincipalType</code> is an <code>IAM_PATTERN</code>.
     * </p>
     * <p>
     * For more information, review <a href=
     * "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
     * >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
     * </p>
     * 
     * @return The ARN of the principal (user, role, or group). This field allows for an ARN with no
     *         <code>accountID</code>, with or without wildcard characters if the <code>PrincipalType</code> is an
     *         <code>IAM_PATTERN</code>. </p>
     *         <p>
     *         For more information, review <a href=
     *         "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
     *         >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
     */
    public final String principalARN() {
        return principalARN;
    }

    /**
     * <p>
     * The principal type. The supported value is <code>IAM</code> if you use a fully defined ARN, or
     * <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard characters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The principal type. The supported value is <code>IAM</code> if you use a fully defined ARN, or
     *         <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
     *         characters.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * The principal type. The supported value is <code>IAM</code> if you use a fully defined ARN, or
     * <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard characters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The principal type. The supported value is <code>IAM</code> if you use a fully defined ARN, or
     *         <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
     *         characters.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principalARN());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal) obj;
        return Objects.equals(principalARN(), other.principalARN())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Principal").add("PrincipalARN", principalARN()).add("PrincipalType", principalTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrincipalARN":
            return Optional.ofNullable(clazz.cast(principalARN()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Principal, T> g) {
        return obj -> g.apply((Principal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Principal> {
        /**
         * <p>
         * The ARN of the principal (user, role, or group). This field allows for an ARN with no <code>accountID</code>,
         * with or without wildcard characters if the <code>PrincipalType</code> is an <code>IAM_PATTERN</code>.
         * </p>
         * <p>
         * For more information, review <a href=
         * "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
         * >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
         * </p>
         * 
         * @param principalARN
         *        The ARN of the principal (user, role, or group). This field allows for an ARN with no
         *        <code>accountID</code>, with or without wildcard characters if the <code>PrincipalType</code> is an
         *        <code>IAM_PATTERN</code>. </p>
         *        <p>
         *        For more information, review <a href=
         *        "https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options"
         *        >associate-principal-with-portfolio</a> in the Amazon Web Services CLI Command Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalARN(String principalARN);

        /**
         * <p>
         * The principal type. The supported value is <code>IAM</code> if you use a fully defined ARN, or
         * <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
         * characters.
         * </p>
         * 
         * @param principalType
         *        The principal type. The supported value is <code>IAM</code> if you use a fully defined ARN, or
         *        <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
         *        characters.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The principal type. The supported value is <code>IAM</code> if you use a fully defined ARN, or
         * <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
         * characters.
         * </p>
         * 
         * @param principalType
         *        The principal type. The supported value is <code>IAM</code> if you use a fully defined ARN, or
         *        <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
         *        characters.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);
    }

    static final class BuilderImpl implements Builder {
        private String principalARN;

        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(Principal model) {
            principalARN(model.principalARN);
            principalType(model.principalType);
        }

        public final String getPrincipalARN() {
            return principalARN;
        }

        public final void setPrincipalARN(String principalARN) {
            this.principalARN = principalARN;
        }

        @Override
        public final Builder principalARN(String principalARN) {
            this.principalARN = principalARN;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        @Override
        public Principal build() {
            return new Principal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
