/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse;

public class ListServiceActionsForProvisioningArtifactPublisher
implements SdkPublisher<ListServiceActionsForProvisioningArtifactResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListServiceActionsForProvisioningArtifactRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceActionsForProvisioningArtifactPublisher(ServiceCatalogAsyncClient client, ListServiceActionsForProvisioningArtifactRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceActionsForProvisioningArtifactPublisher(ServiceCatalogAsyncClient client, ListServiceActionsForProvisioningArtifactRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceActionsForProvisioningArtifactResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceActionsForProvisioningArtifactResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListServiceActionsForProvisioningArtifactResponseFetcher
    implements AsyncPageFetcher<ListServiceActionsForProvisioningArtifactResponse> {
        private ListServiceActionsForProvisioningArtifactResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceActionsForProvisioningArtifactResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListServiceActionsForProvisioningArtifactResponse> nextPage(ListServiceActionsForProvisioningArtifactResponse previousPage) {
            if (previousPage == null) {
                return ListServiceActionsForProvisioningArtifactPublisher.this.client.listServiceActionsForProvisioningArtifact(ListServiceActionsForProvisioningArtifactPublisher.this.firstRequest);
            }
            return ListServiceActionsForProvisioningArtifactPublisher.this.client.listServiceActionsForProvisioningArtifact((ListServiceActionsForProvisioningArtifactRequest)((Object)ListServiceActionsForProvisioningArtifactPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

