/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationResponse extends ServiceCatalogAppRegistryResponse implements
        ToCopyableBuilder<GetConfigurationResponse.Builder, GetConfigurationResponse> {
    private static final SdkField<AppRegistryConfiguration> CONFIGURATION_FIELD = SdkField
            .<AppRegistryConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(GetConfigurationResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(AppRegistryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private final AppRegistryConfiguration configuration;

    private GetConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * Retrieves <code>TagKey</code> configuration from an account.
     * </p>
     * 
     * @return Retrieves <code>TagKey</code> configuration from an account.
     */
    public final AppRegistryConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationResponse)) {
            return false;
        }
        GetConfigurationResponse other = (GetConfigurationResponse) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigurationResponse").add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationResponse, T> g) {
        return obj -> g.apply((GetConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogAppRegistryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfigurationResponse> {
        /**
         * <p>
         * Retrieves <code>TagKey</code> configuration from an account.
         * </p>
         * 
         * @param configuration
         *        Retrieves <code>TagKey</code> configuration from an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AppRegistryConfiguration configuration);

        /**
         * <p>
         * Retrieves <code>TagKey</code> configuration from an account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppRegistryConfiguration.Builder}
         * avoiding the need to create one manually via {@link AppRegistryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppRegistryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(AppRegistryConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AppRegistryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AppRegistryConfiguration)
         */
        default Builder configuration(Consumer<AppRegistryConfiguration.Builder> configuration) {
            return configuration(AppRegistryConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends ServiceCatalogAppRegistryResponse.BuilderImpl implements Builder {
        private AppRegistryConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationResponse model) {
            super(model);
            configuration(model.configuration);
        }

        public final AppRegistryConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AppRegistryConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AppRegistryConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public GetConfigurationResponse build() {
            return new GetConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
