/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceFilterName {
    NAMESPACE_ID("NAMESPACE_ID"),
    RESOURCE_OWNER("RESOURCE_OWNER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceFilterName> VALUE_MAP;
    private final String value;

    private ServiceFilterName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceFilterName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceFilterName> knownValues() {
        EnumSet<ServiceFilterName> knownValues = EnumSet.allOf(ServiceFilterName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceFilterName.class, ServiceFilterName::toString);
    }
}

