/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create an open and click tracking option object in a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationSetTrackingOptionsRequest extends SesRequest implements
        ToCopyableBuilder<CreateConfigurationSetTrackingOptionsRequest.Builder, CreateConfigurationSetTrackingOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName")
            .getter(getter(CreateConfigurationSetTrackingOptionsRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<TrackingOptions> TRACKING_OPTIONS_FIELD = SdkField
            .<TrackingOptions> builder(MarshallingType.SDK_POJO).memberName("TrackingOptions")
            .getter(getter(CreateConfigurationSetTrackingOptionsRequest::trackingOptions))
            .setter(setter(Builder::trackingOptions)).constructor(TrackingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            TRACKING_OPTIONS_FIELD));

    private final String configurationSetName;

    private final TrackingOptions trackingOptions;

    private CreateConfigurationSetTrackingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.trackingOptions = builder.trackingOptions;
    }

    /**
     * <p>
     * The name of the configuration set that the tracking options should be associated with.
     * </p>
     * 
     * @return The name of the configuration set that the tracking options should be associated with.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * Returns the value of the TrackingOptions property for this object.
     * 
     * @return The value of the TrackingOptions property for this object.
     */
    public final TrackingOptions trackingOptions() {
        return trackingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(trackingOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetTrackingOptionsRequest)) {
            return false;
        }
        CreateConfigurationSetTrackingOptionsRequest other = (CreateConfigurationSetTrackingOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(trackingOptions(), other.trackingOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfigurationSetTrackingOptionsRequest")
                .add("ConfigurationSetName", configurationSetName()).add("TrackingOptions", trackingOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "TrackingOptions":
            return Optional.ofNullable(clazz.cast(trackingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationSetTrackingOptionsRequest, T> g) {
        return obj -> g.apply((CreateConfigurationSetTrackingOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfigurationSetTrackingOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set that the tracking options should be associated with.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that the tracking options should be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * Sets the value of the TrackingOptions property for this object.
         *
         * @param trackingOptions
         *        The new value for the TrackingOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingOptions(TrackingOptions trackingOptions);

        /**
         * Sets the value of the TrackingOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TrackingOptions.Builder} avoiding the
         * need to create one manually via {@link TrackingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrackingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #trackingOptions(TrackingOptions)}.
         * 
         * @param trackingOptions
         *        a consumer that will call methods on {@link TrackingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trackingOptions(TrackingOptions)
         */
        default Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return trackingOptions(TrackingOptions.builder().applyMutation(trackingOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private TrackingOptions trackingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetTrackingOptionsRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            trackingOptions(model.trackingOptions);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return trackingOptions != null ? trackingOptions.toBuilder() : null;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        @Override
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationSetTrackingOptionsRequest build() {
            return new CreateConfigurationSetTrackingOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
