/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to change the warm-up attributes for a dedicated IP address. This operation is useful when you want to
 * resume the warm-up process for an existing IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDedicatedIpWarmupAttributesRequest extends SesV2Request implements
        ToCopyableBuilder<PutDedicatedIpWarmupAttributesRequest.Builder, PutDedicatedIpWarmupAttributesRequest> {
    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(PutDedicatedIpWarmupAttributesRequest::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IP").build()).build();

    private static final SdkField<Integer> WARMUP_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WarmupPercentage").getter(getter(PutDedicatedIpWarmupAttributesRequest::warmupPercentage))
            .setter(setter(Builder::warmupPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmupPercentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD,
            WARMUP_PERCENTAGE_FIELD));

    private final String ip;

    private final Integer warmupPercentage;

    private PutDedicatedIpWarmupAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.ip = builder.ip;
        this.warmupPercentage = builder.warmupPercentage;
    }

    /**
     * <p>
     * The dedicated IP address that you want to update the warm-up attributes for.
     * </p>
     * 
     * @return The dedicated IP address that you want to update the warm-up attributes for.
     */
    public final String ip() {
        return ip;
    }

    /**
     * <p>
     * The warm-up percentage that you want to associate with the dedicated IP address.
     * </p>
     * 
     * @return The warm-up percentage that you want to associate with the dedicated IP address.
     */
    public final Integer warmupPercentage() {
        return warmupPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(warmupPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDedicatedIpWarmupAttributesRequest)) {
            return false;
        }
        PutDedicatedIpWarmupAttributesRequest other = (PutDedicatedIpWarmupAttributesRequest) obj;
        return Objects.equals(ip(), other.ip()) && Objects.equals(warmupPercentage(), other.warmupPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDedicatedIpWarmupAttributesRequest").add("Ip", ip())
                .add("WarmupPercentage", warmupPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "WarmupPercentage":
            return Optional.ofNullable(clazz.cast(warmupPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDedicatedIpWarmupAttributesRequest, T> g) {
        return obj -> g.apply((PutDedicatedIpWarmupAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDedicatedIpWarmupAttributesRequest> {
        /**
         * <p>
         * The dedicated IP address that you want to update the warm-up attributes for.
         * </p>
         * 
         * @param ip
         *        The dedicated IP address that you want to update the warm-up attributes for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * The warm-up percentage that you want to associate with the dedicated IP address.
         * </p>
         * 
         * @param warmupPercentage
         *        The warm-up percentage that you want to associate with the dedicated IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmupPercentage(Integer warmupPercentage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String ip;

        private Integer warmupPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDedicatedIpWarmupAttributesRequest model) {
            super(model);
            ip(model.ip);
            warmupPercentage(model.warmupPercentage);
        }

        public final String getIp() {
            return ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final Integer getWarmupPercentage() {
            return warmupPercentage;
        }

        public final void setWarmupPercentage(Integer warmupPercentage) {
            this.warmupPercentage = warmupPercentage;
        }

        @Override
        public final Builder warmupPercentage(Integer warmupPercentage) {
            this.warmupPercentage = warmupPercentage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDedicatedIpWarmupAttributesRequest build() {
            return new PutDedicatedIpWarmupAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
