/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SendingStatus;
import software.amazon.awssdk.services.sesv2.model.Tag;
import software.amazon.awssdk.services.sesv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Tenant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Tenant> {
    private static final SdkField<String> TENANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantName").getter(Tenant.getter(Tenant::tenantName)).setter(Tenant.setter(Builder::tenantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantName").build()}).build();
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantId").getter(Tenant.getter(Tenant::tenantId)).setter(Tenant.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()}).build();
    private static final SdkField<String> TENANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantArn").getter(Tenant.getter(Tenant::tenantArn)).setter(Tenant.setter(Builder::tenantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(Tenant.getter(Tenant::createdTimestamp)).setter(Tenant.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Tenant.getter(Tenant::tags)).setter(Tenant.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SENDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SendingStatus").getter(Tenant.getter(Tenant::sendingStatusAsString)).setter(Tenant.setter(Builder::sendingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_NAME_FIELD, TENANT_ID_FIELD, TENANT_ARN_FIELD, CREATED_TIMESTAMP_FIELD, TAGS_FIELD, SENDING_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Tenant.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tenantName;
    private final String tenantId;
    private final String tenantArn;
    private final Instant createdTimestamp;
    private final List<Tag> tags;
    private final String sendingStatus;

    private Tenant(BuilderImpl builder) {
        this.tenantName = builder.tenantName;
        this.tenantId = builder.tenantId;
        this.tenantArn = builder.tenantArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.tags = builder.tags;
        this.sendingStatus = builder.sendingStatus;
    }

    public final String tenantName() {
        return this.tenantName;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final String tenantArn() {
        return this.tenantArn;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final SendingStatus sendingStatus() {
        return SendingStatus.fromValue(this.sendingStatus);
    }

    public final String sendingStatusAsString() {
        return this.sendingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant)obj;
        return Objects.equals(this.tenantName(), other.tenantName()) && Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.tenantArn(), other.tenantArn()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sendingStatusAsString(), other.sendingStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Tenant").add("TenantName", (Object)this.tenantName()).add("TenantId", (Object)this.tenantId()).add("TenantArn", (Object)this.tenantArn()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).add("SendingStatus", (Object)this.sendingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantName": {
                return Optional.ofNullable(clazz.cast(this.tenantName()));
            }
            case "TenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "TenantArn": {
                return Optional.ofNullable(clazz.cast(this.tenantArn()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SendingStatus": {
                return Optional.ofNullable(clazz.cast(this.sendingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TenantName", TENANT_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("TenantArn", TENANT_ARN_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SendingStatus", SENDING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Tenant, T> g) {
        return obj -> g.apply((Tenant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tenantName;
        private String tenantId;
        private String tenantArn;
        private Instant createdTimestamp;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String sendingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Tenant model) {
            this.tenantName(model.tenantName);
            this.tenantId(model.tenantId);
            this.tenantArn(model.tenantArn);
            this.createdTimestamp(model.createdTimestamp);
            this.tags(model.tags);
            this.sendingStatus(model.sendingStatus);
        }

        public final String getTenantName() {
            return this.tenantName;
        }

        public final void setTenantName(String tenantName) {
            this.tenantName = tenantName;
        }

        @Override
        public final Builder tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTenantArn() {
            return this.tenantArn;
        }

        public final void setTenantArn(String tenantArn) {
            this.tenantArn = tenantArn;
        }

        @Override
        public final Builder tenantArn(String tenantArn) {
            this.tenantArn = tenantArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSendingStatus() {
            return this.sendingStatus;
        }

        public final void setSendingStatus(String sendingStatus) {
            this.sendingStatus = sendingStatus;
        }

        @Override
        public final Builder sendingStatus(String sendingStatus) {
            this.sendingStatus = sendingStatus;
            return this;
        }

        @Override
        public final Builder sendingStatus(SendingStatus sendingStatus) {
            this.sendingStatus(sendingStatus == null ? null : sendingStatus.toString());
            return this;
        }

        public Tenant build() {
            return new Tenant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Tenant> {
        public Builder tenantName(String var1);

        public Builder tenantId(String var1);

        public Builder tenantArn(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder sendingStatus(String var1);

        public Builder sendingStatus(SendingStatus var1);
    }
}

