/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListTenantsRequest;
import software.amazon.awssdk.services.sesv2.model.ListTenantsResponse;
import software.amazon.awssdk.services.sesv2.model.TenantInfo;

public class ListTenantsPublisher
implements SdkPublisher<ListTenantsResponse> {
    private final SesV2AsyncClient client;
    private final ListTenantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTenantsPublisher(SesV2AsyncClient client, ListTenantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTenantsPublisher(SesV2AsyncClient client, ListTenantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTenantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTenantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TenantInfo> tenants() {
        Function<ListTenantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tenants() != null) {
                return response.tenants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTenantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTenantsResponseFetcher
    implements AsyncPageFetcher<ListTenantsResponse> {
        private ListTenantsResponseFetcher() {
        }

        public boolean hasNextPage(ListTenantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTenantsResponse> nextPage(ListTenantsResponse previousPage) {
            if (previousPage == null) {
                return ListTenantsPublisher.this.client.listTenants(ListTenantsPublisher.this.firstRequest);
            }
            return ListTenantsPublisher.this.client.listTenants((ListTenantsRequest)((Object)ListTenantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

