/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.MapRunExecutionCounts;
import software.amazon.awssdk.services.sfn.model.MapRunItemCounts;
import software.amazon.awssdk.services.sfn.model.MapRunStatus;
import software.amazon.awssdk.services.sfn.model.SfnResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMapRunResponse
extends SfnResponse
implements ToCopyableBuilder<Builder, DescribeMapRunResponse> {
    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mapRunArn").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::mapRunArn)).setter(DescribeMapRunResponse.setter(Builder::mapRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()}).build();
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionArn").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::executionArn)).setter(DescribeMapRunResponse.setter(Builder::executionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::statusAsString)).setter(DescribeMapRunResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::startDate)).setter(DescribeMapRunResponse.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()}).build();
    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopDate").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::stopDate)).setter(DescribeMapRunResponse.setter(Builder::stopDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxConcurrency").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::maxConcurrency)).setter(DescribeMapRunResponse.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrency").build()}).build();
    private static final SdkField<Float> TOLERATED_FAILURE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("toleratedFailurePercentage").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::toleratedFailurePercentage)).setter(DescribeMapRunResponse.setter(Builder::toleratedFailurePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailurePercentage").build()}).build();
    private static final SdkField<Long> TOLERATED_FAILURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("toleratedFailureCount").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::toleratedFailureCount)).setter(DescribeMapRunResponse.setter(Builder::toleratedFailureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailureCount").build()}).build();
    private static final SdkField<MapRunItemCounts> ITEM_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("itemCounts").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::itemCounts)).setter(DescribeMapRunResponse.setter(Builder::itemCounts)).constructor(MapRunItemCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemCounts").build()}).build();
    private static final SdkField<MapRunExecutionCounts> EXECUTION_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionCounts").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::executionCounts)).setter(DescribeMapRunResponse.setter(Builder::executionCounts)).constructor(MapRunExecutionCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionCounts").build()}).build();
    private static final SdkField<Integer> REDRIVE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("redriveCount").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::redriveCount)).setter(DescribeMapRunResponse.setter(Builder::redriveCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveCount").build()}).build();
    private static final SdkField<Instant> REDRIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("redriveDate").getter(DescribeMapRunResponse.getter(DescribeMapRunResponse::redriveDate)).setter(DescribeMapRunResponse.setter(Builder::redriveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_RUN_ARN_FIELD, EXECUTION_ARN_FIELD, STATUS_FIELD, START_DATE_FIELD, STOP_DATE_FIELD, MAX_CONCURRENCY_FIELD, TOLERATED_FAILURE_PERCENTAGE_FIELD, TOLERATED_FAILURE_COUNT_FIELD, ITEM_COUNTS_FIELD, EXECUTION_COUNTS_FIELD, REDRIVE_COUNT_FIELD, REDRIVE_DATE_FIELD));
    private final String mapRunArn;
    private final String executionArn;
    private final String status;
    private final Instant startDate;
    private final Instant stopDate;
    private final Integer maxConcurrency;
    private final Float toleratedFailurePercentage;
    private final Long toleratedFailureCount;
    private final MapRunItemCounts itemCounts;
    private final MapRunExecutionCounts executionCounts;
    private final Integer redriveCount;
    private final Instant redriveDate;

    private DescribeMapRunResponse(BuilderImpl builder) {
        super(builder);
        this.mapRunArn = builder.mapRunArn;
        this.executionArn = builder.executionArn;
        this.status = builder.status;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
        this.maxConcurrency = builder.maxConcurrency;
        this.toleratedFailurePercentage = builder.toleratedFailurePercentage;
        this.toleratedFailureCount = builder.toleratedFailureCount;
        this.itemCounts = builder.itemCounts;
        this.executionCounts = builder.executionCounts;
        this.redriveCount = builder.redriveCount;
        this.redriveDate = builder.redriveDate;
    }

    public final String mapRunArn() {
        return this.mapRunArn;
    }

    public final String executionArn() {
        return this.executionArn;
    }

    public final MapRunStatus status() {
        return MapRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant stopDate() {
        return this.stopDate;
    }

    public final Integer maxConcurrency() {
        return this.maxConcurrency;
    }

    public final Float toleratedFailurePercentage() {
        return this.toleratedFailurePercentage;
    }

    public final Long toleratedFailureCount() {
        return this.toleratedFailureCount;
    }

    public final MapRunItemCounts itemCounts() {
        return this.itemCounts;
    }

    public final MapRunExecutionCounts executionCounts() {
        return this.executionCounts;
    }

    public final Integer redriveCount() {
        return this.redriveCount;
    }

    public final Instant redriveDate() {
        return this.redriveDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.toleratedFailurePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.toleratedFailureCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.redriveCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.redriveDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMapRunResponse)) {
            return false;
        }
        DescribeMapRunResponse other = (DescribeMapRunResponse)((Object)obj);
        return Objects.equals(this.mapRunArn(), other.mapRunArn()) && Objects.equals(this.executionArn(), other.executionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.stopDate(), other.stopDate()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.toleratedFailurePercentage(), other.toleratedFailurePercentage()) && Objects.equals(this.toleratedFailureCount(), other.toleratedFailureCount()) && Objects.equals(this.itemCounts(), other.itemCounts()) && Objects.equals(this.executionCounts(), other.executionCounts()) && Objects.equals(this.redriveCount(), other.redriveCount()) && Objects.equals(this.redriveDate(), other.redriveDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMapRunResponse").add("MapRunArn", (Object)this.mapRunArn()).add("ExecutionArn", (Object)this.executionArn()).add("Status", (Object)this.statusAsString()).add("StartDate", (Object)this.startDate()).add("StopDate", (Object)this.stopDate()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("ToleratedFailurePercentage", (Object)this.toleratedFailurePercentage()).add("ToleratedFailureCount", (Object)this.toleratedFailureCount()).add("ItemCounts", (Object)this.itemCounts()).add("ExecutionCounts", (Object)this.executionCounts()).add("RedriveCount", (Object)this.redriveCount()).add("RedriveDate", (Object)this.redriveDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mapRunArn": {
                return Optional.ofNullable(clazz.cast(this.mapRunArn()));
            }
            case "executionArn": {
                return Optional.ofNullable(clazz.cast(this.executionArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "stopDate": {
                return Optional.ofNullable(clazz.cast(this.stopDate()));
            }
            case "maxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "toleratedFailurePercentage": {
                return Optional.ofNullable(clazz.cast(this.toleratedFailurePercentage()));
            }
            case "toleratedFailureCount": {
                return Optional.ofNullable(clazz.cast(this.toleratedFailureCount()));
            }
            case "itemCounts": {
                return Optional.ofNullable(clazz.cast(this.itemCounts()));
            }
            case "executionCounts": {
                return Optional.ofNullable(clazz.cast(this.executionCounts()));
            }
            case "redriveCount": {
                return Optional.ofNullable(clazz.cast(this.redriveCount()));
            }
            case "redriveDate": {
                return Optional.ofNullable(clazz.cast(this.redriveDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMapRunResponse, T> g) {
        return obj -> g.apply((DescribeMapRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnResponse.BuilderImpl
    implements Builder {
        private String mapRunArn;
        private String executionArn;
        private String status;
        private Instant startDate;
        private Instant stopDate;
        private Integer maxConcurrency;
        private Float toleratedFailurePercentage;
        private Long toleratedFailureCount;
        private MapRunItemCounts itemCounts;
        private MapRunExecutionCounts executionCounts;
        private Integer redriveCount;
        private Instant redriveDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMapRunResponse model) {
            super(model);
            this.mapRunArn(model.mapRunArn);
            this.executionArn(model.executionArn);
            this.status(model.status);
            this.startDate(model.startDate);
            this.stopDate(model.stopDate);
            this.maxConcurrency(model.maxConcurrency);
            this.toleratedFailurePercentage(model.toleratedFailurePercentage);
            this.toleratedFailureCount(model.toleratedFailureCount);
            this.itemCounts(model.itemCounts);
            this.executionCounts(model.executionCounts);
            this.redriveCount(model.redriveCount);
            this.redriveDate(model.redriveDate);
        }

        public final String getMapRunArn() {
            return this.mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final String getExecutionArn() {
            return this.executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MapRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return this.stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final Float getToleratedFailurePercentage() {
            return this.toleratedFailurePercentage;
        }

        public final void setToleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
        }

        @Override
        public final Builder toleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
            return this;
        }

        public final Long getToleratedFailureCount() {
            return this.toleratedFailureCount;
        }

        public final void setToleratedFailureCount(Long toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
        }

        @Override
        public final Builder toleratedFailureCount(Long toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
            return this;
        }

        public final MapRunItemCounts.Builder getItemCounts() {
            return this.itemCounts != null ? this.itemCounts.toBuilder() : null;
        }

        public final void setItemCounts(MapRunItemCounts.BuilderImpl itemCounts) {
            this.itemCounts = itemCounts != null ? itemCounts.build() : null;
        }

        @Override
        public final Builder itemCounts(MapRunItemCounts itemCounts) {
            this.itemCounts = itemCounts;
            return this;
        }

        public final MapRunExecutionCounts.Builder getExecutionCounts() {
            return this.executionCounts != null ? this.executionCounts.toBuilder() : null;
        }

        public final void setExecutionCounts(MapRunExecutionCounts.BuilderImpl executionCounts) {
            this.executionCounts = executionCounts != null ? executionCounts.build() : null;
        }

        @Override
        public final Builder executionCounts(MapRunExecutionCounts executionCounts) {
            this.executionCounts = executionCounts;
            return this;
        }

        public final Integer getRedriveCount() {
            return this.redriveCount;
        }

        public final void setRedriveCount(Integer redriveCount) {
            this.redriveCount = redriveCount;
        }

        @Override
        public final Builder redriveCount(Integer redriveCount) {
            this.redriveCount = redriveCount;
            return this;
        }

        public final Instant getRedriveDate() {
            return this.redriveDate;
        }

        public final void setRedriveDate(Instant redriveDate) {
            this.redriveDate = redriveDate;
        }

        @Override
        public final Builder redriveDate(Instant redriveDate) {
            this.redriveDate = redriveDate;
            return this;
        }

        @Override
        public DescribeMapRunResponse build() {
            return new DescribeMapRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SfnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMapRunResponse> {
        public Builder mapRunArn(String var1);

        public Builder executionArn(String var1);

        public Builder status(String var1);

        public Builder status(MapRunStatus var1);

        public Builder startDate(Instant var1);

        public Builder stopDate(Instant var1);

        public Builder maxConcurrency(Integer var1);

        public Builder toleratedFailurePercentage(Float var1);

        public Builder toleratedFailureCount(Long var1);

        public Builder itemCounts(MapRunItemCounts var1);

        default public Builder itemCounts(Consumer<MapRunItemCounts.Builder> itemCounts) {
            return this.itemCounts((MapRunItemCounts)((MapRunItemCounts.Builder)MapRunItemCounts.builder().applyMutation(itemCounts)).build());
        }

        public Builder executionCounts(MapRunExecutionCounts var1);

        default public Builder executionCounts(Consumer<MapRunExecutionCounts.Builder> executionCounts) {
            return this.executionCounts((MapRunExecutionCounts)((MapRunExecutionCounts.Builder)MapRunExecutionCounts.builder().applyMutation(executionCounts)).build());
        }

        public Builder redriveCount(Integer var1);

        public Builder redriveDate(Instant var1);
    }
}

