/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.InspectionLevel;
import software.amazon.awssdk.services.sfn.model.MockInput;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.services.sfn.model.TestStateConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestStateRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, TestStateRequest> {
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(TestStateRequest.getter(TestStateRequest::definition)).setter(TestStateRequest.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(TestStateRequest.getter(TestStateRequest::roleArn)).setter(TestStateRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("input").getter(TestStateRequest.getter(TestStateRequest::input)).setter(TestStateRequest.setter(Builder::input)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> INSPECTION_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inspectionLevel").getter(TestStateRequest.getter(TestStateRequest::inspectionLevelAsString)).setter(TestStateRequest.setter(Builder::inspectionLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inspectionLevel").build()}).build();
    private static final SdkField<Boolean> REVEAL_SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("revealSecrets").getter(TestStateRequest.getter(TestStateRequest::revealSecrets)).setter(TestStateRequest.setter(Builder::revealSecrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revealSecrets").build()}).build();
    private static final SdkField<String> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("variables").getter(TestStateRequest.getter(TestStateRequest::variables)).setter(TestStateRequest.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build()}).build();
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateName").getter(TestStateRequest.getter(TestStateRequest::stateName)).setter(TestStateRequest.setter(Builder::stateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()}).build();
    private static final SdkField<MockInput> MOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mock").getter(TestStateRequest.getter(TestStateRequest::mock)).setter(TestStateRequest.setter(Builder::mock)).constructor(MockInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mock").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("context").getter(TestStateRequest.getter(TestStateRequest::context)).setter(TestStateRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final SdkField<TestStateConfiguration> STATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stateConfiguration").getter(TestStateRequest.getter(TestStateRequest::stateConfiguration)).setter(TestStateRequest.setter(Builder::stateConfiguration)).constructor(TestStateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, ROLE_ARN_FIELD, INPUT_FIELD, INSPECTION_LEVEL_FIELD, REVEAL_SECRETS_FIELD, VARIABLES_FIELD, STATE_NAME_FIELD, MOCK_FIELD, CONTEXT_FIELD, STATE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestStateRequest.memberNameToFieldInitializer();
    private final String definition;
    private final String roleArn;
    private final String input;
    private final String inspectionLevel;
    private final Boolean revealSecrets;
    private final String variables;
    private final String stateName;
    private final MockInput mock;
    private final String context;
    private final TestStateConfiguration stateConfiguration;

    private TestStateRequest(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.roleArn = builder.roleArn;
        this.input = builder.input;
        this.inspectionLevel = builder.inspectionLevel;
        this.revealSecrets = builder.revealSecrets;
        this.variables = builder.variables;
        this.stateName = builder.stateName;
        this.mock = builder.mock;
        this.context = builder.context;
        this.stateConfiguration = builder.stateConfiguration;
    }

    public final String definition() {
        return this.definition;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String input() {
        return this.input;
    }

    public final InspectionLevel inspectionLevel() {
        return InspectionLevel.fromValue(this.inspectionLevel);
    }

    public final String inspectionLevelAsString() {
        return this.inspectionLevel;
    }

    public final Boolean revealSecrets() {
        return this.revealSecrets;
    }

    public final String variables() {
        return this.variables;
    }

    public final String stateName() {
        return this.stateName;
    }

    public final MockInput mock() {
        return this.mock;
    }

    public final String context() {
        return this.context;
    }

    public final TestStateConfiguration stateConfiguration() {
        return this.stateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectionLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revealSecrets());
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mock());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestStateRequest)) {
            return false;
        }
        TestStateRequest other = (TestStateRequest)((Object)obj);
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.inspectionLevelAsString(), other.inspectionLevelAsString()) && Objects.equals(this.revealSecrets(), other.revealSecrets()) && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.stateName(), other.stateName()) && Objects.equals(this.mock(), other.mock()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.stateConfiguration(), other.stateConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TestStateRequest").add("Definition", (Object)(this.definition() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("Input", (Object)(this.input() == null ? null : "*** Sensitive Data Redacted ***")).add("InspectionLevel", (Object)this.inspectionLevelAsString()).add("RevealSecrets", (Object)this.revealSecrets()).add("Variables", (Object)(this.variables() == null ? null : "*** Sensitive Data Redacted ***")).add("StateName", (Object)(this.stateName() == null ? null : "*** Sensitive Data Redacted ***")).add("Mock", (Object)this.mock()).add("Context", (Object)(this.context() == null ? null : "*** Sensitive Data Redacted ***")).add("StateConfiguration", (Object)this.stateConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "inspectionLevel": {
                return Optional.ofNullable(clazz.cast(this.inspectionLevelAsString()));
            }
            case "revealSecrets": {
                return Optional.ofNullable(clazz.cast(this.revealSecrets()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "stateName": {
                return Optional.ofNullable(clazz.cast(this.stateName()));
            }
            case "mock": {
                return Optional.ofNullable(clazz.cast(this.mock()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "stateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stateConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("definition", DEFINITION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("inspectionLevel", INSPECTION_LEVEL_FIELD);
        map.put("revealSecrets", REVEAL_SECRETS_FIELD);
        map.put("variables", VARIABLES_FIELD);
        map.put("stateName", STATE_NAME_FIELD);
        map.put("mock", MOCK_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("stateConfiguration", STATE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestStateRequest, T> g) {
        return obj -> g.apply((TestStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String definition;
        private String roleArn;
        private String input;
        private String inspectionLevel;
        private Boolean revealSecrets;
        private String variables;
        private String stateName;
        private MockInput mock;
        private String context;
        private TestStateConfiguration stateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TestStateRequest model) {
            super(model);
            this.definition(model.definition);
            this.roleArn(model.roleArn);
            this.input(model.input);
            this.inspectionLevel(model.inspectionLevel);
            this.revealSecrets(model.revealSecrets);
            this.variables(model.variables);
            this.stateName(model.stateName);
            this.mock(model.mock);
            this.context(model.context);
            this.stateConfiguration(model.stateConfiguration);
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getInput() {
            return this.input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getInspectionLevel() {
            return this.inspectionLevel;
        }

        public final void setInspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
        }

        @Override
        public final Builder inspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
            return this;
        }

        @Override
        public final Builder inspectionLevel(InspectionLevel inspectionLevel) {
            this.inspectionLevel(inspectionLevel == null ? null : inspectionLevel.toString());
            return this;
        }

        public final Boolean getRevealSecrets() {
            return this.revealSecrets;
        }

        public final void setRevealSecrets(Boolean revealSecrets) {
            this.revealSecrets = revealSecrets;
        }

        @Override
        public final Builder revealSecrets(Boolean revealSecrets) {
            this.revealSecrets = revealSecrets;
            return this;
        }

        public final String getVariables() {
            return this.variables;
        }

        public final void setVariables(String variables) {
            this.variables = variables;
        }

        @Override
        public final Builder variables(String variables) {
            this.variables = variables;
            return this;
        }

        public final String getStateName() {
            return this.stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final MockInput.Builder getMock() {
            return this.mock != null ? this.mock.toBuilder() : null;
        }

        public final void setMock(MockInput.BuilderImpl mock) {
            this.mock = mock != null ? mock.build() : null;
        }

        @Override
        public final Builder mock(MockInput mock) {
            this.mock = mock;
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final TestStateConfiguration.Builder getStateConfiguration() {
            return this.stateConfiguration != null ? this.stateConfiguration.toBuilder() : null;
        }

        public final void setStateConfiguration(TestStateConfiguration.BuilderImpl stateConfiguration) {
            this.stateConfiguration = stateConfiguration != null ? stateConfiguration.build() : null;
        }

        @Override
        public final Builder stateConfiguration(TestStateConfiguration stateConfiguration) {
            this.stateConfiguration = stateConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestStateRequest build() {
            return new TestStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestStateRequest> {
        public Builder definition(String var1);

        public Builder roleArn(String var1);

        public Builder input(String var1);

        public Builder inspectionLevel(String var1);

        public Builder inspectionLevel(InspectionLevel var1);

        public Builder revealSecrets(Boolean var1);

        public Builder variables(String var1);

        public Builder stateName(String var1);

        public Builder mock(MockInput var1);

        default public Builder mock(Consumer<MockInput.Builder> mock) {
            return this.mock((MockInput)((MockInput.Builder)MockInput.builder().applyMutation(mock)).build());
        }

        public Builder context(String var1);

        public Builder stateConfiguration(TestStateConfiguration var1);

        default public Builder stateConfiguration(Consumer<TestStateConfiguration.Builder> stateConfiguration) {
            return this.stateConfiguration((TestStateConfiguration)((TestStateConfiguration.Builder)TestStateConfiguration.builder().applyMutation(stateConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

