/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.simspaceweaver.SimSpaceWeaverClient;
import software.amazon.awssdk.services.simspaceweaver.internal.UserAgentUtils;
import software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse;

public class ListSimulationsIterable
implements SdkIterable<ListSimulationsResponse> {
    private final SimSpaceWeaverClient client;
    private final ListSimulationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSimulationsIterable(SimSpaceWeaverClient client, ListSimulationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSimulationsResponseFetcher();
    }

    public Iterator<ListSimulationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSimulationsResponseFetcher
    implements SyncPageFetcher<ListSimulationsResponse> {
        private ListSimulationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSimulationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSimulationsResponse nextPage(ListSimulationsResponse previousPage) {
            if (previousPage == null) {
                return ListSimulationsIterable.this.client.listSimulations(ListSimulationsIterable.this.firstRequest);
            }
            return ListSimulationsIterable.this.client.listSimulations((ListSimulationsRequest)((Object)ListSimulationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

