/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.snowball.model.CancelClusterRequest;
import software.amazon.awssdk.services.snowball.model.CancelClusterResponse;
import software.amazon.awssdk.services.snowball.model.CancelJobRequest;
import software.amazon.awssdk.services.snowball.model.CancelJobResponse;
import software.amazon.awssdk.services.snowball.model.ClusterLimitExceededException;
import software.amazon.awssdk.services.snowball.model.ConflictException;
import software.amazon.awssdk.services.snowball.model.CreateAddressRequest;
import software.amazon.awssdk.services.snowball.model.CreateAddressResponse;
import software.amazon.awssdk.services.snowball.model.CreateClusterRequest;
import software.amazon.awssdk.services.snowball.model.CreateClusterResponse;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;
import software.amazon.awssdk.services.snowball.model.CreateJobResponse;
import software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.CreateLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest;
import software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.snowball.model.DescribeClusterRequest;
import software.amazon.awssdk.services.snowball.model.DescribeClusterResponse;
import software.amazon.awssdk.services.snowball.model.DescribeJobRequest;
import software.amazon.awssdk.services.snowball.model.DescribeJobResponse;
import software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest;
import software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelResponse;
import software.amazon.awssdk.services.snowball.model.Ec2RequestFailedException;
import software.amazon.awssdk.services.snowball.model.GetJobManifestRequest;
import software.amazon.awssdk.services.snowball.model.GetJobManifestResponse;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse;
import software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest;
import software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesResponse;
import software.amazon.awssdk.services.snowball.model.InvalidAddressException;
import software.amazon.awssdk.services.snowball.model.InvalidInputCombinationException;
import software.amazon.awssdk.services.snowball.model.InvalidJobStateException;
import software.amazon.awssdk.services.snowball.model.InvalidNextTokenException;
import software.amazon.awssdk.services.snowball.model.InvalidResourceException;
import software.amazon.awssdk.services.snowball.model.KmsRequestFailedException;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListClustersRequest;
import software.amazon.awssdk.services.snowball.model.ListClustersResponse;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse;
import software.amazon.awssdk.services.snowball.model.ListJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest;
import software.amazon.awssdk.services.snowball.model.ListPickupLocationsResponse;
import software.amazon.awssdk.services.snowball.model.ListServiceVersionsRequest;
import software.amazon.awssdk.services.snowball.model.ListServiceVersionsResponse;
import software.amazon.awssdk.services.snowball.model.ReturnShippingLabelAlreadyExistsException;
import software.amazon.awssdk.services.snowball.model.SnowballException;
import software.amazon.awssdk.services.snowball.model.UnsupportedAddressException;
import software.amazon.awssdk.services.snowball.model.UpdateClusterRequest;
import software.amazon.awssdk.services.snowball.model.UpdateClusterResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateResponse;
import software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable;
import software.amazon.awssdk.services.snowball.paginators.ListClusterJobsIterable;
import software.amazon.awssdk.services.snowball.paginators.ListClustersIterable;
import software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable;
import software.amazon.awssdk.services.snowball.paginators.ListJobsIterable;
import software.amazon.awssdk.services.snowball.paginators.ListLongTermPricingIterable;
import software.amazon.awssdk.services.snowball.paginators.ListPickupLocationsIterable;

/**
 * Service client for accessing Amazon Snowball. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Amazon Web Services Snow Family provides a petabyte-scale data transport solution that uses secure devices to
 * transfer large amounts of data between your on-premises data centers and Amazon Simple Storage Service (Amazon S3).
 * The Snow Family commands described here provide access to the same functionality that is available in the Amazon Web
 * Services Snow Family Management Console, which enables you to create and manage jobs for a Snow Family device. To
 * transfer data locally with a Snow Family device, you'll need to use the Snowball Edge client or the Amazon S3 API
 * Interface for Snowball or OpsHub for Snow Family. For more information, see the <a
 * href="https://docs.aws.amazon.com/AWSImportExport/latest/ug/api-reference.html">User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SnowballClient extends AwsClient {
    String SERVICE_NAME = "snowball";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "snowball";

    /**
     * <p>
     * Cancels a cluster job. You can only cancel a cluster job while it's in the <code>AwaitingQuorum</code> status.
     * You'll have at least an hour after creating a cluster job to cancel it.
     * </p>
     *
     * @param cancelClusterRequest
     * @return Result of the CancelCluster operation returned by the service.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CancelCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelClusterResponse cancelCluster(CancelClusterRequest cancelClusterRequest) throws KmsRequestFailedException,
            InvalidJobStateException, InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a cluster job. You can only cancel a cluster job while it's in the <code>AwaitingQuorum</code> status.
     * You'll have at least an hour after creating a cluster job to cancel it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CancelClusterRequest#builder()}
     * </p>
     *
     * @param cancelClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.CancelClusterRequest.Builder} to create a request.
     * @return Result of the CancelCluster operation returned by the service.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CancelCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelClusterResponse cancelCluster(Consumer<CancelClusterRequest.Builder> cancelClusterRequest)
            throws KmsRequestFailedException, InvalidJobStateException, InvalidResourceException, AwsServiceException,
            SdkClientException, SnowballException {
        return cancelCluster(CancelClusterRequest.builder().applyMutation(cancelClusterRequest).build());
    }

    /**
     * <p>
     * Cancels the specified job. You can only cancel a job before its <code>JobState</code> value changes to
     * <code>PreparingAppliance</code>. Requesting the <code>ListJobs</code> or <code>DescribeJob</code> action returns
     * a job's <code>JobState</code> as part of the response element data returned.
     * </p>
     *
     * @param cancelJobRequest
     * @return Result of the CancelJob operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CancelJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws InvalidResourceException,
            InvalidJobStateException, KmsRequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified job. You can only cancel a job before its <code>JobState</code> value changes to
     * <code>PreparingAppliance</code>. Requesting the <code>ListJobs</code> or <code>DescribeJob</code> action returns
     * a job's <code>JobState</code> as part of the response element data returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     * </p>
     *
     * @param cancelJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.CancelJobRequest.Builder} to create a request.
     * @return Result of the CancelJob operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CancelJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelJobResponse cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) throws InvalidResourceException,
            InvalidJobStateException, KmsRequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        return cancelJob(CancelJobRequest.builder().applyMutation(cancelJobRequest).build());
    }

    /**
     * <p>
     * Creates an address for a Snow device to be shipped to. In most regions, addresses are validated at the time of
     * creation. The address you provide must be located within the serviceable area of your region. If the address is
     * invalid or unsupported, then an exception is thrown.
     * </p>
     *
     * @param createAddressRequest
     * @return Result of the CreateAddress operation returned by the service.
     * @throws InvalidAddressException
     *         The address provided was invalid. Check the address with your region's carrier, and try again.
     * @throws UnsupportedAddressException
     *         The address is either outside the serviceable area for your region, or an error occurred. Check the
     *         address with your region's carrier and try again. If the issue persists, contact Amazon Web Services
     *         Support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAddressResponse createAddress(CreateAddressRequest createAddressRequest) throws InvalidAddressException,
            UnsupportedAddressException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an address for a Snow device to be shipped to. In most regions, addresses are validated at the time of
     * creation. The address you provide must be located within the serviceable area of your region. If the address is
     * invalid or unsupported, then an exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddressRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAddressRequest#builder()}
     * </p>
     *
     * @param createAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.CreateAddressRequest.Builder} to create a request.
     * @return Result of the CreateAddress operation returned by the service.
     * @throws InvalidAddressException
     *         The address provided was invalid. Check the address with your region's carrier, and try again.
     * @throws UnsupportedAddressException
     *         The address is either outside the serviceable area for your region, or an error occurred. Check the
     *         address with your region's carrier and try again. If the issue persists, contact Amazon Web Services
     *         Support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAddressResponse createAddress(Consumer<CreateAddressRequest.Builder> createAddressRequest)
            throws InvalidAddressException, UnsupportedAddressException, AwsServiceException, SdkClientException,
            SnowballException {
        return createAddress(CreateAddressRequest.builder().applyMutation(createAddressRequest).build());
    }

    /**
     * <p>
     * Creates an empty cluster. Each cluster supports five nodes. You use the <a>CreateJob</a> action separately to
     * create the jobs for each of these nodes. The cluster does not ship until these five node jobs have been created.
     * </p>
     *
     * @param createClusterRequest
     * @return Result of the CreateCluster operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws InvalidResourceException,
            KmsRequestFailedException, InvalidInputCombinationException, Ec2RequestFailedException, AwsServiceException,
            SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty cluster. Each cluster supports five nodes. You use the <a>CreateJob</a> action separately to
     * create the jobs for each of these nodes. The cluster does not ship until these five node jobs have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.CreateClusterRequest.Builder} to create a request.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws InvalidResourceException, KmsRequestFailedException, InvalidInputCombinationException,
            Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates a job to import or export data between Amazon S3 and your on-premises data center. Your Amazon Web
     * Services account must have the right trust policies and permissions in place to create a job for a Snow device.
     * If you're creating a job for a node in a cluster, you only need to provide the <code>clusterId</code> value; the
     * other job attributes are inherited from the cluster.
     * </p>
     * <note>
     * <p>
     * Only the Snowball; Edge device type is supported when ordering clustered jobs.
     * </p>
     * <p>
     * The device capacity is optional.
     * </p>
     * <p>
     * Availability of device types differ by Amazon Web Services Region. For more information about Region
     * availability, see <a
     * href="https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/?p=ngi&amp;loc=4">Amazon
     * Web Services Regional Services</a>.
     * </p>
     * </note>
     * <p/>
     * <p class="title">
     * <b>Snow Family devices and their capacities.</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Device type: <b>SNC1_SSD</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T14
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowcone
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>SNC1_HDD</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T8
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowcone
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>EDGE_S</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T98
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Storage Optimized for data transfer only
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>EDGE_CG</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T42
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Compute Optimized with GPU
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>EDGE_C</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T42
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Compute Optimized without GPU
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>EDGE</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T100
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Storage Optimized with EC2 Compute
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This device is replaced with T98.
     * </p>
     * </note>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>STANDARD</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T50
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Original Snowball device
     * </p>
     * <note>
     * <p>
     * This device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region
     * </p>
     * </note></li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>STANDARD</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T80
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Original Snowball device
     * </p>
     * <note>
     * <p>
     * This device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region.
     * </p>
     * </note></li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Snow Family device type: <b>RACK_5U_C</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T13
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowblade.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Device type: <b>V3_5S</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T240
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Storage Optimized 210TB
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws ClusterLimitExceededException
     *         Job creation failed. Currently, clusters support five nodes. If you have fewer than five nodes for your
     *         cluster and you have more nodes to create for this cluster, try again and create jobs until your cluster
     *         has exactly five nodes.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidResourceException,
            KmsRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException,
            Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job to import or export data between Amazon S3 and your on-premises data center. Your Amazon Web
     * Services account must have the right trust policies and permissions in place to create a job for a Snow device.
     * If you're creating a job for a node in a cluster, you only need to provide the <code>clusterId</code> value; the
     * other job attributes are inherited from the cluster.
     * </p>
     * <note>
     * <p>
     * Only the Snowball; Edge device type is supported when ordering clustered jobs.
     * </p>
     * <p>
     * The device capacity is optional.
     * </p>
     * <p>
     * Availability of device types differ by Amazon Web Services Region. For more information about Region
     * availability, see <a
     * href="https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/?p=ngi&amp;loc=4">Amazon
     * Web Services Regional Services</a>.
     * </p>
     * </note>
     * <p/>
     * <p class="title">
     * <b>Snow Family devices and their capacities.</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Device type: <b>SNC1_SSD</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T14
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowcone
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>SNC1_HDD</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T8
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowcone
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>EDGE_S</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T98
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Storage Optimized for data transfer only
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>EDGE_CG</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T42
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Compute Optimized with GPU
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>EDGE_C</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T42
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Compute Optimized without GPU
     * </p>
     * </li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>EDGE</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T100
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Storage Optimized with EC2 Compute
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This device is replaced with T98.
     * </p>
     * </note>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>STANDARD</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T50
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Original Snowball device
     * </p>
     * <note>
     * <p>
     * This device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region
     * </p>
     * </note></li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Device type: <b>STANDARD</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T80
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Original Snowball device
     * </p>
     * <note>
     * <p>
     * This device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region.
     * </p>
     * </note></li>
     * </ul>
     * <p/></li>
     * <li>
     * <p>
     * Snow Family device type: <b>RACK_5U_C</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T13
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowblade.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Device type: <b>V3_5S</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Capacity: T240
     * </p>
     * </li>
     * <li>
     * <p>
     * Description: Snowball Edge Storage Optimized 210TB
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.CreateJobRequest.Builder} to create a request.
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws ClusterLimitExceededException
     *         Job creation failed. Currently, clusters support five nodes. If you have fewer than five nodes for your
     *         cluster and you have more nodes to create for this cluster, try again and create jobs until your cluster
     *         has exactly five nodes.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws InvalidResourceException,
            KmsRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException,
            Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * Creates a job with the long-term usage option for a device. The long-term usage is a 1-year or 3-year long-term
     * pricing type for the device. You are billed upfront, and Amazon Web Services provides discounts for long-term
     * pricing.
     * </p>
     *
     * @param createLongTermPricingRequest
     * @return Result of the CreateLongTermPricing operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateLongTermPricing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateLongTermPricing"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLongTermPricingResponse createLongTermPricing(CreateLongTermPricingRequest createLongTermPricingRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job with the long-term usage option for a device. The long-term usage is a 1-year or 3-year long-term
     * pricing type for the device. You are billed upfront, and Amazon Web Services provides discounts for long-term
     * pricing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLongTermPricingRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLongTermPricingRequest#builder()}
     * </p>
     *
     * @param createLongTermPricingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.CreateLongTermPricingRequest.Builder} to create a
     *        request.
     * @return Result of the CreateLongTermPricing operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateLongTermPricing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateLongTermPricing"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLongTermPricingResponse createLongTermPricing(
            Consumer<CreateLongTermPricingRequest.Builder> createLongTermPricingRequest) throws InvalidResourceException,
            AwsServiceException, SdkClientException, SnowballException {
        return createLongTermPricing(CreateLongTermPricingRequest.builder().applyMutation(createLongTermPricingRequest).build());
    }

    /**
     * <p>
     * Creates a shipping label that will be used to return the Snow device to Amazon Web Services.
     * </p>
     *
     * @param createReturnShippingLabelRequest
     * @return Result of the CreateReturnShippingLabel operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws ConflictException
     *         You get this exception when you call <code>CreateReturnShippingLabel</code> more than once when other
     *         requests are not completed.
     * @throws ReturnShippingLabelAlreadyExistsException
     *         You get this exception if you call <code>CreateReturnShippingLabel</code> and a valid return shipping
     *         label already exists. In this case, use <code>DescribeReturnShippingLabel</code> to get the URL.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateReturnShippingLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateReturnShippingLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReturnShippingLabelResponse createReturnShippingLabel(
            CreateReturnShippingLabelRequest createReturnShippingLabelRequest) throws InvalidResourceException,
            InvalidJobStateException, InvalidInputCombinationException, ConflictException,
            ReturnShippingLabelAlreadyExistsException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a shipping label that will be used to return the Snow device to Amazon Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReturnShippingLabelRequest.Builder} avoiding
     * the need to create one manually via {@link CreateReturnShippingLabelRequest#builder()}
     * </p>
     *
     * @param createReturnShippingLabelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.CreateReturnShippingLabelRequest.Builder} to create
     *        a request.
     * @return Result of the CreateReturnShippingLabel operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws ConflictException
     *         You get this exception when you call <code>CreateReturnShippingLabel</code> more than once when other
     *         requests are not completed.
     * @throws ReturnShippingLabelAlreadyExistsException
     *         You get this exception if you call <code>CreateReturnShippingLabel</code> and a valid return shipping
     *         label already exists. In this case, use <code>DescribeReturnShippingLabel</code> to get the URL.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.CreateReturnShippingLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateReturnShippingLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReturnShippingLabelResponse createReturnShippingLabel(
            Consumer<CreateReturnShippingLabelRequest.Builder> createReturnShippingLabelRequest) throws InvalidResourceException,
            InvalidJobStateException, InvalidInputCombinationException, ConflictException,
            ReturnShippingLabelAlreadyExistsException, AwsServiceException, SdkClientException, SnowballException {
        return createReturnShippingLabel(CreateReturnShippingLabelRequest.builder()
                .applyMutation(createReturnShippingLabelRequest).build());
    }

    /**
     * <p>
     * Takes an <code>AddressId</code> and returns specific details about that address in the form of an
     * <code>Address</code> object.
     * </p>
     *
     * @param describeAddressRequest
     * @return Result of the DescribeAddress operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAddressResponse describeAddress(DescribeAddressRequest describeAddressRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Takes an <code>AddressId</code> and returns specific details about that address in the form of an
     * <code>Address</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddressRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAddressRequest#builder()}
     * </p>
     *
     * @param describeAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.DescribeAddressRequest.Builder} to create a request.
     * @return Result of the DescribeAddress operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAddressResponse describeAddress(Consumer<DescribeAddressRequest.Builder> describeAddressRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        return describeAddress(DescribeAddressRequest.builder().applyMutation(describeAddressRequest).build());
    }

    /**
     * <p>
     * Returns a specified number of <code>ADDRESS</code> objects. Calling this API in one of the US regions will return
     * addresses from the list of all addresses associated with this account in all US regions.
     * </p>
     *
     * @param describeAddressesRequest
     * @return Result of the DescribeAddresses operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAddressesResponse describeAddresses(DescribeAddressesRequest describeAddressesRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified number of <code>ADDRESS</code> objects. Calling this API in one of the US regions will return
     * addresses from the list of all addresses associated with this account in all US regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddressesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAddressesRequest#builder()}
     * </p>
     *
     * @param describeAddressesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAddresses operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAddressesResponse describeAddresses(Consumer<DescribeAddressesRequest.Builder> describeAddressesRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return describeAddresses(DescribeAddressesRequest.builder().applyMutation(describeAddressesRequest).build());
    }

    /**
     * <p>
     * Returns a specified number of <code>ADDRESS</code> objects. Calling this API in one of the US regions will return
     * addresses from the list of all addresses associated with this account in all US regions.
     * </p>
     *
     * @return Result of the DescribeAddresses operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeAddresses
     * @see #describeAddresses(DescribeAddressesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAddressesResponse describeAddresses() throws InvalidResourceException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SnowballException {
        return describeAddresses(DescribeAddressesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a specified number of <code>ADDRESS</code> objects. Calling this API in one of the US regions will return
     * addresses from the list of all addresses associated with this account in all US regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAddresses(software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client.describeAddressesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client
     *             .describeAddressesPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client.describeAddressesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAddresses(software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeAddresses
     * @see #describeAddressesPaginator(DescribeAddressesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAddressesIterable describeAddressesPaginator() throws InvalidResourceException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SnowballException {
        return describeAddressesPaginator(DescribeAddressesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a specified number of <code>ADDRESS</code> objects. Calling this API in one of the US regions will return
     * addresses from the list of all addresses associated with this account in all US regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAddresses(software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client.describeAddressesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client
     *             .describeAddressesPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client.describeAddressesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAddresses(software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAddressesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAddressesIterable describeAddressesPaginator(DescribeAddressesRequest describeAddressesRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return new DescribeAddressesIterable(this, describeAddressesRequest);
    }

    /**
     * <p>
     * Returns a specified number of <code>ADDRESS</code> objects. Calling this API in one of the US regions will return
     * addresses from the list of all addresses associated with this account in all US regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAddresses(software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client.describeAddressesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client
     *             .describeAddressesPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.DescribeAddressesIterable responses = client.describeAddressesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAddresses(software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAddressesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAddressesRequest#builder()}
     * </p>
     *
     * @param describeAddressesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAddressesIterable describeAddressesPaginator(
            Consumer<DescribeAddressesRequest.Builder> describeAddressesRequest) throws InvalidResourceException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        return describeAddressesPaginator(DescribeAddressesRequest.builder().applyMutation(describeAddressesRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific cluster including shipping information, cluster status, and other important
     * metadata.
     * </p>
     *
     * @param describeClusterRequest
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific cluster including shipping information, cluster status, and other important
     * metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.DescribeClusterRequest.Builder} to create a request.
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific job including shipping information, job status, and other important
     * metadata.
     * </p>
     *
     * @param describeJobRequest
     * @return Result of the DescribeJob operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws InvalidResourceException,
            AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific job including shipping information, job status, and other important
     * metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobRequest#builder()}
     * </p>
     *
     * @param describeJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.DescribeJobRequest.Builder} to create a request.
     * @return Result of the DescribeJob operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobResponse describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        return describeJob(DescribeJobRequest.builder().applyMutation(describeJobRequest).build());
    }

    /**
     * <p>
     * Information on the shipping label of a Snow device that is being returned to Amazon Web Services.
     * </p>
     *
     * @param describeReturnShippingLabelRequest
     * @return Result of the DescribeReturnShippingLabel operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws ConflictException
     *         You get this exception when you call <code>CreateReturnShippingLabel</code> more than once when other
     *         requests are not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeReturnShippingLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeReturnShippingLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReturnShippingLabelResponse describeReturnShippingLabel(
            DescribeReturnShippingLabelRequest describeReturnShippingLabelRequest) throws InvalidResourceException,
            InvalidJobStateException, ConflictException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information on the shipping label of a Snow device that is being returned to Amazon Web Services.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReturnShippingLabelRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReturnShippingLabelRequest#builder()}
     * </p>
     *
     * @param describeReturnShippingLabelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.DescribeReturnShippingLabelRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeReturnShippingLabel operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws ConflictException
     *         You get this exception when you call <code>CreateReturnShippingLabel</code> more than once when other
     *         requests are not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.DescribeReturnShippingLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeReturnShippingLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReturnShippingLabelResponse describeReturnShippingLabel(
            Consumer<DescribeReturnShippingLabelRequest.Builder> describeReturnShippingLabelRequest)
            throws InvalidResourceException, InvalidJobStateException, ConflictException, AwsServiceException,
            SdkClientException, SnowballException {
        return describeReturnShippingLabel(DescribeReturnShippingLabelRequest.builder()
                .applyMutation(describeReturnShippingLabelRequest).build());
    }

    /**
     * <p>
     * Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified
     * <code>JobId</code> value. You can access the manifest file for up to 60 minutes after this request has been made.
     * To access the manifest file after 60 minutes have passed, you'll have to make another call to the
     * <code>GetJobManifest</code> action.
     * </p>
     * <p>
     * The manifest is an encrypted file that you can download after your job enters the <code>WithCustomer</code>
     * status. This is the only valid status for calling this API as the manifest and <code>UnlockCode</code> code value
     * are used for securing your device and should only be used when you have the device. The manifest is decrypted by
     * using the <code>UnlockCode</code> code value, when you pass both values to the Snow device through the Snowball
     * client when the client is started for the first time.
     * </p>
     * <p>
     * As a best practice, we recommend that you don't save a copy of an <code>UnlockCode</code> value in the same
     * location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from
     * gaining access to the Snow device associated with that job.
     * </p>
     * <p>
     * The credentials of a given job, including its manifest file and unlock code, expire 360 days after the job is
     * created.
     * </p>
     *
     * @param getJobManifestRequest
     * @return Result of the GetJobManifest operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetJobManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobManifest" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobManifestResponse getJobManifest(GetJobManifestRequest getJobManifestRequest) throws InvalidResourceException,
            InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified
     * <code>JobId</code> value. You can access the manifest file for up to 60 minutes after this request has been made.
     * To access the manifest file after 60 minutes have passed, you'll have to make another call to the
     * <code>GetJobManifest</code> action.
     * </p>
     * <p>
     * The manifest is an encrypted file that you can download after your job enters the <code>WithCustomer</code>
     * status. This is the only valid status for calling this API as the manifest and <code>UnlockCode</code> code value
     * are used for securing your device and should only be used when you have the device. The manifest is decrypted by
     * using the <code>UnlockCode</code> code value, when you pass both values to the Snow device through the Snowball
     * client when the client is started for the first time.
     * </p>
     * <p>
     * As a best practice, we recommend that you don't save a copy of an <code>UnlockCode</code> value in the same
     * location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from
     * gaining access to the Snow device associated with that job.
     * </p>
     * <p>
     * The credentials of a given job, including its manifest file and unlock code, expire 360 days after the job is
     * created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobManifestRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobManifestRequest#builder()}
     * </p>
     *
     * @param getJobManifestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.GetJobManifestRequest.Builder} to create a request.
     * @return Result of the GetJobManifest operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetJobManifest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobManifest" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobManifestResponse getJobManifest(Consumer<GetJobManifestRequest.Builder> getJobManifestRequest)
            throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        return getJobManifest(GetJobManifestRequest.builder().applyMutation(getJobManifestRequest).build());
    }

    /**
     * <p>
     * Returns the <code>UnlockCode</code> code value for the specified job. A particular <code>UnlockCode</code> value
     * can be accessed for up to 360 days after the associated job has been created.
     * </p>
     * <p>
     * The <code>UnlockCode</code> value is a 29-character code with 25 alphanumeric characters and 4 hyphens. This code
     * is used to decrypt the manifest file when it is passed along with the manifest to the Snow device through the
     * Snowball client when the client is started for the first time. The only valid status for calling this API is
     * <code>WithCustomer</code> as the manifest and <code>Unlock</code> code values are used for securing your device
     * and should only be used when you have the device.
     * </p>
     * <p>
     * As a best practice, we recommend that you don't save a copy of the <code>UnlockCode</code> in the same location
     * as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access
     * to the Snow device associated with that job.
     * </p>
     *
     * @param getJobUnlockCodeRequest
     * @return Result of the GetJobUnlockCode operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetJobUnlockCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobUnlockCode" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobUnlockCodeResponse getJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest)
            throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>UnlockCode</code> code value for the specified job. A particular <code>UnlockCode</code> value
     * can be accessed for up to 360 days after the associated job has been created.
     * </p>
     * <p>
     * The <code>UnlockCode</code> value is a 29-character code with 25 alphanumeric characters and 4 hyphens. This code
     * is used to decrypt the manifest file when it is passed along with the manifest to the Snow device through the
     * Snowball client when the client is started for the first time. The only valid status for calling this API is
     * <code>WithCustomer</code> as the manifest and <code>Unlock</code> code values are used for securing your device
     * and should only be used when you have the device.
     * </p>
     * <p>
     * As a best practice, we recommend that you don't save a copy of the <code>UnlockCode</code> in the same location
     * as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access
     * to the Snow device associated with that job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobUnlockCodeRequest.Builder} avoiding the need
     * to create one manually via {@link GetJobUnlockCodeRequest#builder()}
     * </p>
     *
     * @param getJobUnlockCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest.Builder} to create a
     *        request.
     * @return Result of the GetJobUnlockCode operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetJobUnlockCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobUnlockCode" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobUnlockCodeResponse getJobUnlockCode(Consumer<GetJobUnlockCodeRequest.Builder> getJobUnlockCodeRequest)
            throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        return getJobUnlockCode(GetJobUnlockCodeRequest.builder().applyMutation(getJobUnlockCodeRequest).build());
    }

    /**
     * <p>
     * Returns information about the Snow Family service limit for your account, and also the number of Snow devices
     * your account has in use.
     * </p>
     * <p>
     * The default service limit for the number of Snow devices that you can have at one time is 1. If you want to
     * increase your service limit, contact Amazon Web Services Support.
     * </p>
     *
     * @param getSnowballUsageRequest
     * @return Result of the GetSnowballUsage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetSnowballUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSnowballUsage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnowballUsageResponse getSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest)
            throws AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the Snow Family service limit for your account, and also the number of Snow devices
     * your account has in use.
     * </p>
     * <p>
     * The default service limit for the number of Snow devices that you can have at one time is 1. If you want to
     * increase your service limit, contact Amazon Web Services Support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnowballUsageRequest.Builder} avoiding the need
     * to create one manually via {@link GetSnowballUsageRequest#builder()}
     * </p>
     *
     * @param getSnowballUsageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest.Builder} to create a
     *        request.
     * @return Result of the GetSnowballUsage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetSnowballUsage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSnowballUsage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnowballUsageResponse getSnowballUsage(Consumer<GetSnowballUsageRequest.Builder> getSnowballUsageRequest)
            throws AwsServiceException, SdkClientException, SnowballException {
        return getSnowballUsage(GetSnowballUsageRequest.builder().applyMutation(getSnowballUsageRequest).build());
    }

    /**
     * <p>
     * Returns information about the Snow Family service limit for your account, and also the number of Snow devices
     * your account has in use.
     * </p>
     * <p>
     * The default service limit for the number of Snow devices that you can have at one time is 1. If you want to
     * increase your service limit, contact Amazon Web Services Support.
     * </p>
     *
     * @return Result of the GetSnowballUsage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetSnowballUsage
     * @see #getSnowballUsage(GetSnowballUsageRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSnowballUsage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnowballUsageResponse getSnowballUsage() throws AwsServiceException, SdkClientException, SnowballException {
        return getSnowballUsage(GetSnowballUsageRequest.builder().build());
    }

    /**
     * <p>
     * Returns an Amazon S3 presigned URL for an update file associated with a specified <code>JobId</code>.
     * </p>
     *
     * @param getSoftwareUpdatesRequest
     * @return Result of the GetSoftwareUpdates operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetSoftwareUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSoftwareUpdates" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSoftwareUpdatesResponse getSoftwareUpdates(GetSoftwareUpdatesRequest getSoftwareUpdatesRequest)
            throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an Amazon S3 presigned URL for an update file associated with a specified <code>JobId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSoftwareUpdatesRequest.Builder} avoiding the
     * need to create one manually via {@link GetSoftwareUpdatesRequest#builder()}
     * </p>
     *
     * @param getSoftwareUpdatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.GetSoftwareUpdatesRequest.Builder} to create a
     *        request.
     * @return Result of the GetSoftwareUpdates operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.GetSoftwareUpdates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSoftwareUpdates" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSoftwareUpdatesResponse getSoftwareUpdates(Consumer<GetSoftwareUpdatesRequest.Builder> getSoftwareUpdatesRequest)
            throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        return getSoftwareUpdates(GetSoftwareUpdatesRequest.builder().applyMutation(getSoftwareUpdatesRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.
     * </p>
     *
     * @param listClusterJobsRequest
     * @return Result of the ListClusterJobs operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusterJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusterJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClusterJobsResponse listClusterJobs(ListClusterJobsRequest listClusterJobsRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListClusterJobsRequest#builder()}
     * </p>
     *
     * @param listClusterJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest.Builder} to create a request.
     * @return Result of the ListClusterJobs operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusterJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusterJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClusterJobsResponse listClusterJobs(Consumer<ListClusterJobsRequest.Builder> listClusterJobsRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return listClusterJobs(ListClusterJobsRequest.builder().applyMutation(listClusterJobsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClusterJobs(software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClusterJobsIterable responses = client.listClusterJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListClusterJobsIterable responses = client
     *             .listClusterJobsPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClusterJobsIterable responses = client.listClusterJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterJobs(software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest)} operation.</b>
     * </p>
     *
     * @param listClusterJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusterJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusterJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClusterJobsIterable listClusterJobsPaginator(ListClusterJobsRequest listClusterJobsRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return new ListClusterJobsIterable(this, listClusterJobsRequest);
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClusterJobs(software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClusterJobsIterable responses = client.listClusterJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListClusterJobsIterable responses = client
     *             .listClusterJobsPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClusterJobsIterable responses = client.listClusterJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterJobs(software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListClusterJobsRequest#builder()}
     * </p>
     *
     * @param listClusterJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusterJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusterJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClusterJobsIterable listClusterJobsPaginator(Consumer<ListClusterJobsRequest.Builder> listClusterJobsRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return listClusterJobsPaginator(ListClusterJobsRequest.builder().applyMutation(listClusterJobsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterListEntry</code> objects of the specified length. Each
     * <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status
     * information.
     * </p>
     *
     * @param listClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>ClusterListEntry</code> objects of the specified length. Each
     * <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status
     * information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListClustersRequest.Builder} to create a request.
     * @return Result of the ListClusters operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterListEntry</code> objects of the specified length. Each
     * <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status
     * information.
     * </p>
     *
     * @return Result of the ListClusters operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusters
     * @see #listClusters(ListClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersResponse listClusters() throws InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return listClusters(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterListEntry</code> objects of the specified length. Each
     * <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status
     * information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.snowball.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.snowball.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusters
     * @see #listClustersPaginator(ListClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator() throws InvalidNextTokenException, AwsServiceException,
            SdkClientException, SnowballException {
        return listClustersPaginator(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterListEntry</code> objects of the specified length. Each
     * <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status
     * information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.snowball.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.snowball.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, SnowballException {
        return new ListClustersIterable(this, listClustersRequest);
    }

    /**
     * <p>
     * Returns an array of <code>ClusterListEntry</code> objects of the specified length. Each
     * <code>ClusterListEntry</code> object contains a cluster's state, a cluster's ID, and other important status
     * information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.snowball.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.snowball.model.ListClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListClustersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by
     * your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are
     * based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the
     * Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market,
     * but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
     * </p>
     *
     * @param listCompatibleImagesRequest
     * @return Result of the ListCompatibleImages operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListCompatibleImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompatibleImagesResponse listCompatibleImages(ListCompatibleImagesRequest listCompatibleImagesRequest)
            throws InvalidNextTokenException, Ec2RequestFailedException, AwsServiceException, SdkClientException,
            SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by
     * your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are
     * based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the
     * Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market,
     * but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCompatibleImagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCompatibleImagesRequest#builder()}
     * </p>
     *
     * @param listCompatibleImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest.Builder} to create a
     *        request.
     * @return Result of the ListCompatibleImages operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListCompatibleImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompatibleImagesResponse listCompatibleImages(
            Consumer<ListCompatibleImagesRequest.Builder> listCompatibleImagesRequest) throws InvalidNextTokenException,
            Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        return listCompatibleImages(ListCompatibleImagesRequest.builder().applyMutation(listCompatibleImagesRequest).build());
    }

    /**
     * <p>
     * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by
     * your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are
     * based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the
     * Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market,
     * but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
     * </p>
     *
     * @return Result of the ListCompatibleImages operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListCompatibleImages
     * @see #listCompatibleImages(ListCompatibleImagesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompatibleImagesResponse listCompatibleImages() throws InvalidNextTokenException, Ec2RequestFailedException,
            AwsServiceException, SdkClientException, SnowballException {
        return listCompatibleImages(ListCompatibleImagesRequest.builder().build());
    }

    /**
     * <p>
     * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by
     * your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are
     * based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the
     * Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market,
     * but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCompatibleImages(software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client.listCompatibleImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client
     *             .listCompatibleImagesPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client.listCompatibleImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompatibleImages(software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListCompatibleImages
     * @see #listCompatibleImagesPaginator(ListCompatibleImagesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompatibleImagesIterable listCompatibleImagesPaginator() throws InvalidNextTokenException,
            Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        return listCompatibleImagesPaginator(ListCompatibleImagesRequest.builder().build());
    }

    /**
     * <p>
     * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by
     * your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are
     * based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the
     * Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market,
     * but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCompatibleImages(software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client.listCompatibleImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client
     *             .listCompatibleImagesPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client.listCompatibleImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompatibleImages(software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCompatibleImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListCompatibleImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompatibleImagesIterable listCompatibleImagesPaginator(ListCompatibleImagesRequest listCompatibleImagesRequest)
            throws InvalidNextTokenException, Ec2RequestFailedException, AwsServiceException, SdkClientException,
            SnowballException {
        return new ListCompatibleImagesIterable(this, listCompatibleImagesRequest);
    }

    /**
     * <p>
     * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by
     * your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are
     * based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the
     * Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market,
     * but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCompatibleImages(software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client.listCompatibleImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client
     *             .listCompatibleImagesPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListCompatibleImagesIterable responses = client.listCompatibleImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompatibleImages(software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCompatibleImagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCompatibleImagesRequest#builder()}
     * </p>
     *
     * @param listCompatibleImagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListCompatibleImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompatibleImagesIterable listCompatibleImagesPaginator(
            Consumer<ListCompatibleImagesRequest.Builder> listCompatibleImagesRequest) throws InvalidNextTokenException,
            Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        return listCompatibleImagesPaginator(ListCompatibleImagesRequest.builder().applyMutation(listCompatibleImagesRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case
     * of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs
     * associated with this account in all US regions.
     * </p>
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidNextTokenException, AwsServiceException,
            SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case
     * of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs
     * associated with this account in all US regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListJobsRequest.Builder} to create a request.
     * @return Result of the ListJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, SnowballException {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case
     * of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs
     * associated with this account in all US regions.
     * </p>
     *
     * @return Result of the ListJobs operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListJobs
     * @see #listJobs(ListJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs() throws InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return listJobs(ListJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case
     * of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs
     * associated with this account in all US regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.snowball.model.ListJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.snowball.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListJobs
     * @see #listJobsPaginator(ListJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator() throws InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return listJobsPaginator(ListJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case
     * of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs
     * associated with this account in all US regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.snowball.model.ListJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.snowball.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws InvalidNextTokenException,
            AwsServiceException, SdkClientException, SnowballException {
        return new ListJobsIterable(this, listJobsRequest);
    }

    /**
     * <p>
     * Returns an array of <code>JobListEntry</code> objects of the specified length. Each <code>JobListEntry</code>
     * object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case
     * of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs
     * associated with this account in all US regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.snowball.model.ListJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.snowball.model.ListJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest)
            throws InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Lists all long-term pricing types.
     * </p>
     *
     * @param listLongTermPricingRequest
     * @return Result of the ListLongTermPricing operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListLongTermPricing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListLongTermPricing" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLongTermPricingResponse listLongTermPricing(ListLongTermPricingRequest listLongTermPricingRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all long-term pricing types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLongTermPricingRequest.Builder} avoiding the
     * need to create one manually via {@link ListLongTermPricingRequest#builder()}
     * </p>
     *
     * @param listLongTermPricingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest.Builder} to create a
     *        request.
     * @return Result of the ListLongTermPricing operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListLongTermPricing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListLongTermPricing" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLongTermPricingResponse listLongTermPricing(
            Consumer<ListLongTermPricingRequest.Builder> listLongTermPricingRequest) throws InvalidResourceException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        return listLongTermPricing(ListLongTermPricingRequest.builder().applyMutation(listLongTermPricingRequest).build());
    }

    /**
     * <p>
     * Lists all long-term pricing types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLongTermPricing(software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListLongTermPricingIterable responses = client.listLongTermPricingPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListLongTermPricingIterable responses = client
     *             .listLongTermPricingPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListLongTermPricingIterable responses = client.listLongTermPricingPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLongTermPricing(software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLongTermPricingRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListLongTermPricing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListLongTermPricing" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLongTermPricingIterable listLongTermPricingPaginator(ListLongTermPricingRequest listLongTermPricingRequest)
            throws InvalidResourceException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            SnowballException {
        return new ListLongTermPricingIterable(this, listLongTermPricingRequest);
    }

    /**
     * <p>
     * Lists all long-term pricing types.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLongTermPricing(software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListLongTermPricingIterable responses = client.listLongTermPricingPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListLongTermPricingIterable responses = client
     *             .listLongTermPricingPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListLongTermPricingIterable responses = client.listLongTermPricingPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLongTermPricing(software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLongTermPricingRequest.Builder} avoiding the
     * need to create one manually via {@link ListLongTermPricingRequest#builder()}
     * </p>
     *
     * @param listLongTermPricingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListLongTermPricing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListLongTermPricing" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLongTermPricingIterable listLongTermPricingPaginator(
            Consumer<ListLongTermPricingRequest.Builder> listLongTermPricingRequest) throws InvalidResourceException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SnowballException {
        return listLongTermPricingPaginator(ListLongTermPricingRequest.builder().applyMutation(listLongTermPricingRequest)
                .build());
    }

    /**
     * <p>
     * A list of locations from which the customer can choose to pickup a device.
     * </p>
     *
     * @param listPickupLocationsRequest
     * @return Result of the ListPickupLocations operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListPickupLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListPickupLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPickupLocationsResponse listPickupLocations(ListPickupLocationsRequest listPickupLocationsRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of locations from which the customer can choose to pickup a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPickupLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPickupLocationsRequest#builder()}
     * </p>
     *
     * @param listPickupLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListPickupLocations operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListPickupLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListPickupLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPickupLocationsResponse listPickupLocations(
            Consumer<ListPickupLocationsRequest.Builder> listPickupLocationsRequest) throws InvalidResourceException,
            AwsServiceException, SdkClientException, SnowballException {
        return listPickupLocations(ListPickupLocationsRequest.builder().applyMutation(listPickupLocationsRequest).build());
    }

    /**
     * <p>
     * A list of locations from which the customer can choose to pickup a device.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPickupLocations(software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListPickupLocationsIterable responses = client.listPickupLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListPickupLocationsIterable responses = client
     *             .listPickupLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListPickupLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListPickupLocationsIterable responses = client.listPickupLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPickupLocations(software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPickupLocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListPickupLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListPickupLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPickupLocationsIterable listPickupLocationsPaginator(ListPickupLocationsRequest listPickupLocationsRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        return new ListPickupLocationsIterable(this, listPickupLocationsRequest);
    }

    /**
     * <p>
     * A list of locations from which the customer can choose to pickup a device.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPickupLocations(software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListPickupLocationsIterable responses = client.listPickupLocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowball.paginators.ListPickupLocationsIterable responses = client
     *             .listPickupLocationsPaginator(request);
     *     for (software.amazon.awssdk.services.snowball.model.ListPickupLocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowball.paginators.ListPickupLocationsIterable responses = client.listPickupLocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPickupLocations(software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPickupLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPickupLocationsRequest#builder()}
     * </p>
     *
     * @param listPickupLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListPickupLocationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListPickupLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListPickupLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPickupLocationsIterable listPickupLocationsPaginator(
            Consumer<ListPickupLocationsRequest.Builder> listPickupLocationsRequest) throws InvalidResourceException,
            AwsServiceException, SdkClientException, SnowballException {
        return listPickupLocationsPaginator(ListPickupLocationsRequest.builder().applyMutation(listPickupLocationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all supported versions for Snow on-device services. Returns an array of <code>ServiceVersion</code> object
     * containing the supported versions for a particular service.
     * </p>
     *
     * @param listServiceVersionsRequest
     * @return Result of the ListServiceVersions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListServiceVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListServiceVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServiceVersionsResponse listServiceVersions(ListServiceVersionsRequest listServiceVersionsRequest)
            throws InvalidNextTokenException, InvalidResourceException, AwsServiceException, SdkClientException,
            SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all supported versions for Snow on-device services. Returns an array of <code>ServiceVersion</code> object
     * containing the supported versions for a particular service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceVersionsRequest#builder()}
     * </p>
     *
     * @param listServiceVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.ListServiceVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListServiceVersions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> string was altered unexpectedly, and the operation has stopped. Run the
     *         operation without changing the <code>NextToken</code> string, and try again.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.ListServiceVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListServiceVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServiceVersionsResponse listServiceVersions(
            Consumer<ListServiceVersionsRequest.Builder> listServiceVersionsRequest) throws InvalidNextTokenException,
            InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        return listServiceVersions(ListServiceVersionsRequest.builder().applyMutation(listServiceVersionsRequest).build());
    }

    /**
     * <p>
     * While a cluster's <code>ClusterState</code> value is in the <code>AwaitingQuorum</code> state, you can update
     * some of the information associated with a cluster. Once the cluster changes to a different job state, usually 60
     * minutes after the cluster being created, this action is no longer available.
     * </p>
     *
     * @param updateClusterRequest
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws InvalidResourceException,
            InvalidJobStateException, KmsRequestFailedException, InvalidInputCombinationException, Ec2RequestFailedException,
            AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * While a cluster's <code>ClusterState</code> value is in the <code>AwaitingQuorum</code> state, you can update
     * some of the information associated with a cluster. Once the cluster changes to a different job state, usually 60
     * minutes after the cluster being created, this action is no longer available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateClusterRequest#builder()}
     * </p>
     *
     * @param updateClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.UpdateClusterRequest.Builder} to create a request.
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateClusterResponse updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest)
            throws InvalidResourceException, InvalidJobStateException, KmsRequestFailedException,
            InvalidInputCombinationException, Ec2RequestFailedException, AwsServiceException, SdkClientException,
            SnowballException {
        return updateCluster(UpdateClusterRequest.builder().applyMutation(updateClusterRequest).build());
    }

    /**
     * <p>
     * While a job's <code>JobState</code> value is <code>New</code>, you can update some of the information associated
     * with a job. Once the job changes to a different job state, usually within 60 minutes of the job being created,
     * this action is no longer available.
     * </p>
     *
     * @param updateJobRequest
     * @return Result of the UpdateJob operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws ClusterLimitExceededException
     *         Job creation failed. Currently, clusters support five nodes. If you have fewer than five nodes for your
     *         cluster and you have more nodes to create for this cluster, try again and create jobs until your cluster
     *         has exactly five nodes.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.UpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws InvalidResourceException,
            InvalidJobStateException, KmsRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException,
            Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * While a job's <code>JobState</code> value is <code>New</code>, you can update some of the information associated
     * with a job. Once the job changes to a different job state, usually within 60 minutes of the job being created,
     * this action is no longer available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateJobRequest#builder()}
     * </p>
     *
     * @param updateJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.UpdateJobRequest.Builder} to create a request.
     * @return Result of the UpdateJob operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws KmsRequestFailedException
     *         The provided Key Management Service key lacks the permissions to perform the specified <a>CreateJob</a>
     *         or <a>UpdateJob</a> action.
     * @throws InvalidInputCombinationException
     *         Job or cluster creation failed. One or more inputs were invalid. Confirm that the
     *         <a>CreateClusterRequest&#36SnowballType</a> value supports your <a>CreateJobRequest&#36JobType</a>, and
     *         try again.
     * @throws ClusterLimitExceededException
     *         Job creation failed. Currently, clusters support five nodes. If you have fewer than five nodes for your
     *         cluster and you have more nodes to create for this cluster, try again and create jobs until your cluster
     *         has exactly five nodes.
     * @throws Ec2RequestFailedException
     *         Your user lacks the necessary Amazon EC2 permissions to perform the attempted action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.UpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateJobResponse updateJob(Consumer<UpdateJobRequest.Builder> updateJobRequest) throws InvalidResourceException,
            InvalidJobStateException, KmsRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException,
            Ec2RequestFailedException, AwsServiceException, SdkClientException, SnowballException {
        return updateJob(UpdateJobRequest.builder().applyMutation(updateJobRequest).build());
    }

    /**
     * <p>
     * Updates the state when a shipment state changes to a different state.
     * </p>
     *
     * @param updateJobShipmentStateRequest
     * @return Result of the UpdateJobShipmentState operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.UpdateJobShipmentState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJobShipmentState"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateJobShipmentStateResponse updateJobShipmentState(UpdateJobShipmentStateRequest updateJobShipmentStateRequest)
            throws InvalidResourceException, InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the state when a shipment state changes to a different state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobShipmentStateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateJobShipmentStateRequest#builder()}
     * </p>
     *
     * @param updateJobShipmentStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.UpdateJobShipmentStateRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateJobShipmentState operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws InvalidJobStateException
     *         The action can't be performed because the job's current state doesn't allow that action to be performed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.UpdateJobShipmentState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJobShipmentState"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateJobShipmentStateResponse updateJobShipmentState(
            Consumer<UpdateJobShipmentStateRequest.Builder> updateJobShipmentStateRequest) throws InvalidResourceException,
            InvalidJobStateException, AwsServiceException, SdkClientException, SnowballException {
        return updateJobShipmentState(UpdateJobShipmentStateRequest.builder().applyMutation(updateJobShipmentStateRequest)
                .build());
    }

    /**
     * <p>
     * Updates the long-term pricing type.
     * </p>
     *
     * @param updateLongTermPricingRequest
     * @return Result of the UpdateLongTermPricing operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.UpdateLongTermPricing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateLongTermPricing"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLongTermPricingResponse updateLongTermPricing(UpdateLongTermPricingRequest updateLongTermPricingRequest)
            throws InvalidResourceException, AwsServiceException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the long-term pricing type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLongTermPricingRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLongTermPricingRequest#builder()}
     * </p>
     *
     * @param updateLongTermPricingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowball.model.UpdateLongTermPricingRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLongTermPricing operation returned by the service.
     * @throws InvalidResourceException
     *         The specified resource can't be found. Check the information you provided in your last request, and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowballException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowballClient.UpdateLongTermPricing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateLongTermPricing"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLongTermPricingResponse updateLongTermPricing(
            Consumer<UpdateLongTermPricingRequest.Builder> updateLongTermPricingRequest) throws InvalidResourceException,
            AwsServiceException, SdkClientException, SnowballException {
        return updateLongTermPricing(UpdateLongTermPricingRequest.builder().applyMutation(updateLongTermPricingRequest).build());
    }

    /**
     * Create a {@link SnowballClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SnowballClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SnowballClient}.
     */
    static SnowballClientBuilder builder() {
        return new DefaultSnowballClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SnowballServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
