/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for <code>SnowconeDeviceConfiguration</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceConfiguration.Builder, DeviceConfiguration> {
    private static final SdkField<SnowconeDeviceConfiguration> SNOWCONE_DEVICE_CONFIGURATION_FIELD = SdkField
            .<SnowconeDeviceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SnowconeDeviceConfiguration")
            .getter(getter(DeviceConfiguration::snowconeDeviceConfiguration))
            .setter(setter(Builder::snowconeDeviceConfiguration))
            .constructor(SnowconeDeviceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowconeDeviceConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SNOWCONE_DEVICE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SnowconeDeviceConfiguration snowconeDeviceConfiguration;

    private DeviceConfiguration(BuilderImpl builder) {
        this.snowconeDeviceConfiguration = builder.snowconeDeviceConfiguration;
    }

    /**
     * <p>
     * Returns information about the device configuration for an Snowcone job.
     * </p>
     * 
     * @return Returns information about the device configuration for an Snowcone job.
     */
    public final SnowconeDeviceConfiguration snowconeDeviceConfiguration() {
        return snowconeDeviceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snowconeDeviceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceConfiguration)) {
            return false;
        }
        DeviceConfiguration other = (DeviceConfiguration) obj;
        return Objects.equals(snowconeDeviceConfiguration(), other.snowconeDeviceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceConfiguration").add("SnowconeDeviceConfiguration", snowconeDeviceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnowconeDeviceConfiguration":
            return Optional.ofNullable(clazz.cast(snowconeDeviceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceConfiguration, T> g) {
        return obj -> g.apply((DeviceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceConfiguration> {
        /**
         * <p>
         * Returns information about the device configuration for an Snowcone job.
         * </p>
         * 
         * @param snowconeDeviceConfiguration
         *        Returns information about the device configuration for an Snowcone job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowconeDeviceConfiguration(SnowconeDeviceConfiguration snowconeDeviceConfiguration);

        /**
         * <p>
         * Returns information about the device configuration for an Snowcone job.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowconeDeviceConfiguration.Builder}
         * avoiding the need to create one manually via {@link SnowconeDeviceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowconeDeviceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #snowconeDeviceConfiguration(SnowconeDeviceConfiguration)}.
         * 
         * @param snowconeDeviceConfiguration
         *        a consumer that will call methods on {@link SnowconeDeviceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snowconeDeviceConfiguration(SnowconeDeviceConfiguration)
         */
        default Builder snowconeDeviceConfiguration(Consumer<SnowconeDeviceConfiguration.Builder> snowconeDeviceConfiguration) {
            return snowconeDeviceConfiguration(SnowconeDeviceConfiguration.builder().applyMutation(snowconeDeviceConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SnowconeDeviceConfiguration snowconeDeviceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceConfiguration model) {
            snowconeDeviceConfiguration(model.snowconeDeviceConfiguration);
        }

        public final SnowconeDeviceConfiguration.Builder getSnowconeDeviceConfiguration() {
            return snowconeDeviceConfiguration != null ? snowconeDeviceConfiguration.toBuilder() : null;
        }

        public final void setSnowconeDeviceConfiguration(SnowconeDeviceConfiguration.BuilderImpl snowconeDeviceConfiguration) {
            this.snowconeDeviceConfiguration = snowconeDeviceConfiguration != null ? snowconeDeviceConfiguration.build() : null;
        }

        @Override
        public final Builder snowconeDeviceConfiguration(SnowconeDeviceConfiguration snowconeDeviceConfiguration) {
            this.snowconeDeviceConfiguration = snowconeDeviceConfiguration;
            return this;
        }

        @Override
        public DeviceConfiguration build() {
            return new DeviceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
