/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum SnowballCapacity {
    T50("T50"),

    T80("T80"),

    T100("T100"),

    T42("T42"),

    T98("T98"),

    T8("T8"),

    T14("T14"),

    T32("T32"),

    NO_PREFERENCE("NoPreference"),

    T240("T240"),

    T13("T13"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SnowballCapacity> VALUE_MAP = EnumUtils.uniqueIndex(SnowballCapacity.class,
            SnowballCapacity::toString);

    private final String value;

    private SnowballCapacity(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SnowballCapacity corresponding to the value
     */
    public static SnowballCapacity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SnowballCapacity}s
     */
    public static Set<SnowballCapacity> knownValues() {
        Set<SnowballCapacity> knownValues = EnumSet.allOf(SnowballCapacity.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
