/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.snowdevicemanagement.model.AccessDeniedException;
import software.amazon.awssdk.services.snowdevicemanagement.model.CancelTaskRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.CancelTaskResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.CreateTaskRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.CreateTaskResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeTaskRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.DescribeTaskResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.InternalServerException;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ResourceNotFoundException;
import software.amazon.awssdk.services.snowdevicemanagement.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.snowdevicemanagement.model.SnowDeviceManagementException;
import software.amazon.awssdk.services.snowdevicemanagement.model.TagResourceRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.TagResourceResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ThrottlingException;
import software.amazon.awssdk.services.snowdevicemanagement.model.UntagResourceRequest;
import software.amazon.awssdk.services.snowdevicemanagement.model.UntagResourceResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.ValidationException;
import software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesIterable;
import software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsIterable;
import software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksIterable;

/**
 * Service client for accessing AWS Snow Device Management. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Web Services Snow Device Management documentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SnowDeviceManagementClient extends AwsClient {
    String SERVICE_NAME = "snow-device-management";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "snow-device-management";

    /**
     * <p>
     * Sends a cancel request for a specified task. You can cancel a task only if it's still in a <code>QUEUED</code>
     * state. Tasks that are already running can't be cancelled.
     * </p>
     * <note>
     * <p>
     * A task might still run if it's processed from the queue before the <code>CancelTask</code> operation changes the
     * task's state.
     * </p>
     * </note>
     *
     * @param cancelTaskRequest
     * @return Result of the CancelTask operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.CancelTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CancelTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelTaskResponse cancelTask(CancelTaskRequest cancelTaskRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a cancel request for a specified task. You can cancel a task only if it's still in a <code>QUEUED</code>
     * state. Tasks that are already running can't be cancelled.
     * </p>
     * <note>
     * <p>
     * A task might still run if it's processed from the queue before the <code>CancelTask</code> operation changes the
     * task's state.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelTaskRequest.Builder} avoiding the need to
     * create one manually via {@link CancelTaskRequest#builder()}
     * </p>
     *
     * @param cancelTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.CancelTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CancelTask operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.CancelTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CancelTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelTaskResponse cancelTask(Consumer<CancelTaskRequest.Builder> cancelTaskRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        return cancelTask(CancelTaskRequest.builder().applyMutation(cancelTaskRequest).build());
    }

    /**
     * <p>
     * Instructs one or more devices to start a task, such as unlocking or rebooting.
     * </p>
     *
     * @param createTaskRequest
     * @return Result of the CreateTask operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.CreateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CreateTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTaskResponse createTask(CreateTaskRequest createTaskRequest) throws ServiceQuotaExceededException,
            ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instructs one or more devices to start a task, such as unlocking or rebooting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTaskRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTaskRequest#builder()}
     * </p>
     *
     * @param createTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.CreateTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTask operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.CreateTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/CreateTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTaskResponse createTask(Consumer<CreateTaskRequest.Builder> createTaskRequest)
            throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        return createTask(CreateTaskRequest.builder().applyMutation(createTaskRequest).build());
    }

    /**
     * <p>
     * Checks device-specific information, such as the device type, software version, IP addresses, and lock status.
     * </p>
     *
     * @param describeDeviceRequest
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks device-specific information, such as the device type, software version, IP addresses, and lock status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * Checks the current state of the Amazon EC2 instances. The output is similar to <code>describeDevice</code>, but
     * the results are sourced from the device cache in the Amazon Web Services Cloud and include a subset of the
     * available fields.
     * </p>
     *
     * @param describeDeviceEc2InstancesRequest
     * @return Result of the DescribeDeviceEc2Instances operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.DescribeDeviceEc2Instances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDeviceEc2Instances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeviceEc2InstancesResponse describeDeviceEc2Instances(
            DescribeDeviceEc2InstancesRequest describeDeviceEc2InstancesRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the current state of the Amazon EC2 instances. The output is similar to <code>describeDevice</code>, but
     * the results are sourced from the device cache in the Amazon Web Services Cloud and include a subset of the
     * available fields.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceEc2InstancesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDeviceEc2InstancesRequest#builder()}
     * </p>
     *
     * @param describeDeviceEc2InstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeDeviceEc2Instances operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.DescribeDeviceEc2Instances
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeDeviceEc2Instances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeviceEc2InstancesResponse describeDeviceEc2Instances(
            Consumer<DescribeDeviceEc2InstancesRequest.Builder> describeDeviceEc2InstancesRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        return describeDeviceEc2Instances(DescribeDeviceEc2InstancesRequest.builder()
                .applyMutation(describeDeviceEc2InstancesRequest).build());
    }

    /**
     * <p>
     * Checks the status of a remote task running on one or more target devices.
     * </p>
     *
     * @param describeExecutionRequest
     * @return Result of the DescribeExecution operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExecutionResponse describeExecution(DescribeExecutionRequest describeExecutionRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the status of a remote task running on one or more target devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeExecutionRequest#builder()}
     * </p>
     *
     * @param describeExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.DescribeExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeExecution operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExecutionResponse describeExecution(Consumer<DescribeExecutionRequest.Builder> describeExecutionRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        return describeExecution(DescribeExecutionRequest.builder().applyMutation(describeExecutionRequest).build());
    }

    /**
     * <p>
     * Checks the metadata for a given task on a device.
     * </p>
     *
     * @param describeTaskRequest
     * @return Result of the DescribeTask operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.DescribeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTaskResponse describeTask(DescribeTaskRequest describeTaskRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Checks the metadata for a given task on a device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTaskRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTaskRequest#builder()}
     * </p>
     *
     * @param describeTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.DescribeTaskRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTask operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.DescribeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/DescribeTask"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTaskResponse describeTask(Consumer<DescribeTaskRequest.Builder> describeTaskRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        return describeTask(DescribeTaskRequest.builder().applyMutation(describeTaskRequest).build());
    }

    /**
     * <p>
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are
     * the only supported resource type.
     * </p>
     *
     * @param listDeviceResourcesRequest
     * @return Result of the ListDeviceResources operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListDeviceResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceResourcesResponse listDeviceResources(ListDeviceResourcesRequest listDeviceResourcesRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are
     * the only supported resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceResourcesRequest#builder()}
     * </p>
     *
     * @param listDeviceResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest.Builder} to
     *        create a request.
     * @return Result of the ListDeviceResources operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListDeviceResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceResourcesResponse listDeviceResources(
            Consumer<ListDeviceResourcesRequest.Builder> listDeviceResourcesRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        return listDeviceResources(ListDeviceResourcesRequest.builder().applyMutation(listDeviceResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are
     * the only supported resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceResources(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesIterable responses = client.listDeviceResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesIterable responses = client
     *             .listDeviceResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesIterable responses = client.listDeviceResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceResources(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListDeviceResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceResourcesIterable listDeviceResourcesPaginator(ListDeviceResourcesRequest listDeviceResourcesRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        return new ListDeviceResourcesIterable(this, listDeviceResourcesRequest);
    }

    /**
     * <p>
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are
     * the only supported resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceResources(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesIterable responses = client.listDeviceResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesIterable responses = client
     *             .listDeviceResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDeviceResourcesIterable responses = client.listDeviceResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceResources(software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeviceResourcesRequest#builder()}
     * </p>
     *
     * @param listDeviceResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListDeviceResourcesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListDeviceResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDeviceResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceResourcesIterable listDeviceResourcesPaginator(
            Consumer<ListDeviceResourcesRequest.Builder> listDeviceResourcesRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        return listDeviceResourcesPaginator(ListDeviceResourcesRequest.builder().applyMutation(listDeviceResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device
     * Management enabled in the Amazon Web Services Region where the command is run.
     * </p>
     *
     * @param listDevicesRequest
     * @return Result of the ListDevices operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device
     * Management enabled in the Amazon Web Services Region where the command is run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDevices operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevicesResponse listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device
     * Management enabled in the Amazon Web Services Region where the command is run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevices(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesIterable responses = client
     *             .listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator(ListDevicesRequest listDevicesRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        return new ListDevicesIterable(this, listDevicesRequest);
    }

    /**
     * <p>
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device
     * Management enabled in the Amazon Web Services Region where the command is run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDevices(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesIterable responses = client
     *             .listDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListDevicesIterable responses = client.listDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListDevicesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListDevices"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDevicesIterable listDevicesPaginator(Consumer<ListDevicesRequest.Builder> listDevicesRequest)
            throws ThrottlingException, InternalServerException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        return listDevicesPaginator(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Returns the status of tasks for one or more target devices.
     * </p>
     *
     * @param listExecutionsRequest
     * @return Result of the ListExecutions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExecutionsResponse listExecutions(ListExecutionsRequest listExecutionsRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of tasks for one or more target devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest.Builder} to create
     *        a request.
     * @return Result of the ListExecutions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExecutionsResponse listExecutions(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        return listExecutions(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns the status of tasks for one or more target devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExecutions(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsIterable responses = client
     *             .listExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExecutionsIterable listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        return new ListExecutionsIterable(this, listExecutionsRequest);
    }

    /**
     * <p>
     * Returns the status of tasks for one or more target devices.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExecutions(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsIterable responses = client
     *             .listExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListExecutionsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExecutionsIterable listExecutionsPaginator(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, ValidationException,
            AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        return listExecutionsPaginator(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a managed device or task.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a managed device or task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of tasks that can be filtered by state.
     * </p>
     *
     * @param listTasksRequest
     * @return Result of the ListTasks operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTasksResponse listTasks(ListTasksRequest listTasksRequest) throws ThrottlingException, InternalServerException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tasks that can be filtered by state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest.Builder} to create a
     *        request.
     * @return Result of the ListTasks operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTasksResponse listTasks(Consumer<ListTasksRequest.Builder> listTasksRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        return listTasks(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Returns a list of tasks that can be filtered by state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTasks(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksIterable responses = client
     *             .listTasksPaginator(request);
     *     for (software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest)} operation.</b>
     * </p>
     *
     * @param listTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTasksIterable listTasksPaginator(ListTasksRequest listTasksRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        return new ListTasksIterable(this, listTasksRequest);
    }

    /**
     * <p>
     * Returns a list of tasks that can be filtered by state.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTasks(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksIterable responses = client
     *             .listTasksPaginator(request);
     *     for (software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.snowdevicemanagement.paginators.ListTasksIterable responses = client.listTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTasks(software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListTasksRequest#builder()}
     * </p>
     *
     * @param listTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.ListTasksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.ListTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/ListTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTasksIterable listTasksPaginator(Consumer<ListTasksRequest.Builder> listTasksRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        return listTasksPaginator(ListTasksRequest.builder().applyMutation(listTasksRequest).build());
    }

    /**
     * <p>
     * Adds or replaces tags on a device or task.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or replaces tags on a device or task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a device or task.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            SnowDeviceManagementException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a device or task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SnowDeviceManagementException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SnowDeviceManagementClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/snow-device-management-2021-08-04/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, SnowDeviceManagementException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link SnowDeviceManagementClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SnowDeviceManagementClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SnowDeviceManagementClient}.
     */
    static SnowDeviceManagementClientBuilder builder() {
        return new DefaultSnowDeviceManagementClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SnowDeviceManagementServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
