/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceEc2InstancesResponse extends SnowDeviceManagementResponse implements
        ToCopyableBuilder<DescribeDeviceEc2InstancesResponse.Builder, DescribeDeviceEc2InstancesResponse> {
    private static final SdkField<List<InstanceSummary>> INSTANCES_FIELD = SdkField
            .<List<InstanceSummary>> builder(MarshallingType.LIST)
            .memberName("instances")
            .getter(getter(DescribeDeviceEc2InstancesResponse::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD));

    private final List<InstanceSummary> instances;

    private DescribeDeviceEc2InstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of structures containing information about each instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return A list of structures containing information about each instance.
     */
    public final List<InstanceSummary> instances() {
        return instances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceEc2InstancesResponse)) {
            return false;
        }
        DescribeDeviceEc2InstancesResponse other = (DescribeDeviceEc2InstancesResponse) obj;
        return hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeviceEc2InstancesResponse").add("Instances", hasInstances() ? instances() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instances":
            return Optional.ofNullable(clazz.cast(instances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceEc2InstancesResponse, T> g) {
        return obj -> g.apply((DescribeDeviceEc2InstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnowDeviceManagementResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDeviceEc2InstancesResponse> {
        /**
         * <p>
         * A list of structures containing information about each instance.
         * </p>
         * 
         * @param instances
         *        A list of structures containing information about each instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<InstanceSummary> instances);

        /**
         * <p>
         * A list of structures containing information about each instance.
         * </p>
         * 
         * @param instances
         *        A list of structures containing information about each instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(InstanceSummary... instances);

        /**
         * <p>
         * A list of structures containing information about each instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.InstanceSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.InstanceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.InstanceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #instances(List<InstanceSummary>)}.
         * 
         * @param instances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.InstanceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(java.util.Collection<InstanceSummary>)
         */
        Builder instances(Consumer<InstanceSummary.Builder>... instances);
    }

    static final class BuilderImpl extends SnowDeviceManagementResponse.BuilderImpl implements Builder {
        private List<InstanceSummary> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceEc2InstancesResponse model) {
            super(model);
            instances(model.instances);
        }

        public final List<InstanceSummary.Builder> getInstances() {
            List<InstanceSummary.Builder> result = InstanceSummaryListCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<InstanceSummary.BuilderImpl> instances) {
            this.instances = InstanceSummaryListCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<InstanceSummary> instances) {
            this.instances = InstanceSummaryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(InstanceSummary... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<InstanceSummary.Builder>... instances) {
            instances(Stream.of(instances).map(c -> InstanceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDeviceEc2InstancesResponse build() {
            return new DescribeDeviceEc2InstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
