/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of an instance. Currently, Amazon EC2 instances are the only supported instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<Integer> AMI_LAUNCH_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("amiLaunchIndex").getter(getter(Instance::amiLaunchIndex)).setter(setter(Builder::amiLaunchIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiLaunchIndex").build()).build();

    private static final SdkField<List<InstanceBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<InstanceBlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("blockDeviceMappings")
            .getter(getter(Instance::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceBlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceBlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CpuOptions> CPU_OPTIONS_FIELD = SdkField.<CpuOptions> builder(MarshallingType.SDK_POJO)
            .memberName("cpuOptions").getter(getter(Instance::cpuOptions)).setter(setter(Builder::cpuOptions))
            .constructor(CpuOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuOptions").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Instance::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageId").getter(getter(Instance::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(Instance::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(Instance::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateIpAddress").getter(getter(Instance::privateIpAddress)).setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()).build();

    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicIpAddress").getter(getter(Instance::publicIpAddress)).setter(setter(Builder::publicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIpAddress").build()).build();

    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootDeviceName").getter(getter(Instance::rootDeviceName)).setter(setter(Builder::rootDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDeviceName").build()).build();

    private static final SdkField<List<SecurityGroupIdentifier>> SECURITY_GROUPS_FIELD = SdkField
            .<List<SecurityGroupIdentifier>> builder(MarshallingType.LIST)
            .memberName("securityGroups")
            .getter(getter(Instance::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceState> STATE_FIELD = SdkField.<InstanceState> builder(MarshallingType.SDK_POJO)
            .memberName("state").getter(getter(Instance::state)).setter(setter(Builder::state))
            .constructor(InstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Instance::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_LAUNCH_INDEX_FIELD,
            BLOCK_DEVICE_MAPPINGS_FIELD, CPU_OPTIONS_FIELD, CREATED_AT_FIELD, IMAGE_ID_FIELD, INSTANCE_ID_FIELD,
            INSTANCE_TYPE_FIELD, PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD, ROOT_DEVICE_NAME_FIELD,
            SECURITY_GROUPS_FIELD, STATE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer amiLaunchIndex;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final CpuOptions cpuOptions;

    private final Instant createdAt;

    private final String imageId;

    private final String instanceId;

    private final String instanceType;

    private final String privateIpAddress;

    private final String publicIpAddress;

    private final String rootDeviceName;

    private final List<SecurityGroupIdentifier> securityGroups;

    private final InstanceState state;

    private final Instant updatedAt;

    private Instance(BuilderImpl builder) {
        this.amiLaunchIndex = builder.amiLaunchIndex;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.cpuOptions = builder.cpuOptions;
        this.createdAt = builder.createdAt;
        this.imageId = builder.imageId;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.rootDeviceName = builder.rootDeviceName;
        this.securityGroups = builder.securityGroups;
        this.state = builder.state;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) launch index, which you can use to find this instance in the launch group.
     * </p>
     * 
     * @return The Amazon Machine Image (AMI) launch index, which you can use to find this instance in the launch group.
     */
    public final Integer amiLaunchIndex() {
        return amiLaunchIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any block device mapping entries for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return Any block device mapping entries for the instance.
     */
    public final List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The CPU options for the instance.
     * </p>
     * 
     * @return The CPU options for the instance.
     */
    public final CpuOptions cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * When the instance was created.
     * </p>
     * 
     * @return When the instance was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the AMI used to launch the instance.
     * </p>
     * 
     * @return The ID of the AMI used to launch the instance.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The private IPv4 address assigned to the instance.
     * </p>
     * 
     * @return The private IPv4 address assigned to the instance.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The public IPv4 address assigned to the instance.
     * </p>
     * 
     * @return The public IPv4 address assigned to the instance.
     */
    public final String publicIpAddress() {
        return publicIpAddress;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public final String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The security groups for the instance.
     */
    public final List<SecurityGroupIdentifier> securityGroups() {
        return securityGroups;
    }

    /**
     * Returns the value of the State property for this object.
     * 
     * @return The value of the State property for this object.
     */
    public final InstanceState state() {
        return state;
    }

    /**
     * <p>
     * When the instance was last updated.
     * </p>
     * 
     * @return When the instance was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amiLaunchIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(amiLaunchIndex(), other.amiLaunchIndex())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(cpuOptions(), other.cpuOptions()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(publicIpAddress(), other.publicIpAddress())
                && Objects.equals(rootDeviceName(), other.rootDeviceName()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups()) && Objects.equals(state(), other.state())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Instance").add("AmiLaunchIndex", amiLaunchIndex())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("CpuOptions", cpuOptions()).add("CreatedAt", createdAt()).add("ImageId", imageId())
                .add("InstanceId", instanceId()).add("InstanceType", instanceType()).add("PrivateIpAddress", privateIpAddress())
                .add("PublicIpAddress", publicIpAddress()).add("RootDeviceName", rootDeviceName())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("State", state())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amiLaunchIndex":
            return Optional.ofNullable(clazz.cast(amiLaunchIndex()));
        case "blockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "cpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "privateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "publicIpAddress":
            return Optional.ofNullable(clazz.cast(publicIpAddress()));
        case "rootDeviceName":
            return Optional.ofNullable(clazz.cast(rootDeviceName()));
        case "securityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The Amazon Machine Image (AMI) launch index, which you can use to find this instance in the launch group.
         * </p>
         * 
         * @param amiLaunchIndex
         *        The Amazon Machine Image (AMI) launch index, which you can use to find this instance in the launch
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiLaunchIndex(Integer amiLaunchIndex);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.InstanceBlockDeviceMapping.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.InstanceBlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.InstanceBlockDeviceMapping.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #blockDeviceMappings(List<InstanceBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.InstanceBlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<InstanceBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The CPU options for the instance.
         * </p>
         * 
         * @param cpuOptions
         *        The CPU options for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(CpuOptions cpuOptions);

        /**
         * <p>
         * The CPU options for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link CpuOptions.Builder} avoiding the need to
         * create one manually via {@link CpuOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CpuOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #cpuOptions(CpuOptions)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link CpuOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(CpuOptions)
         */
        default Builder cpuOptions(Consumer<CpuOptions.Builder> cpuOptions) {
            return cpuOptions(CpuOptions.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * When the instance was created.
         * </p>
         * 
         * @param createdAt
         *        When the instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the AMI used to launch the instance.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI used to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The private IPv4 address assigned to the instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IPv4 address assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The public IPv4 address assigned to the instance.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IPv4 address assigned to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<SecurityGroupIdentifier> securityGroups);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * 
         * @param securityGroups
         *        The security groups for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(SecurityGroupIdentifier... securityGroups);

        /**
         * <p>
         * The security groups for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.SecurityGroupIdentifier.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.SecurityGroupIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowdevicemanagement.model.SecurityGroupIdentifier.Builder#build()} is
         * called immediately and its result is passed to {@link #securityGroups(List<SecurityGroupIdentifier>)}.
         * 
         * @param securityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowdevicemanagement.model.SecurityGroupIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroups(java.util.Collection<SecurityGroupIdentifier>)
         */
        Builder securityGroups(Consumer<SecurityGroupIdentifier.Builder>... securityGroups);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * Sets the value of the State property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InstanceState.Builder} avoiding the need
         * to create one manually via {@link InstanceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(InstanceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(InstanceState)
         */
        default Builder state(Consumer<InstanceState.Builder> state) {
            return state(InstanceState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * When the instance was last updated.
         * </p>
         * 
         * @param updatedAt
         *        When the instance was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Integer amiLaunchIndex;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private CpuOptions cpuOptions;

        private Instant createdAt;

        private String imageId;

        private String instanceId;

        private String instanceType;

        private String privateIpAddress;

        private String publicIpAddress;

        private String rootDeviceName;

        private List<SecurityGroupIdentifier> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private InstanceState state;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            amiLaunchIndex(model.amiLaunchIndex);
            blockDeviceMappings(model.blockDeviceMappings);
            cpuOptions(model.cpuOptions);
            createdAt(model.createdAt);
            imageId(model.imageId);
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            privateIpAddress(model.privateIpAddress);
            publicIpAddress(model.publicIpAddress);
            rootDeviceName(model.rootDeviceName);
            securityGroups(model.securityGroups);
            state(model.state);
            updatedAt(model.updatedAt);
        }

        public final Integer getAmiLaunchIndex() {
            return amiLaunchIndex;
        }

        public final void setAmiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
        }

        @Override
        public final Builder amiLaunchIndex(Integer amiLaunchIndex) {
            this.amiLaunchIndex = amiLaunchIndex;
            return this;
        }

        public final List<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<InstanceBlockDeviceMapping.Builder> result = InstanceBlockDeviceMappingListCopier
                    .copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings)
                    .map(c -> InstanceBlockDeviceMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CpuOptions.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(CpuOptions.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(CpuOptions cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final List<SecurityGroupIdentifier.Builder> getSecurityGroups() {
            List<SecurityGroupIdentifier.Builder> result = SecurityGroupIdentifierListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroupIdentifier.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupIdentifierListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupIdentifier> securityGroups) {
            this.securityGroups = SecurityGroupIdentifierListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupIdentifier... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroupIdentifier.Builder>... securityGroups) {
            securityGroups(Stream.of(securityGroups).map(c -> SecurityGroupIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
