/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response from CreateEndpoint action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlatformEndpointResponse extends SnsResponse implements
        ToCopyableBuilder<CreatePlatformEndpointResponse.Builder, CreatePlatformEndpointResponse> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(CreatePlatformEndpointResponse::endpointArn))
            .setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD));

    private final String endpointArn;

    private CreatePlatformEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
    }

    /**
     * <p>
     * EndpointArn returned from CreateEndpoint action.
     * </p>
     * 
     * @return EndpointArn returned from CreateEndpoint action.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformEndpointResponse)) {
            return false;
        }
        CreatePlatformEndpointResponse other = (CreatePlatformEndpointResponse) obj;
        return Objects.equals(endpointArn(), other.endpointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlatformEndpointResponse").add("EndpointArn", endpointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePlatformEndpointResponse, T> g) {
        return obj -> g.apply((CreatePlatformEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlatformEndpointResponse> {
        /**
         * <p>
         * EndpointArn returned from CreateEndpoint action.
         * </p>
         * 
         * @param endpointArn
         *        EndpointArn returned from CreateEndpoint action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private String endpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformEndpointResponse model) {
            super(model);
            endpointArn(model.endpointArn);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        @Override
        public CreatePlatformEndpointResponse build() {
            return new CreatePlatformEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
