/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.DocumentReviewAction;
import software.amazon.awssdk.services.ssm.model.DocumentReviewCommentListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentReviewCommentSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentReviews
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentReviews> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(DocumentReviews.getter(DocumentReviews::actionAsString)).setter(DocumentReviews.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<List<DocumentReviewCommentSource>> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Comment").getter(DocumentReviews.getter(DocumentReviews::comment)).setter(DocumentReviews.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentReviewCommentSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentReviews.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final List<DocumentReviewCommentSource> comment;

    private DocumentReviews(BuilderImpl builder) {
        this.action = builder.action;
        this.comment = builder.comment;
    }

    public final DocumentReviewAction action() {
        return DocumentReviewAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final boolean hasComment() {
        return this.comment != null && !(this.comment instanceof SdkAutoConstructList);
    }

    public final List<DocumentReviewCommentSource> comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComment() ? this.comment() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentReviews)) {
            return false;
        }
        DocumentReviews other = (DocumentReviews)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasComment() == other.hasComment() && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentReviews").add("Action", (Object)this.actionAsString()).add("Comment", this.hasComment() ? this.comment() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("Comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentReviews, T> g) {
        return obj -> g.apply((DocumentReviews)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private List<DocumentReviewCommentSource> comment = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentReviews model) {
            this.action(model.action);
            this.comment(model.comment);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DocumentReviewAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<DocumentReviewCommentSource.Builder> getComment() {
            List<DocumentReviewCommentSource.Builder> result = DocumentReviewCommentListCopier.copyToBuilder(this.comment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComment(Collection<DocumentReviewCommentSource.BuilderImpl> comment) {
            this.comment = DocumentReviewCommentListCopier.copyFromBuilder(comment);
        }

        @Override
        public final Builder comment(Collection<DocumentReviewCommentSource> comment) {
            this.comment = DocumentReviewCommentListCopier.copy(comment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comment(DocumentReviewCommentSource ... comment) {
            this.comment(Arrays.asList(comment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comment(Consumer<DocumentReviewCommentSource.Builder> ... comment) {
            this.comment(Stream.of(comment).map(c -> (DocumentReviewCommentSource)((DocumentReviewCommentSource.Builder)DocumentReviewCommentSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DocumentReviews build() {
            return new DocumentReviews(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentReviews> {
        public Builder action(String var1);

        public Builder action(DocumentReviewAction var1);

        public Builder comment(Collection<DocumentReviewCommentSource> var1);

        public Builder comment(DocumentReviewCommentSource ... var1);

        public Builder comment(Consumer<DocumentReviewCommentSource.Builder> ... var1);
    }
}

