/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactRequest extends SsmContactsRequest implements
        ToCopyableBuilder<CreateContactRequest.Builder, CreateContactRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(CreateContactRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateContactRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateContactRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Plan> PLAN_FIELD = SdkField.<Plan> builder(MarshallingType.SDK_POJO).memberName("Plan")
            .getter(getter(CreateContactRequest::plan)).setter(setter(Builder::plan)).constructor(Plan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Plan").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateContactRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CreateContactRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            DISPLAY_NAME_FIELD, TYPE_FIELD, PLAN_FIELD, TAGS_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String alias;

    private final String displayName;

    private final String type;

    private final Plan plan;

    private final List<Tag> tags;

    private final String idempotencyToken;

    private CreateContactRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.plan = builder.plan;
        this.tags = builder.tags;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The short name to quickly identify a contact or escalation plan. The contact alias must be unique and
     * identifiable.
     * </p>
     * 
     * @return The short name to quickly identify a contact or escalation plan. The contact alias must be unique and
     *         identifiable.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The full name of the contact or escalation plan.
     * </p>
     * 
     * @return The full name of the contact or escalation plan.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.
     * @see ContactType
     */
    public final ContactType type() {
        return ContactType.fromValue(type);
    }

    /**
     * <p>
     * To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.
     * @see ContactType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An
     * escalation plan uses stages that contact specified contacts.
     * </p>
     * 
     * @return A list of stages. A contact has an engagement plan with stages that contact specified contact channels.
     *         An escalation plan uses stages that contact specified contacts.
     */
    public final Plan plan() {
        return plan;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds a tag to the target. You can only tag resources created in the first Region of your replication set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds a tag to the target. You can only tag resources created in the first Region of your replication set.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A token ensuring that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token ensuring that the operation is called only once with the specified details.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(plan());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactRequest)) {
            return false;
        }
        CreateContactRequest other = (CreateContactRequest) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(plan(), other.plan())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactRequest").add("Alias", alias()).add("DisplayName", displayName())
                .add("Type", typeAsString()).add("Plan", plan()).add("Tags", hasTags() ? tags() : null)
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Plan":
            return Optional.ofNullable(clazz.cast(plan()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactRequest, T> g) {
        return obj -> g.apply((CreateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactRequest> {
        /**
         * <p>
         * The short name to quickly identify a contact or escalation plan. The contact alias must be unique and
         * identifiable.
         * </p>
         * 
         * @param alias
         *        The short name to quickly identify a contact or escalation plan. The contact alias must be unique and
         *        identifiable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The full name of the contact or escalation plan.
         * </p>
         * 
         * @param displayName
         *        The full name of the contact or escalation plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.
         * </p>
         * 
         * @param type
         *        To create an escalation plan use <code>ESCALATION</code>. To create a contact use
         *        <code>PERSONAL</code>.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder type(String type);

        /**
         * <p>
         * To create an escalation plan use <code>ESCALATION</code>. To create a contact use <code>PERSONAL</code>.
         * </p>
         * 
         * @param type
         *        To create an escalation plan use <code>ESCALATION</code>. To create a contact use
         *        <code>PERSONAL</code>.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder type(ContactType type);

        /**
         * <p>
         * A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An
         * escalation plan uses stages that contact specified contacts.
         * </p>
         * 
         * @param plan
         *        A list of stages. A contact has an engagement plan with stages that contact specified contact
         *        channels. An escalation plan uses stages that contact specified contacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plan(Plan plan);

        /**
         * <p>
         * A list of stages. A contact has an engagement plan with stages that contact specified contact channels. An
         * escalation plan uses stages that contact specified contacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link Plan.Builder} avoiding the need to create
         * one manually via {@link Plan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Plan.Builder#build()} is called immediately and its result is
         * passed to {@link #plan(Plan)}.
         * 
         * @param plan
         *        a consumer that will call methods on {@link Plan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plan(Plan)
         */
        default Builder plan(Consumer<Plan.Builder> plan) {
            return plan(Plan.builder().applyMutation(plan).build());
        }

        /**
         * <p>
         * Adds a tag to the target. You can only tag resources created in the first Region of your replication set.
         * </p>
         * 
         * @param tags
         *        Adds a tag to the target. You can only tag resources created in the first Region of your replication
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Adds a tag to the target. You can only tag resources created in the first Region of your replication set.
         * </p>
         * 
         * @param tags
         *        Adds a tag to the target. You can only tag resources created in the first Region of your replication
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Adds a tag to the target. You can only tag resources created in the first Region of your replication set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmcontacts.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A token ensuring that the operation is called only once with the specified details.
         * </p>
         * 
         * @param idempotencyToken
         *        A token ensuring that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String alias;

        private String displayName;

        private String type;

        private Plan plan;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactRequest model) {
            super(model);
            alias(model.alias);
            displayName(model.displayName);
            type(model.type);
            plan(model.plan);
            tags(model.tags);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Plan.Builder getPlan() {
            return plan != null ? plan.toBuilder() : null;
        }

        public final void setPlan(Plan.BuilderImpl plan) {
            this.plan = plan != null ? plan.build() : null;
        }

        @Override
        public final Builder plan(Plan plan) {
            this.plan = plan;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactRequest build() {
            return new CreateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
