/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationShiftsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationShiftsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.RotationShift;

public class ListRotationShiftsIterable
implements SdkIterable<ListRotationShiftsResponse> {
    private final SsmContactsClient client;
    private final ListRotationShiftsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRotationShiftsIterable(SsmContactsClient client, ListRotationShiftsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRotationShiftsResponseFetcher();
    }

    public Iterator<ListRotationShiftsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RotationShift> rotationShifts() {
        Function<ListRotationShiftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotationShifts() != null) {
                return response.rotationShifts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRotationShiftsResponseFetcher
    implements SyncPageFetcher<ListRotationShiftsResponse> {
        private ListRotationShiftsResponseFetcher() {
        }

        public boolean hasNextPage(ListRotationShiftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRotationShiftsResponse nextPage(ListRotationShiftsResponse previousPage) {
            if (previousPage == null) {
                return ListRotationShiftsIterable.this.client.listRotationShifts(ListRotationShiftsIterable.this.firstRequest);
            }
            return ListRotationShiftsIterable.this.client.listRotationShifts((ListRotationShiftsRequest)((Object)ListRotationShiftsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

