/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action that starts at the beginning of an incident. The response plan defines the action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<SsmAutomation> SSM_AUTOMATION_FIELD = SdkField
            .<SsmAutomation> builder(MarshallingType.SDK_POJO).memberName("ssmAutomation").getter(getter(Action::ssmAutomation))
            .setter(setter(Builder::ssmAutomation)).constructor(SsmAutomation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmAutomation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSM_AUTOMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SsmAutomation ssmAutomation;

    private final Type type;

    private Action(BuilderImpl builder) {
        this.ssmAutomation = builder.ssmAutomation;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Systems Manager automation document to start as the runbook at the beginning of the incident.
     * </p>
     * 
     * @return The Systems Manager automation document to start as the runbook at the beginning of the incident.
     */
    public final SsmAutomation ssmAutomation() {
        return ssmAutomation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ssmAutomation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(ssmAutomation(), other.ssmAutomation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("SsmAutomation", ssmAutomation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ssmAutomation":
            return Optional.ofNullable(clazz.cast(ssmAutomation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ssmAutomation()} initialized to the given value.
     *
     * <p>
     * The Systems Manager automation document to start as the runbook at the beginning of the incident.
     * </p>
     * 
     * @param ssmAutomation
     *        The Systems Manager automation document to start as the runbook at the beginning of the incident.
     */
    public static Action fromSsmAutomation(SsmAutomation ssmAutomation) {
        return builder().ssmAutomation(ssmAutomation).build();
    }

    /**
     * Create an instance of this class with {@link #ssmAutomation()} initialized to the given value.
     *
     * <p>
     * The Systems Manager automation document to start as the runbook at the beginning of the incident.
     * </p>
     * 
     * @param ssmAutomation
     *        The Systems Manager automation document to start as the runbook at the beginning of the incident.
     */
    public static Action fromSsmAutomation(Consumer<SsmAutomation.Builder> ssmAutomation) {
        SsmAutomation.Builder builder = SsmAutomation.builder();
        ssmAutomation.accept(builder);
        return fromSsmAutomation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * The Systems Manager automation document to start as the runbook at the beginning of the incident.
         * </p>
         * 
         * @param ssmAutomation
         *        The Systems Manager automation document to start as the runbook at the beginning of the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmAutomation(SsmAutomation ssmAutomation);

        /**
         * <p>
         * The Systems Manager automation document to start as the runbook at the beginning of the incident.
         * </p>
         * This is a convenience method that creates an instance of the {@link SsmAutomation.Builder} avoiding the need
         * to create one manually via {@link SsmAutomation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SsmAutomation.Builder#build()} is called immediately and its
         * result is passed to {@link #ssmAutomation(SsmAutomation)}.
         * 
         * @param ssmAutomation
         *        a consumer that will call methods on {@link SsmAutomation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmAutomation(SsmAutomation)
         */
        default Builder ssmAutomation(Consumer<SsmAutomation.Builder> ssmAutomation) {
            return ssmAutomation(SsmAutomation.builder().applyMutation(ssmAutomation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SsmAutomation ssmAutomation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            ssmAutomation(model.ssmAutomation);
        }

        public final SsmAutomation.Builder getSsmAutomation() {
            return ssmAutomation != null ? ssmAutomation.toBuilder() : null;
        }

        public final void setSsmAutomation(SsmAutomation.BuilderImpl ssmAutomation) {
            Object oldValue = this.ssmAutomation;
            this.ssmAutomation = ssmAutomation != null ? ssmAutomation.build() : null;
            handleUnionValueChange(Type.SSM_AUTOMATION, oldValue, this.ssmAutomation);
        }

        @Override
        public final Builder ssmAutomation(SsmAutomation ssmAutomation) {
            Object oldValue = this.ssmAutomation;
            this.ssmAutomation = ssmAutomation;
            handleUnionValueChange(Type.SSM_AUTOMATION, oldValue, this.ssmAutomation);
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Action#type()
     */
    public enum Type {
        SSM_AUTOMATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
