/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A conditional statement with which to compare a value, after a timestamp, before a timestamp, or equal to a string or
 * integer. If multiple conditions are specified, the conditionals become an <code>AND</code>ed statement. If multiple
 * values are specified for a conditional, the values are <code>OR</code>d.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<Instant> AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("after")
            .getter(getter(Condition::after)).setter(setter(Builder::after))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("after").build()).build();

    private static final SdkField<Instant> BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("before").getter(getter(Condition::before)).setter(setter(Builder::before))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("before").build()).build();

    private static final SdkField<AttributeValueList> EQUALS_FIELD = SdkField
            .<AttributeValueList> builder(MarshallingType.SDK_POJO).memberName("equals").getter(getter(Condition::equalsValue))
            .setter(setter(Builder::equalsValue)).constructor(AttributeValueList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_FIELD, BEFORE_FIELD,
            EQUALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant after;

    private final Instant before;

    private final AttributeValueList equalsValue;

    private final Type type;

    private Condition(BuilderImpl builder) {
        this.after = builder.after;
        this.before = builder.before;
        this.equalsValue = builder.equalsValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * After the specified timestamp.
     * </p>
     * 
     * @return After the specified timestamp.
     */
    public final Instant after() {
        return after;
    }

    /**
     * <p>
     * Before the specified timestamp
     * </p>
     * 
     * @return Before the specified timestamp
     */
    public final Instant before() {
        return before;
    }

    /**
     * <p>
     * The value is equal to the provided string or integer.
     * </p>
     * 
     * @return The value is equal to the provided string or integer.
     */
    public final AttributeValueList equalsValue() {
        return equalsValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(after());
        hashCode = 31 * hashCode + Objects.hashCode(before());
        hashCode = 31 * hashCode + Objects.hashCode(equalsValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(after(), other.after()) && Objects.equals(before(), other.before())
                && Objects.equals(equalsValue(), other.equalsValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Condition").add("After", after()).add("Before", before()).add("Equals", equalsValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "after":
            return Optional.ofNullable(clazz.cast(after()));
        case "before":
            return Optional.ofNullable(clazz.cast(before()));
        case "equals":
            return Optional.ofNullable(clazz.cast(equalsValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #after()} initialized to the given value.
     *
     * <p>
     * After the specified timestamp.
     * </p>
     * 
     * @param after
     *        After the specified timestamp.
     */
    public static Condition fromAfter(Instant after) {
        return builder().after(after).build();
    }

    /**
     * Create an instance of this class with {@link #before()} initialized to the given value.
     *
     * <p>
     * Before the specified timestamp
     * </p>
     * 
     * @param before
     *        Before the specified timestamp
     */
    public static Condition fromBefore(Instant before) {
        return builder().before(before).build();
    }

    /**
     * Create an instance of this class with {@link #equalsValue()} initialized to the given value.
     *
     * <p>
     * The value is equal to the provided string or integer.
     * </p>
     * 
     * @param equalsValue
     *        The value is equal to the provided string or integer.
     */
    public static Condition fromEqualsValue(AttributeValueList equalsValue) {
        return builder().equalsValue(equalsValue).build();
    }

    /**
     * Create an instance of this class with {@link #equalsValue()} initialized to the given value.
     *
     * <p>
     * The value is equal to the provided string or integer.
     * </p>
     * 
     * @param equalsValue
     *        The value is equal to the provided string or integer.
     */
    public static Condition fromEqualsValue(Consumer<AttributeValueList.Builder> equalsValue) {
        AttributeValueList.Builder builder = AttributeValueList.builder();
        equalsValue.accept(builder);
        return fromEqualsValue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * After the specified timestamp.
         * </p>
         * 
         * @param after
         *        After the specified timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(Instant after);

        /**
         * <p>
         * Before the specified timestamp
         * </p>
         * 
         * @param before
         *        Before the specified timestamp
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder before(Instant before);

        /**
         * <p>
         * The value is equal to the provided string or integer.
         * </p>
         * 
         * @param equalsValue
         *        The value is equal to the provided string or integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalsValue(AttributeValueList equalsValue);

        /**
         * <p>
         * The value is equal to the provided string or integer.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeValueList.Builder} avoiding the
         * need to create one manually via {@link AttributeValueList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeValueList.Builder#build()} is called immediately and its
         * result is passed to {@link #equalsValue(AttributeValueList)}.
         * 
         * @param equalsValue
         *        a consumer that will call methods on {@link AttributeValueList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #equalsValue(AttributeValueList)
         */
        default Builder equalsValue(Consumer<AttributeValueList.Builder> equalsValue) {
            return equalsValue(AttributeValueList.builder().applyMutation(equalsValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant after;

        private Instant before;

        private AttributeValueList equalsValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            after(model.after);
            before(model.before);
            equalsValue(model.equalsValue);
        }

        public final Instant getAfter() {
            return after;
        }

        public final void setAfter(Instant after) {
            Object oldValue = this.after;
            this.after = after;
            handleUnionValueChange(Type.AFTER, oldValue, this.after);
        }

        @Override
        public final Builder after(Instant after) {
            Object oldValue = this.after;
            this.after = after;
            handleUnionValueChange(Type.AFTER, oldValue, this.after);
            return this;
        }

        public final Instant getBefore() {
            return before;
        }

        public final void setBefore(Instant before) {
            Object oldValue = this.before;
            this.before = before;
            handleUnionValueChange(Type.BEFORE, oldValue, this.before);
        }

        @Override
        public final Builder before(Instant before) {
            Object oldValue = this.before;
            this.before = before;
            handleUnionValueChange(Type.BEFORE, oldValue, this.before);
            return this;
        }

        public final AttributeValueList.Builder getEqualsValue() {
            return equalsValue != null ? equalsValue.toBuilder() : null;
        }

        public final void setEqualsValue(AttributeValueList.BuilderImpl equalsValue) {
            Object oldValue = this.equalsValue;
            this.equalsValue = equalsValue != null ? equalsValue.build() : null;
            handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
        }

        @Override
        public final Builder equalsValue(AttributeValueList equalsValue) {
            Object oldValue = this.equalsValue;
            this.equalsValue = equalsValue;
            handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
            return this;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Condition#type()
     */
    public enum Type {
        AFTER,

        BEFORE,

        EQUALS,

        UNKNOWN_TO_SDK_VERSION
    }
}
