/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResponsePlanRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<CreateResponsePlanRequest.Builder, CreateResponsePlanRequest> {
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(CreateResponsePlanRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ChatChannel> CHAT_CHANNEL_FIELD = SdkField.<ChatChannel> builder(MarshallingType.SDK_POJO)
            .memberName("chatChannel").getter(getter(CreateResponsePlanRequest::chatChannel))
            .setter(setter(Builder::chatChannel)).constructor(ChatChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatChannel").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateResponsePlanRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateResponsePlanRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<List<String>> ENGAGEMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("engagements")
            .getter(getter(CreateResponsePlanRequest::engagements))
            .setter(setter(Builder::engagements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IncidentTemplate> INCIDENT_TEMPLATE_FIELD = SdkField
            .<IncidentTemplate> builder(MarshallingType.SDK_POJO).memberName("incidentTemplate")
            .getter(getter(CreateResponsePlanRequest::incidentTemplate)).setter(setter(Builder::incidentTemplate))
            .constructor(IncidentTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplate").build()).build();

    private static final SdkField<List<Integration>> INTEGRATIONS_FIELD = SdkField
            .<List<Integration>> builder(MarshallingType.LIST)
            .memberName("integrations")
            .getter(getter(CreateResponsePlanRequest::integrations))
            .setter(setter(Builder::integrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Integration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateResponsePlanRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateResponsePlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            CHAT_CHANNEL_FIELD, CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, ENGAGEMENTS_FIELD, INCIDENT_TEMPLATE_FIELD,
            INTEGRATIONS_FIELD, NAME_FIELD, TAGS_FIELD));

    private final List<Action> actions;

    private final ChatChannel chatChannel;

    private final String clientToken;

    private final String displayName;

    private final List<String> engagements;

    private final IncidentTemplate incidentTemplate;

    private final List<Integration> integrations;

    private final String name;

    private final Map<String, String> tags;

    private CreateResponsePlanRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.chatChannel = builder.chatChannel;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.engagements = builder.engagements;
        this.incidentTemplate = builder.incidentTemplate;
        this.integrations = builder.integrations;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions that the response plan starts at the beginning of an incident.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions that the response plan starts at the beginning of an incident.
     */
    public final List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * The Chatbot chat channel used for collaboration during an incident.
     * </p>
     * 
     * @return The Chatbot chat channel used for collaboration during an incident.
     */
    public final ChatChannel chatChannel() {
        return chatChannel;
    }

    /**
     * <p>
     * A token ensuring that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token ensuring that the operation is called only once with the specified details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The long format of the response plan name. This field can contain spaces.
     * </p>
     * 
     * @return The long format of the response plan name. This field can contain spaces.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Engagements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngagements() {
        return engagements != null && !(engagements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an
     * incident.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngagements} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages
     *         during an incident.
     */
    public final List<String> engagements() {
        return engagements;
    }

    /**
     * <p>
     * Details used to create an incident when using this response plan.
     * </p>
     * 
     * @return Details used to create an incident when using this response plan.
     */
    public final IncidentTemplate incidentTemplate() {
        return incidentTemplate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Integrations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegrations() {
        return integrations != null && !(integrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about third-party services integrated into the response plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegrations} method.
     * </p>
     * 
     * @return Information about third-party services integrated into the response plan.
     */
    public final List<Integration> integrations() {
        return integrations;
    }

    /**
     * <p>
     * The short format name of the response plan. Can't include spaces.
     * </p>
     * 
     * @return The short format name of the response plan. Can't include spaces.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags that you are adding to the response plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that you are adding to the response plan.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(chatChannel());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngagements() ? engagements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(incidentTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegrations() ? integrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResponsePlanRequest)) {
            return false;
        }
        CreateResponsePlanRequest other = (CreateResponsePlanRequest) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(chatChannel(), other.chatChannel()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(displayName(), other.displayName()) && hasEngagements() == other.hasEngagements()
                && Objects.equals(engagements(), other.engagements())
                && Objects.equals(incidentTemplate(), other.incidentTemplate()) && hasIntegrations() == other.hasIntegrations()
                && Objects.equals(integrations(), other.integrations()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResponsePlanRequest").add("Actions", hasActions() ? actions() : null)
                .add("ChatChannel", chatChannel()).add("ClientToken", clientToken()).add("DisplayName", displayName())
                .add("Engagements", hasEngagements() ? engagements() : null).add("IncidentTemplate", incidentTemplate())
                .add("Integrations", hasIntegrations() ? integrations() : null).add("Name", name())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "chatChannel":
            return Optional.ofNullable(clazz.cast(chatChannel()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "engagements":
            return Optional.ofNullable(clazz.cast(engagements()));
        case "incidentTemplate":
            return Optional.ofNullable(clazz.cast(incidentTemplate()));
        case "integrations":
            return Optional.ofNullable(clazz.cast(integrations()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResponsePlanRequest, T> g) {
        return obj -> g.apply((CreateResponsePlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResponsePlanRequest> {
        /**
         * <p>
         * The actions that the response plan starts at the beginning of an incident.
         * </p>
         * 
         * @param actions
         *        The actions that the response plan starts at the beginning of an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions that the response plan starts at the beginning of an incident.
         * </p>
         * 
         * @param actions
         *        The actions that the response plan starts at the beginning of an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions that the response plan starts at the beginning of an incident.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.Action.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmincidents.model.Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.Action.Builder#build()} is called immediately and
         * its result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * The Chatbot chat channel used for collaboration during an incident.
         * </p>
         * 
         * @param chatChannel
         *        The Chatbot chat channel used for collaboration during an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatChannel(ChatChannel chatChannel);

        /**
         * <p>
         * The Chatbot chat channel used for collaboration during an incident.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatChannel.Builder} avoiding the need to
         * create one manually via {@link ChatChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatChannel.Builder#build()} is called immediately and its result
         * is passed to {@link #chatChannel(ChatChannel)}.
         * 
         * @param chatChannel
         *        a consumer that will call methods on {@link ChatChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chatChannel(ChatChannel)
         */
        default Builder chatChannel(Consumer<ChatChannel.Builder> chatChannel) {
            return chatChannel(ChatChannel.builder().applyMutation(chatChannel).build());
        }

        /**
         * <p>
         * A token ensuring that the operation is called only once with the specified details.
         * </p>
         * 
         * @param clientToken
         *        A token ensuring that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The long format of the response plan name. This field can contain spaces.
         * </p>
         * 
         * @param displayName
         *        The long format of the response plan name. This field can contain spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an
         * incident.
         * </p>
         * 
         * @param engagements
         *        The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages
         *        during an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagements(Collection<String> engagements);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an
         * incident.
         * </p>
         * 
         * @param engagements
         *        The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages
         *        during an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagements(String... engagements);

        /**
         * <p>
         * Details used to create an incident when using this response plan.
         * </p>
         * 
         * @param incidentTemplate
         *        Details used to create an incident when using this response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentTemplate(IncidentTemplate incidentTemplate);

        /**
         * <p>
         * Details used to create an incident when using this response plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link IncidentTemplate.Builder} avoiding the
         * need to create one manually via {@link IncidentTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IncidentTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #incidentTemplate(IncidentTemplate)}.
         * 
         * @param incidentTemplate
         *        a consumer that will call methods on {@link IncidentTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incidentTemplate(IncidentTemplate)
         */
        default Builder incidentTemplate(Consumer<IncidentTemplate.Builder> incidentTemplate) {
            return incidentTemplate(IncidentTemplate.builder().applyMutation(incidentTemplate).build());
        }

        /**
         * <p>
         * Information about third-party services integrated into the response plan.
         * </p>
         * 
         * @param integrations
         *        Information about third-party services integrated into the response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(Collection<Integration> integrations);

        /**
         * <p>
         * Information about third-party services integrated into the response plan.
         * </p>
         * 
         * @param integrations
         *        Information about third-party services integrated into the response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(Integration... integrations);

        /**
         * <p>
         * Information about third-party services integrated into the response plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.Integration.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmincidents.model.Integration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.Integration.Builder#build()} is called immediately
         * and its result is passed to {@link #integrations(List<Integration>)}.
         * 
         * @param integrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.Integration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrations(java.util.Collection<Integration>)
         */
        Builder integrations(Consumer<Integration.Builder>... integrations);

        /**
         * <p>
         * The short format name of the response plan. Can't include spaces.
         * </p>
         * 
         * @param name
         *        The short format name of the response plan. Can't include spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of tags that you are adding to the response plan.
         * </p>
         * 
         * @param tags
         *        A list of tags that you are adding to the response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private ChatChannel chatChannel;

        private String clientToken;

        private String displayName;

        private List<String> engagements = DefaultSdkAutoConstructList.getInstance();

        private IncidentTemplate incidentTemplate;

        private List<Integration> integrations = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResponsePlanRequest model) {
            super(model);
            actions(model.actions);
            chatChannel(model.chatChannel);
            clientToken(model.clientToken);
            displayName(model.displayName);
            engagements(model.engagements);
            incidentTemplate(model.incidentTemplate);
            integrations(model.integrations);
            name(model.name);
            tags(model.tags);
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionsListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ChatChannel.Builder getChatChannel() {
            return chatChannel != null ? chatChannel.toBuilder() : null;
        }

        public final void setChatChannel(ChatChannel.BuilderImpl chatChannel) {
            this.chatChannel = chatChannel != null ? chatChannel.build() : null;
        }

        @Override
        public final Builder chatChannel(ChatChannel chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getEngagements() {
            if (engagements instanceof SdkAutoConstructList) {
                return null;
            }
            return engagements;
        }

        public final void setEngagements(Collection<String> engagements) {
            this.engagements = EngagementSetCopier.copy(engagements);
        }

        @Override
        public final Builder engagements(Collection<String> engagements) {
            this.engagements = EngagementSetCopier.copy(engagements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagements(String... engagements) {
            engagements(Arrays.asList(engagements));
            return this;
        }

        public final IncidentTemplate.Builder getIncidentTemplate() {
            return incidentTemplate != null ? incidentTemplate.toBuilder() : null;
        }

        public final void setIncidentTemplate(IncidentTemplate.BuilderImpl incidentTemplate) {
            this.incidentTemplate = incidentTemplate != null ? incidentTemplate.build() : null;
        }

        @Override
        public final Builder incidentTemplate(IncidentTemplate incidentTemplate) {
            this.incidentTemplate = incidentTemplate;
            return this;
        }

        public final List<Integration.Builder> getIntegrations() {
            List<Integration.Builder> result = IntegrationsCopier.copyToBuilder(this.integrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrations(Collection<Integration.BuilderImpl> integrations) {
            this.integrations = IntegrationsCopier.copyFromBuilder(integrations);
        }

        @Override
        public final Builder integrations(Collection<Integration> integrations) {
            this.integrations = IntegrationsCopier.copy(integrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Integration... integrations) {
            integrations(Arrays.asList(integrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Consumer<Integration.Builder>... integrations) {
            integrations(Stream.of(integrations).map(c -> Integration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResponsePlanRequest build() {
            return new CreateResponsePlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
