/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dynamic SSM parameter value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamicSsmParameterValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamicSsmParameterValue.Builder, DynamicSsmParameterValue> {
    private static final SdkField<String> VARIABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variable").getter(getter(DynamicSsmParameterValue::variableAsString)).setter(setter(Builder::variable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String variable;

    private final Type type;

    private DynamicSsmParameterValue(BuilderImpl builder) {
        this.variable = builder.variable;
        this.type = builder.type;
    }

    /**
     * <p>
     * Variable dynamic parameters. A parameter value is determined when an incident is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #variable} will
     * return {@link VariableType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #variableAsString}.
     * </p>
     * 
     * @return Variable dynamic parameters. A parameter value is determined when an incident is created.
     * @see VariableType
     */
    public final VariableType variable() {
        return VariableType.fromValue(variable);
    }

    /**
     * <p>
     * Variable dynamic parameters. A parameter value is determined when an incident is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #variable} will
     * return {@link VariableType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #variableAsString}.
     * </p>
     * 
     * @return Variable dynamic parameters. A parameter value is determined when an incident is created.
     * @see VariableType
     */
    public final String variableAsString() {
        return variable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(variableAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicSsmParameterValue)) {
            return false;
        }
        DynamicSsmParameterValue other = (DynamicSsmParameterValue) obj;
        return Objects.equals(variableAsString(), other.variableAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamicSsmParameterValue").add("Variable", variableAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variable":
            return Optional.ofNullable(clazz.cast(variableAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #variableAsString()} initialized to the given value.
     *
     * <p>
     * Variable dynamic parameters. A parameter value is determined when an incident is created.
     * </p>
     * 
     * @param variable
     *        Variable dynamic parameters. A parameter value is determined when an incident is created.
     * @see VariableType
     */
    public static DynamicSsmParameterValue fromVariable(String variable) {
        return builder().variable(variable).build();
    }

    /**
     * Create an instance of this class with {@link #variableAsString()} initialized to the given value.
     *
     * <p>
     * Variable dynamic parameters. A parameter value is determined when an incident is created.
     * </p>
     * 
     * @param variable
     *        Variable dynamic parameters. A parameter value is determined when an incident is created.
     * @see VariableType
     */
    public static DynamicSsmParameterValue fromVariable(VariableType variable) {
        return builder().variable(variable).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamicSsmParameterValue, T> g) {
        return obj -> g.apply((DynamicSsmParameterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamicSsmParameterValue> {
        /**
         * <p>
         * Variable dynamic parameters. A parameter value is determined when an incident is created.
         * </p>
         * 
         * @param variable
         *        Variable dynamic parameters. A parameter value is determined when an incident is created.
         * @see VariableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VariableType
         */
        Builder variable(String variable);

        /**
         * <p>
         * Variable dynamic parameters. A parameter value is determined when an incident is created.
         * </p>
         * 
         * @param variable
         *        Variable dynamic parameters. A parameter value is determined when an incident is created.
         * @see VariableType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VariableType
         */
        Builder variable(VariableType variable);
    }

    static final class BuilderImpl implements Builder {
        private String variable;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicSsmParameterValue model) {
            variable(model.variable);
        }

        public final String getVariable() {
            return variable;
        }

        public final void setVariable(String variable) {
            Object oldValue = this.variable;
            this.variable = variable;
            handleUnionValueChange(Type.VARIABLE, oldValue, this.variable);
        }

        @Override
        public final Builder variable(String variable) {
            Object oldValue = this.variable;
            this.variable = variable;
            handleUnionValueChange(Type.VARIABLE, oldValue, this.variable);
            return this;
        }

        @Override
        public final Builder variable(VariableType variable) {
            this.variable(variable == null ? null : variable.toString());
            return this;
        }

        @Override
        public DynamicSsmParameterValue build() {
            return new DynamicSsmParameterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DynamicSsmParameterValue#type()
     */
    public enum Type {
        VARIABLE,

        UNKNOWN_TO_SDK_VERSION
    }
}
