/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTimelineEventRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<GetTimelineEventRequest.Builder, GetTimelineEventRequest> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(GetTimelineEventRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("eventId").build()).build();

    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incidentRecordArn").getter(getter(GetTimelineEventRequest::incidentRecordArn))
            .setter(setter(Builder::incidentRecordArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("incidentRecordArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            INCIDENT_RECORD_ARN_FIELD));

    private final String eventId;

    private final String incidentRecordArn;

    private GetTimelineEventRequest(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.incidentRecordArn = builder.incidentRecordArn;
    }

    /**
     * <p>
     * The ID of the event. You can get an event's ID when you create it, or by using <code>ListTimelineEvents</code>.
     * </p>
     * 
     * @return The ID of the event. You can get an event's ID when you create it, or by using
     *         <code>ListTimelineEvents</code>.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the incident that includes the timeline event.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the incident that includes the timeline event.
     */
    public final String incidentRecordArn() {
        return incidentRecordArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(incidentRecordArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTimelineEventRequest)) {
            return false;
        }
        GetTimelineEventRequest other = (GetTimelineEventRequest) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(incidentRecordArn(), other.incidentRecordArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTimelineEventRequest").add("EventId", eventId())
                .add("IncidentRecordArn", incidentRecordArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "incidentRecordArn":
            return Optional.ofNullable(clazz.cast(incidentRecordArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTimelineEventRequest, T> g) {
        return obj -> g.apply((GetTimelineEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTimelineEventRequest> {
        /**
         * <p>
         * The ID of the event. You can get an event's ID when you create it, or by using
         * <code>ListTimelineEvents</code>.
         * </p>
         * 
         * @param eventId
         *        The ID of the event. You can get an event's ID when you create it, or by using
         *        <code>ListTimelineEvents</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the incident that includes the timeline event.
         * </p>
         * 
         * @param incidentRecordArn
         *        The Amazon Resource Name (ARN) of the incident that includes the timeline event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentRecordArn(String incidentRecordArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private String eventId;

        private String incidentRecordArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTimelineEventRequest model) {
            super(model);
            eventId(model.eventId);
            incidentRecordArn(model.incidentRecordArn);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getIncidentRecordArn() {
            return incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTimelineEventRequest build() {
            return new GetTimelineEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
