/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource policy that allows Incident Manager to perform actions on resources on your behalf.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePolicy implements SdkPojo, Serializable, ToCopyableBuilder<ResourcePolicy.Builder, ResourcePolicy> {
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(ResourcePolicy::policyDocument)).setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyId").getter(getter(ResourcePolicy::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyId").build()).build();

    private static final SdkField<String> RAM_RESOURCE_SHARE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ramResourceShareRegion").getter(getter(ResourcePolicy::ramResourceShareRegion))
            .setter(setter(Builder::ramResourceShareRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramResourceShareRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DOCUMENT_FIELD,
            POLICY_ID_FIELD, RAM_RESOURCE_SHARE_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyDocument;

    private final String policyId;

    private final String ramResourceShareRegion;

    private ResourcePolicy(BuilderImpl builder) {
        this.policyDocument = builder.policyDocument;
        this.policyId = builder.policyId;
        this.ramResourceShareRegion = builder.ramResourceShareRegion;
    }

    /**
     * <p>
     * The JSON blob that describes the policy.
     * </p>
     * 
     * @return The JSON blob that describes the policy.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The ID of the resource policy.
     * </p>
     * 
     * @return The ID of the resource policy.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The Amazon Web Services Region that policy allows resources to be used in.
     * </p>
     * 
     * @return The Amazon Web Services Region that policy allows resources to be used in.
     */
    public final String ramResourceShareRegion() {
        return ramResourceShareRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(ramResourceShareRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePolicy)) {
            return false;
        }
        ResourcePolicy other = (ResourcePolicy) obj;
        return Objects.equals(policyDocument(), other.policyDocument()) && Objects.equals(policyId(), other.policyId())
                && Objects.equals(ramResourceShareRegion(), other.ramResourceShareRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourcePolicy").add("PolicyDocument", policyDocument()).add("PolicyId", policyId())
                .add("RamResourceShareRegion", ramResourceShareRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "policyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "ramResourceShareRegion":
            return Optional.ofNullable(clazz.cast(ramResourceShareRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePolicy, T> g) {
        return obj -> g.apply((ResourcePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePolicy> {
        /**
         * <p>
         * The JSON blob that describes the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON blob that describes the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The ID of the resource policy.
         * </p>
         * 
         * @param policyId
         *        The ID of the resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The Amazon Web Services Region that policy allows resources to be used in.
         * </p>
         * 
         * @param ramResourceShareRegion
         *        The Amazon Web Services Region that policy allows resources to be used in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramResourceShareRegion(String ramResourceShareRegion);
    }

    static final class BuilderImpl implements Builder {
        private String policyDocument;

        private String policyId;

        private String ramResourceShareRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePolicy model) {
            policyDocument(model.policyDocument);
            policyId(model.policyId);
            ramResourceShareRegion(model.ramResourceShareRegion);
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getRamResourceShareRegion() {
            return ramResourceShareRegion;
        }

        public final void setRamResourceShareRegion(String ramResourceShareRegion) {
            this.ramResourceShareRegion = ramResourceShareRegion;
        }

        @Override
        public final Builder ramResourceShareRegion(String ramResourceShareRegion) {
            this.ramResourceShareRegion = ramResourceShareRegion;
            return this;
        }

        @Override
        public ResourcePolicy build() {
            return new ResourcePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
