/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.PagerDutyIncidentDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemValue> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ItemValue.getter(ItemValue::arn)).setter(ItemValue.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> METRIC_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricDefinition").getter(ItemValue.getter(ItemValue::metricDefinition)).setter(ItemValue.setter(Builder::metricDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDefinition").build()}).build();
    private static final SdkField<PagerDutyIncidentDetail> PAGER_DUTY_INCIDENT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pagerDutyIncidentDetail").getter(ItemValue.getter(ItemValue::pagerDutyIncidentDetail)).setter(ItemValue.setter(Builder::pagerDutyIncidentDetail)).constructor(PagerDutyIncidentDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pagerDutyIncidentDetail").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(ItemValue.getter(ItemValue::url)).setter(ItemValue.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, METRIC_DEFINITION_FIELD, PAGER_DUTY_INCIDENT_DETAIL_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ItemValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String metricDefinition;
    private final PagerDutyIncidentDetail pagerDutyIncidentDetail;
    private final String url;
    private final Type type;

    private ItemValue(BuilderImpl builder) {
        this.arn = builder.arn;
        this.metricDefinition = builder.metricDefinition;
        this.pagerDutyIncidentDetail = builder.pagerDutyIncidentDetail;
        this.url = builder.url;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final String metricDefinition() {
        return this.metricDefinition;
    }

    public final PagerDutyIncidentDetail pagerDutyIncidentDetail() {
        return this.pagerDutyIncidentDetail;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.pagerDutyIncidentDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemValue)) {
            return false;
        }
        ItemValue other = (ItemValue)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.metricDefinition(), other.metricDefinition()) && Objects.equals(this.pagerDutyIncidentDetail(), other.pagerDutyIncidentDetail()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"ItemValue").add("Arn", (Object)this.arn()).add("MetricDefinition", (Object)this.metricDefinition()).add("PagerDutyIncidentDetail", (Object)this.pagerDutyIncidentDetail()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "metricDefinition": {
                return Optional.ofNullable(clazz.cast(this.metricDefinition()));
            }
            case "pagerDutyIncidentDetail": {
                return Optional.ofNullable(clazz.cast(this.pagerDutyIncidentDetail()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public static ItemValue fromArn(String arn) {
        return (ItemValue)ItemValue.builder().arn(arn).build();
    }

    public static ItemValue fromMetricDefinition(String metricDefinition) {
        return (ItemValue)ItemValue.builder().metricDefinition(metricDefinition).build();
    }

    public static ItemValue fromPagerDutyIncidentDetail(PagerDutyIncidentDetail pagerDutyIncidentDetail) {
        return (ItemValue)ItemValue.builder().pagerDutyIncidentDetail(pagerDutyIncidentDetail).build();
    }

    public static ItemValue fromPagerDutyIncidentDetail(Consumer<PagerDutyIncidentDetail.Builder> pagerDutyIncidentDetail) {
        PagerDutyIncidentDetail.Builder builder = PagerDutyIncidentDetail.builder();
        pagerDutyIncidentDetail.accept(builder);
        return ItemValue.fromPagerDutyIncidentDetail((PagerDutyIncidentDetail)builder.build());
    }

    public static ItemValue fromUrl(String url) {
        return (ItemValue)ItemValue.builder().url(url).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("metricDefinition", METRIC_DEFINITION_FIELD);
        map.put("pagerDutyIncidentDetail", PAGER_DUTY_INCIDENT_DETAIL_FIELD);
        map.put("url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemValue, T> g) {
        return obj -> g.apply((ItemValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ARN,
        METRIC_DEFINITION,
        PAGER_DUTY_INCIDENT_DETAIL,
        URL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String metricDefinition;
        private PagerDutyIncidentDetail pagerDutyIncidentDetail;
        private String url;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ItemValue model) {
            this.arn(model.arn);
            this.metricDefinition(model.metricDefinition);
            this.pagerDutyIncidentDetail(model.pagerDutyIncidentDetail);
            this.url(model.url);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            String oldValue = this.arn;
            this.arn = arn;
            this.handleUnionValueChange(Type.ARN, oldValue, this.arn);
        }

        @Override
        public final Builder arn(String arn) {
            String oldValue = this.arn;
            this.arn = arn;
            this.handleUnionValueChange(Type.ARN, oldValue, this.arn);
            return this;
        }

        public final String getMetricDefinition() {
            return this.metricDefinition;
        }

        public final void setMetricDefinition(String metricDefinition) {
            String oldValue = this.metricDefinition;
            this.metricDefinition = metricDefinition;
            this.handleUnionValueChange(Type.METRIC_DEFINITION, oldValue, this.metricDefinition);
        }

        @Override
        public final Builder metricDefinition(String metricDefinition) {
            String oldValue = this.metricDefinition;
            this.metricDefinition = metricDefinition;
            this.handleUnionValueChange(Type.METRIC_DEFINITION, oldValue, this.metricDefinition);
            return this;
        }

        public final PagerDutyIncidentDetail.Builder getPagerDutyIncidentDetail() {
            return this.pagerDutyIncidentDetail != null ? this.pagerDutyIncidentDetail.toBuilder() : null;
        }

        public final void setPagerDutyIncidentDetail(PagerDutyIncidentDetail.BuilderImpl pagerDutyIncidentDetail) {
            PagerDutyIncidentDetail oldValue = this.pagerDutyIncidentDetail;
            this.pagerDutyIncidentDetail = pagerDutyIncidentDetail != null ? pagerDutyIncidentDetail.build() : null;
            this.handleUnionValueChange(Type.PAGER_DUTY_INCIDENT_DETAIL, oldValue, this.pagerDutyIncidentDetail);
        }

        @Override
        public final Builder pagerDutyIncidentDetail(PagerDutyIncidentDetail pagerDutyIncidentDetail) {
            PagerDutyIncidentDetail oldValue = this.pagerDutyIncidentDetail;
            this.pagerDutyIncidentDetail = pagerDutyIncidentDetail;
            this.handleUnionValueChange(Type.PAGER_DUTY_INCIDENT_DETAIL, oldValue, this.pagerDutyIncidentDetail);
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            String oldValue = this.url;
            this.url = url;
            this.handleUnionValueChange(Type.URL, oldValue, this.url);
        }

        @Override
        public final Builder url(String url) {
            String oldValue = this.url;
            this.url = url;
            this.handleUnionValueChange(Type.URL, oldValue, this.url);
            return this;
        }

        public ItemValue build() {
            return new ItemValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemValue> {
        public Builder arn(String var1);

        public Builder metricDefinition(String var1);

        public Builder pagerDutyIncidentDetail(PagerDutyIncidentDetail var1);

        default public Builder pagerDutyIncidentDetail(Consumer<PagerDutyIncidentDetail.Builder> pagerDutyIncidentDetail) {
            return this.pagerDutyIncidentDetail((PagerDutyIncidentDetail)((PagerDutyIncidentDetail.Builder)PagerDutyIncidentDetail.builder().applyMutation(pagerDutyIncidentDetail)).build());
        }

        public Builder url(String var1);
    }
}

