/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of the associated host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedHost implements SdkPojo, Serializable, ToCopyableBuilder<AssociatedHost.Builder, AssociatedHost> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Hostname").getter(getter(AssociatedHost::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2InstanceId").getter(getter(AssociatedHost::ec2InstanceId)).setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()).build();

    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OsVersion").getter(getter(AssociatedHost::osVersion)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD,
            EC2_INSTANCE_ID_FIELD, OS_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostname;

    private final String ec2InstanceId;

    private final String osVersion;

    private AssociatedHost(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.osVersion = builder.osVersion;
    }

    /**
     * <p>
     * The name of the host.
     * </p>
     * 
     * @return The name of the host.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 instance.
     * </p>
     * 
     * @return The ID of the Amazon EC2 instance.
     */
    public final String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p>
     * The version of the operating system.
     * </p>
     * 
     * @return The version of the operating system.
     */
    public final String osVersion() {
        return osVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(osVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedHost)) {
            return false;
        }
        AssociatedHost other = (AssociatedHost) obj;
        return Objects.equals(hostname(), other.hostname()) && Objects.equals(ec2InstanceId(), other.ec2InstanceId())
                && Objects.equals(osVersion(), other.osVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedHost").add("Hostname", hostname()).add("Ec2InstanceId", ec2InstanceId())
                .add("OsVersion", osVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "Ec2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        case "OsVersion":
            return Optional.ofNullable(clazz.cast(osVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedHost, T> g) {
        return obj -> g.apply((AssociatedHost) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedHost> {
        /**
         * <p>
         * The name of the host.
         * </p>
         * 
         * @param hostname
         *        The name of the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The ID of the Amazon EC2 instance.
         * </p>
         * 
         * @param ec2InstanceId
         *        The ID of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p>
         * The version of the operating system.
         * </p>
         * 
         * @param osVersion
         *        The version of the operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osVersion(String osVersion);
    }

    static final class BuilderImpl implements Builder {
        private String hostname;

        private String ec2InstanceId;

        private String osVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedHost model) {
            hostname(model.hostname);
            ec2InstanceId(model.ec2InstanceId);
            osVersion(model.osVersion);
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @Override
        public AssociatedHost build() {
            return new AssociatedHost(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
