/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the SAP HANA system replication for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resilience implements SdkPojo, Serializable, ToCopyableBuilder<Resilience.Builder, Resilience> {
    private static final SdkField<String> HSR_TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HsrTier").getter(getter(Resilience::hsrTier)).setter(setter(Builder::hsrTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsrTier").build()).build();

    private static final SdkField<String> HSR_REPLICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HsrReplicationMode").getter(getter(Resilience::hsrReplicationModeAsString))
            .setter(setter(Builder::hsrReplicationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsrReplicationMode").build())
            .build();

    private static final SdkField<String> HSR_OPERATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HsrOperationMode").getter(getter(Resilience::hsrOperationModeAsString))
            .setter(setter(Builder::hsrOperationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsrOperationMode").build()).build();

    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterStatus").getter(getter(Resilience::clusterStatusAsString)).setter(setter(Builder::clusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSR_TIER_FIELD,
            HSR_REPLICATION_MODE_FIELD, HSR_OPERATION_MODE_FIELD, CLUSTER_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hsrTier;

    private final String hsrReplicationMode;

    private final String hsrOperationMode;

    private final String clusterStatus;

    private Resilience(BuilderImpl builder) {
        this.hsrTier = builder.hsrTier;
        this.hsrReplicationMode = builder.hsrReplicationMode;
        this.hsrOperationMode = builder.hsrOperationMode;
        this.clusterStatus = builder.clusterStatus;
    }

    /**
     * <p>
     * The tier of the component.
     * </p>
     * 
     * @return The tier of the component.
     */
    public final String hsrTier() {
        return hsrTier;
    }

    /**
     * <p>
     * The replication mode of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hsrReplicationMode} will return {@link ReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #hsrReplicationModeAsString}.
     * </p>
     * 
     * @return The replication mode of the component.
     * @see ReplicationMode
     */
    public final ReplicationMode hsrReplicationMode() {
        return ReplicationMode.fromValue(hsrReplicationMode);
    }

    /**
     * <p>
     * The replication mode of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hsrReplicationMode} will return {@link ReplicationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #hsrReplicationModeAsString}.
     * </p>
     * 
     * @return The replication mode of the component.
     * @see ReplicationMode
     */
    public final String hsrReplicationModeAsString() {
        return hsrReplicationMode;
    }

    /**
     * <p>
     * The operation mode of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hsrOperationMode}
     * will return {@link OperationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hsrOperationModeAsString}.
     * </p>
     * 
     * @return The operation mode of the component.
     * @see OperationMode
     */
    public final OperationMode hsrOperationMode() {
        return OperationMode.fromValue(hsrOperationMode);
    }

    /**
     * <p>
     * The operation mode of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hsrOperationMode}
     * will return {@link OperationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hsrOperationModeAsString}.
     * </p>
     * 
     * @return The operation mode of the component.
     * @see OperationMode
     */
    public final String hsrOperationModeAsString() {
        return hsrOperationMode;
    }

    /**
     * <p>
     * The cluster status of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The cluster status of the component.
     * @see ClusterStatus
     */
    public final ClusterStatus clusterStatus() {
        return ClusterStatus.fromValue(clusterStatus);
    }

    /**
     * <p>
     * The cluster status of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The cluster status of the component.
     * @see ClusterStatus
     */
    public final String clusterStatusAsString() {
        return clusterStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hsrTier());
        hashCode = 31 * hashCode + Objects.hashCode(hsrReplicationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hsrOperationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resilience)) {
            return false;
        }
        Resilience other = (Resilience) obj;
        return Objects.equals(hsrTier(), other.hsrTier())
                && Objects.equals(hsrReplicationModeAsString(), other.hsrReplicationModeAsString())
                && Objects.equals(hsrOperationModeAsString(), other.hsrOperationModeAsString())
                && Objects.equals(clusterStatusAsString(), other.clusterStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resilience").add("HsrTier", hsrTier()).add("HsrReplicationMode", hsrReplicationModeAsString())
                .add("HsrOperationMode", hsrOperationModeAsString()).add("ClusterStatus", clusterStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsrTier":
            return Optional.ofNullable(clazz.cast(hsrTier()));
        case "HsrReplicationMode":
            return Optional.ofNullable(clazz.cast(hsrReplicationModeAsString()));
        case "HsrOperationMode":
            return Optional.ofNullable(clazz.cast(hsrOperationModeAsString()));
        case "ClusterStatus":
            return Optional.ofNullable(clazz.cast(clusterStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resilience, T> g) {
        return obj -> g.apply((Resilience) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resilience> {
        /**
         * <p>
         * The tier of the component.
         * </p>
         * 
         * @param hsrTier
         *        The tier of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsrTier(String hsrTier);

        /**
         * <p>
         * The replication mode of the component.
         * </p>
         * 
         * @param hsrReplicationMode
         *        The replication mode of the component.
         * @see ReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationMode
         */
        Builder hsrReplicationMode(String hsrReplicationMode);

        /**
         * <p>
         * The replication mode of the component.
         * </p>
         * 
         * @param hsrReplicationMode
         *        The replication mode of the component.
         * @see ReplicationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationMode
         */
        Builder hsrReplicationMode(ReplicationMode hsrReplicationMode);

        /**
         * <p>
         * The operation mode of the component.
         * </p>
         * 
         * @param hsrOperationMode
         *        The operation mode of the component.
         * @see OperationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationMode
         */
        Builder hsrOperationMode(String hsrOperationMode);

        /**
         * <p>
         * The operation mode of the component.
         * </p>
         * 
         * @param hsrOperationMode
         *        The operation mode of the component.
         * @see OperationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationMode
         */
        Builder hsrOperationMode(OperationMode hsrOperationMode);

        /**
         * <p>
         * The cluster status of the component.
         * </p>
         * 
         * @param clusterStatus
         *        The cluster status of the component.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder clusterStatus(String clusterStatus);

        /**
         * <p>
         * The cluster status of the component.
         * </p>
         * 
         * @param clusterStatus
         *        The cluster status of the component.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder clusterStatus(ClusterStatus clusterStatus);
    }

    static final class BuilderImpl implements Builder {
        private String hsrTier;

        private String hsrReplicationMode;

        private String hsrOperationMode;

        private String clusterStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Resilience model) {
            hsrTier(model.hsrTier);
            hsrReplicationMode(model.hsrReplicationMode);
            hsrOperationMode(model.hsrOperationMode);
            clusterStatus(model.clusterStatus);
        }

        public final String getHsrTier() {
            return hsrTier;
        }

        public final void setHsrTier(String hsrTier) {
            this.hsrTier = hsrTier;
        }

        @Override
        public final Builder hsrTier(String hsrTier) {
            this.hsrTier = hsrTier;
            return this;
        }

        public final String getHsrReplicationMode() {
            return hsrReplicationMode;
        }

        public final void setHsrReplicationMode(String hsrReplicationMode) {
            this.hsrReplicationMode = hsrReplicationMode;
        }

        @Override
        public final Builder hsrReplicationMode(String hsrReplicationMode) {
            this.hsrReplicationMode = hsrReplicationMode;
            return this;
        }

        @Override
        public final Builder hsrReplicationMode(ReplicationMode hsrReplicationMode) {
            this.hsrReplicationMode(hsrReplicationMode == null ? null : hsrReplicationMode.toString());
            return this;
        }

        public final String getHsrOperationMode() {
            return hsrOperationMode;
        }

        public final void setHsrOperationMode(String hsrOperationMode) {
            this.hsrOperationMode = hsrOperationMode;
        }

        @Override
        public final Builder hsrOperationMode(String hsrOperationMode) {
            this.hsrOperationMode = hsrOperationMode;
            return this;
        }

        @Override
        public final Builder hsrOperationMode(OperationMode hsrOperationMode) {
            this.hsrOperationMode(hsrOperationMode == null ? null : hsrOperationMode.toString());
            return this;
        }

        public final String getClusterStatus() {
            return clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(ClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        @Override
        public Resilience build() {
            return new Resilience(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
