/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationDiscoveryStatus {
    SUCCESS("SUCCESS"),
    REGISTRATION_FAILED("REGISTRATION_FAILED"),
    REFRESH_FAILED("REFRESH_FAILED"),
    REGISTERING("REGISTERING"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationDiscoveryStatus> VALUE_MAP;
    private final String value;

    private ApplicationDiscoveryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationDiscoveryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationDiscoveryStatus> knownValues() {
        EnumSet<ApplicationDiscoveryStatus> knownValues = EnumSet.allOf(ApplicationDiscoveryStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationDiscoveryStatus.class, ApplicationDiscoveryStatus::toString);
    }
}

