/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.AssociatedHost;
import software.amazon.awssdk.services.ssmsap.model.ComponentIdListCopier;
import software.amazon.awssdk.services.ssmsap.model.ComponentStatus;
import software.amazon.awssdk.services.ssmsap.model.ComponentType;
import software.amazon.awssdk.services.ssmsap.model.DatabaseConnection;
import software.amazon.awssdk.services.ssmsap.model.DatabaseIdListCopier;
import software.amazon.awssdk.services.ssmsap.model.Host;
import software.amazon.awssdk.services.ssmsap.model.HostListCopier;
import software.amazon.awssdk.services.ssmsap.model.Resilience;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Component
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Component> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentId").getter(Component.getter(Component::componentId)).setter(Component.setter(Builder::componentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()}).build();
    private static final SdkField<String> SID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sid").getter(Component.getter(Component::sid)).setter(Component.setter(Builder::sid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sid").build()}).build();
    private static final SdkField<String> SYSTEM_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SystemNumber").getter(Component.getter(Component::systemNumber)).setter(Component.setter(Builder::systemNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemNumber").build()}).build();
    private static final SdkField<String> PARENT_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentComponent").getter(Component.getter(Component::parentComponent)).setter(Component.setter(Builder::parentComponent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentComponent").build()}).build();
    private static final SdkField<List<String>> CHILD_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChildComponents").getter(Component.getter(Component::childComponents)).setter(Component.setter(Builder::childComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(Component.getter(Component::applicationId)).setter(Component.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentType").getter(Component.getter(Component::componentTypeAsString)).setter(Component.setter(Builder::componentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Component.getter(Component::statusAsString)).setter(Component.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SAP_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SapHostname").getter(Component.getter(Component::sapHostname)).setter(Component.setter(Builder::sapHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SapHostname").build()}).build();
    private static final SdkField<String> SAP_FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SapFeature").getter(Component.getter(Component::sapFeature)).setter(Component.setter(Builder::sapFeature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SapFeature").build()}).build();
    private static final SdkField<String> SAP_KERNEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SapKernelVersion").getter(Component.getter(Component::sapKernelVersion)).setter(Component.setter(Builder::sapKernelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SapKernelVersion").build()}).build();
    private static final SdkField<String> HDB_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HdbVersion").getter(Component.getter(Component::hdbVersion)).setter(Component.setter(Builder::hdbVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HdbVersion").build()}).build();
    private static final SdkField<Resilience> RESILIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resilience").getter(Component.getter(Component::resilience)).setter(Component.setter(Builder::resilience)).constructor(Resilience::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resilience").build()}).build();
    private static final SdkField<AssociatedHost> ASSOCIATED_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociatedHost").getter(Component.getter(Component::associatedHost)).setter(Component.setter(Builder::associatedHost)).constructor(AssociatedHost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedHost").build()}).build();
    private static final SdkField<List<String>> DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Databases").getter(Component.getter(Component::databases)).setter(Component.setter(Builder::databases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Databases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Host>> HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Hosts").getter(Component.getter(Component::hosts)).setter(Component.setter(Builder::hosts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hosts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Host::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRIMARY_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryHost").getter(Component.getter(Component::primaryHost)).setter(Component.setter(Builder::primaryHost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryHost").build()}).build();
    private static final SdkField<DatabaseConnection> DATABASE_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseConnection").getter(Component.getter(Component::databaseConnection)).setter(Component.setter(Builder::databaseConnection)).constructor(DatabaseConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseConnection").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(Component.getter(Component::lastUpdated)).setter(Component.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Component.getter(Component::arn)).setter(Component.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD, SID_FIELD, SYSTEM_NUMBER_FIELD, PARENT_COMPONENT_FIELD, CHILD_COMPONENTS_FIELD, APPLICATION_ID_FIELD, COMPONENT_TYPE_FIELD, STATUS_FIELD, SAP_HOSTNAME_FIELD, SAP_FEATURE_FIELD, SAP_KERNEL_VERSION_FIELD, HDB_VERSION_FIELD, RESILIENCE_FIELD, ASSOCIATED_HOST_FIELD, DATABASES_FIELD, HOSTS_FIELD, PRIMARY_HOST_FIELD, DATABASE_CONNECTION_FIELD, LAST_UPDATED_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Component.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String componentId;
    private final String sid;
    private final String systemNumber;
    private final String parentComponent;
    private final List<String> childComponents;
    private final String applicationId;
    private final String componentType;
    private final String status;
    private final String sapHostname;
    private final String sapFeature;
    private final String sapKernelVersion;
    private final String hdbVersion;
    private final Resilience resilience;
    private final AssociatedHost associatedHost;
    private final List<String> databases;
    private final List<Host> hosts;
    private final String primaryHost;
    private final DatabaseConnection databaseConnection;
    private final Instant lastUpdated;
    private final String arn;

    private Component(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.sid = builder.sid;
        this.systemNumber = builder.systemNumber;
        this.parentComponent = builder.parentComponent;
        this.childComponents = builder.childComponents;
        this.applicationId = builder.applicationId;
        this.componentType = builder.componentType;
        this.status = builder.status;
        this.sapHostname = builder.sapHostname;
        this.sapFeature = builder.sapFeature;
        this.sapKernelVersion = builder.sapKernelVersion;
        this.hdbVersion = builder.hdbVersion;
        this.resilience = builder.resilience;
        this.associatedHost = builder.associatedHost;
        this.databases = builder.databases;
        this.hosts = builder.hosts;
        this.primaryHost = builder.primaryHost;
        this.databaseConnection = builder.databaseConnection;
        this.lastUpdated = builder.lastUpdated;
        this.arn = builder.arn;
    }

    public final String componentId() {
        return this.componentId;
    }

    public final String sid() {
        return this.sid;
    }

    public final String systemNumber() {
        return this.systemNumber;
    }

    public final String parentComponent() {
        return this.parentComponent;
    }

    public final boolean hasChildComponents() {
        return this.childComponents != null && !(this.childComponents instanceof SdkAutoConstructList);
    }

    public final List<String> childComponents() {
        return this.childComponents;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final ComponentType componentType() {
        return ComponentType.fromValue(this.componentType);
    }

    public final String componentTypeAsString() {
        return this.componentType;
    }

    public final ComponentStatus status() {
        return ComponentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String sapHostname() {
        return this.sapHostname;
    }

    public final String sapFeature() {
        return this.sapFeature;
    }

    public final String sapKernelVersion() {
        return this.sapKernelVersion;
    }

    public final String hdbVersion() {
        return this.hdbVersion;
    }

    public final Resilience resilience() {
        return this.resilience;
    }

    public final AssociatedHost associatedHost() {
        return this.associatedHost;
    }

    public final boolean hasDatabases() {
        return this.databases != null && !(this.databases instanceof SdkAutoConstructList);
    }

    public final List<String> databases() {
        return this.databases;
    }

    @Deprecated
    public final boolean hasHosts() {
        return this.hosts != null && !(this.hosts instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<Host> hosts() {
        return this.hosts;
    }

    @Deprecated
    public final String primaryHost() {
        return this.primaryHost;
    }

    public final DatabaseConnection databaseConnection() {
        return this.databaseConnection;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sid());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentComponent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChildComponents() ? this.childComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sapHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.sapFeature());
        hashCode = 31 * hashCode + Objects.hashCode(this.sapKernelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hdbVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resilience());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedHost());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabases() ? this.databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHosts() ? this.hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryHost());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseConnection());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        return Objects.equals(this.componentId(), other.componentId()) && Objects.equals(this.sid(), other.sid()) && Objects.equals(this.systemNumber(), other.systemNumber()) && Objects.equals(this.parentComponent(), other.parentComponent()) && this.hasChildComponents() == other.hasChildComponents() && Objects.equals(this.childComponents(), other.childComponents()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.componentTypeAsString(), other.componentTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sapHostname(), other.sapHostname()) && Objects.equals(this.sapFeature(), other.sapFeature()) && Objects.equals(this.sapKernelVersion(), other.sapKernelVersion()) && Objects.equals(this.hdbVersion(), other.hdbVersion()) && Objects.equals(this.resilience(), other.resilience()) && Objects.equals(this.associatedHost(), other.associatedHost()) && this.hasDatabases() == other.hasDatabases() && Objects.equals(this.databases(), other.databases()) && this.hasHosts() == other.hasHosts() && Objects.equals(this.hosts(), other.hosts()) && Objects.equals(this.primaryHost(), other.primaryHost()) && Objects.equals(this.databaseConnection(), other.databaseConnection()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"Component").add("ComponentId", (Object)this.componentId()).add("Sid", (Object)this.sid()).add("SystemNumber", (Object)this.systemNumber()).add("ParentComponent", (Object)this.parentComponent()).add("ChildComponents", this.hasChildComponents() ? this.childComponents() : null).add("ApplicationId", (Object)this.applicationId()).add("ComponentType", (Object)this.componentTypeAsString()).add("Status", (Object)this.statusAsString()).add("SapHostname", (Object)this.sapHostname()).add("SapFeature", (Object)this.sapFeature()).add("SapKernelVersion", (Object)this.sapKernelVersion()).add("HdbVersion", (Object)this.hdbVersion()).add("Resilience", (Object)this.resilience()).add("AssociatedHost", (Object)this.associatedHost()).add("Databases", this.hasDatabases() ? this.databases() : null).add("Hosts", this.hasHosts() ? this.hosts() : null).add("PrimaryHost", (Object)this.primaryHost()).add("DatabaseConnection", (Object)this.databaseConnection()).add("LastUpdated", (Object)this.lastUpdated()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComponentId": {
                return Optional.ofNullable(clazz.cast(this.componentId()));
            }
            case "Sid": {
                return Optional.ofNullable(clazz.cast(this.sid()));
            }
            case "SystemNumber": {
                return Optional.ofNullable(clazz.cast(this.systemNumber()));
            }
            case "ParentComponent": {
                return Optional.ofNullable(clazz.cast(this.parentComponent()));
            }
            case "ChildComponents": {
                return Optional.ofNullable(clazz.cast(this.childComponents()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ComponentType": {
                return Optional.ofNullable(clazz.cast(this.componentTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SapHostname": {
                return Optional.ofNullable(clazz.cast(this.sapHostname()));
            }
            case "SapFeature": {
                return Optional.ofNullable(clazz.cast(this.sapFeature()));
            }
            case "SapKernelVersion": {
                return Optional.ofNullable(clazz.cast(this.sapKernelVersion()));
            }
            case "HdbVersion": {
                return Optional.ofNullable(clazz.cast(this.hdbVersion()));
            }
            case "Resilience": {
                return Optional.ofNullable(clazz.cast(this.resilience()));
            }
            case "AssociatedHost": {
                return Optional.ofNullable(clazz.cast(this.associatedHost()));
            }
            case "Databases": {
                return Optional.ofNullable(clazz.cast(this.databases()));
            }
            case "Hosts": {
                return Optional.ofNullable(clazz.cast(this.hosts()));
            }
            case "PrimaryHost": {
                return Optional.ofNullable(clazz.cast(this.primaryHost()));
            }
            case "DatabaseConnection": {
                return Optional.ofNullable(clazz.cast(this.databaseConnection()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComponentId", COMPONENT_ID_FIELD);
        map.put("Sid", SID_FIELD);
        map.put("SystemNumber", SYSTEM_NUMBER_FIELD);
        map.put("ParentComponent", PARENT_COMPONENT_FIELD);
        map.put("ChildComponents", CHILD_COMPONENTS_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ComponentType", COMPONENT_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SapHostname", SAP_HOSTNAME_FIELD);
        map.put("SapFeature", SAP_FEATURE_FIELD);
        map.put("SapKernelVersion", SAP_KERNEL_VERSION_FIELD);
        map.put("HdbVersion", HDB_VERSION_FIELD);
        map.put("Resilience", RESILIENCE_FIELD);
        map.put("AssociatedHost", ASSOCIATED_HOST_FIELD);
        map.put("Databases", DATABASES_FIELD);
        map.put("Hosts", HOSTS_FIELD);
        map.put("PrimaryHost", PRIMARY_HOST_FIELD);
        map.put("DatabaseConnection", DATABASE_CONNECTION_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Component, T> g) {
        return obj -> g.apply((Component)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentId;
        private String sid;
        private String systemNumber;
        private String parentComponent;
        private List<String> childComponents = DefaultSdkAutoConstructList.getInstance();
        private String applicationId;
        private String componentType;
        private String status;
        private String sapHostname;
        private String sapFeature;
        private String sapKernelVersion;
        private String hdbVersion;
        private Resilience resilience;
        private AssociatedHost associatedHost;
        private List<String> databases = DefaultSdkAutoConstructList.getInstance();
        private List<Host> hosts = DefaultSdkAutoConstructList.getInstance();
        private String primaryHost;
        private DatabaseConnection databaseConnection;
        private Instant lastUpdated;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(Component model) {
            this.componentId(model.componentId);
            this.sid(model.sid);
            this.systemNumber(model.systemNumber);
            this.parentComponent(model.parentComponent);
            this.childComponents(model.childComponents);
            this.applicationId(model.applicationId);
            this.componentType(model.componentType);
            this.status(model.status);
            this.sapHostname(model.sapHostname);
            this.sapFeature(model.sapFeature);
            this.sapKernelVersion(model.sapKernelVersion);
            this.hdbVersion(model.hdbVersion);
            this.resilience(model.resilience);
            this.associatedHost(model.associatedHost);
            this.databases(model.databases);
            this.hosts(model.hosts);
            this.primaryHost(model.primaryHost);
            this.databaseConnection(model.databaseConnection);
            this.lastUpdated(model.lastUpdated);
            this.arn(model.arn);
        }

        public final String getComponentId() {
            return this.componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getSid() {
            return this.sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final String getSystemNumber() {
            return this.systemNumber;
        }

        public final void setSystemNumber(String systemNumber) {
            this.systemNumber = systemNumber;
        }

        @Override
        public final Builder systemNumber(String systemNumber) {
            this.systemNumber = systemNumber;
            return this;
        }

        public final String getParentComponent() {
            return this.parentComponent;
        }

        public final void setParentComponent(String parentComponent) {
            this.parentComponent = parentComponent;
        }

        @Override
        public final Builder parentComponent(String parentComponent) {
            this.parentComponent = parentComponent;
            return this;
        }

        public final Collection<String> getChildComponents() {
            if (this.childComponents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.childComponents;
        }

        public final void setChildComponents(Collection<String> childComponents) {
            this.childComponents = ComponentIdListCopier.copy(childComponents);
        }

        @Override
        public final Builder childComponents(Collection<String> childComponents) {
            this.childComponents = ComponentIdListCopier.copy(childComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childComponents(String ... childComponents) {
            this.childComponents(Arrays.asList(childComponents));
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getComponentType() {
            return this.componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        @Override
        public final Builder componentType(ComponentType componentType) {
            this.componentType(componentType == null ? null : componentType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComponentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSapHostname() {
            return this.sapHostname;
        }

        public final void setSapHostname(String sapHostname) {
            this.sapHostname = sapHostname;
        }

        @Override
        public final Builder sapHostname(String sapHostname) {
            this.sapHostname = sapHostname;
            return this;
        }

        public final String getSapFeature() {
            return this.sapFeature;
        }

        public final void setSapFeature(String sapFeature) {
            this.sapFeature = sapFeature;
        }

        @Override
        public final Builder sapFeature(String sapFeature) {
            this.sapFeature = sapFeature;
            return this;
        }

        public final String getSapKernelVersion() {
            return this.sapKernelVersion;
        }

        public final void setSapKernelVersion(String sapKernelVersion) {
            this.sapKernelVersion = sapKernelVersion;
        }

        @Override
        public final Builder sapKernelVersion(String sapKernelVersion) {
            this.sapKernelVersion = sapKernelVersion;
            return this;
        }

        public final String getHdbVersion() {
            return this.hdbVersion;
        }

        public final void setHdbVersion(String hdbVersion) {
            this.hdbVersion = hdbVersion;
        }

        @Override
        public final Builder hdbVersion(String hdbVersion) {
            this.hdbVersion = hdbVersion;
            return this;
        }

        public final Resilience.Builder getResilience() {
            return this.resilience != null ? this.resilience.toBuilder() : null;
        }

        public final void setResilience(Resilience.BuilderImpl resilience) {
            this.resilience = resilience != null ? resilience.build() : null;
        }

        @Override
        public final Builder resilience(Resilience resilience) {
            this.resilience = resilience;
            return this;
        }

        public final AssociatedHost.Builder getAssociatedHost() {
            return this.associatedHost != null ? this.associatedHost.toBuilder() : null;
        }

        public final void setAssociatedHost(AssociatedHost.BuilderImpl associatedHost) {
            this.associatedHost = associatedHost != null ? associatedHost.build() : null;
        }

        @Override
        public final Builder associatedHost(AssociatedHost associatedHost) {
            this.associatedHost = associatedHost;
            return this;
        }

        public final Collection<String> getDatabases() {
            if (this.databases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.databases;
        }

        public final void setDatabases(Collection<String> databases) {
            this.databases = DatabaseIdListCopier.copy(databases);
        }

        @Override
        public final Builder databases(Collection<String> databases) {
            this.databases = DatabaseIdListCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(String ... databases) {
            this.databases(Arrays.asList(databases));
            return this;
        }

        @Deprecated
        public final List<Host.Builder> getHosts() {
            List<Host.Builder> result = HostListCopier.copyToBuilder(this.hosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setHosts(Collection<Host.BuilderImpl> hosts) {
            this.hosts = HostListCopier.copyFromBuilder(hosts);
        }

        @Override
        @Deprecated
        public final Builder hosts(Collection<Host> hosts) {
            this.hosts = HostListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder hosts(Host ... hosts) {
            this.hosts(Arrays.asList(hosts));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder hosts(Consumer<Host.Builder> ... hosts) {
            this.hosts(Stream.of(hosts).map(c -> (Host)((Host.Builder)Host.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final String getPrimaryHost() {
            return this.primaryHost;
        }

        @Deprecated
        public final void setPrimaryHost(String primaryHost) {
            this.primaryHost = primaryHost;
        }

        @Override
        @Deprecated
        public final Builder primaryHost(String primaryHost) {
            this.primaryHost = primaryHost;
            return this;
        }

        public final DatabaseConnection.Builder getDatabaseConnection() {
            return this.databaseConnection != null ? this.databaseConnection.toBuilder() : null;
        }

        public final void setDatabaseConnection(DatabaseConnection.BuilderImpl databaseConnection) {
            this.databaseConnection = databaseConnection != null ? databaseConnection.build() : null;
        }

        @Override
        public final Builder databaseConnection(DatabaseConnection databaseConnection) {
            this.databaseConnection = databaseConnection;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public Component build() {
            return new Component(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Component> {
        public Builder componentId(String var1);

        public Builder sid(String var1);

        public Builder systemNumber(String var1);

        public Builder parentComponent(String var1);

        public Builder childComponents(Collection<String> var1);

        public Builder childComponents(String ... var1);

        public Builder applicationId(String var1);

        public Builder componentType(String var1);

        public Builder componentType(ComponentType var1);

        public Builder status(String var1);

        public Builder status(ComponentStatus var1);

        public Builder sapHostname(String var1);

        public Builder sapFeature(String var1);

        public Builder sapKernelVersion(String var1);

        public Builder hdbVersion(String var1);

        public Builder resilience(Resilience var1);

        default public Builder resilience(Consumer<Resilience.Builder> resilience) {
            return this.resilience((Resilience)((Resilience.Builder)Resilience.builder().applyMutation(resilience)).build());
        }

        public Builder associatedHost(AssociatedHost var1);

        default public Builder associatedHost(Consumer<AssociatedHost.Builder> associatedHost) {
            return this.associatedHost((AssociatedHost)((AssociatedHost.Builder)AssociatedHost.builder().applyMutation(associatedHost)).build());
        }

        public Builder databases(Collection<String> var1);

        public Builder databases(String ... var1);

        @Deprecated
        public Builder hosts(Collection<Host> var1);

        @Deprecated
        public Builder hosts(Host ... var1);

        @Deprecated
        public Builder hosts(Consumer<Host.Builder> ... var1);

        @Deprecated
        public Builder primaryHost(String var1);

        public Builder databaseConnection(DatabaseConnection var1);

        default public Builder databaseConnection(Consumer<DatabaseConnection.Builder> databaseConnection) {
            return this.databaseConnection((DatabaseConnection)((DatabaseConnection.Builder)DatabaseConnection.builder().applyMutation(databaseConnection)).build());
        }

        public Builder lastUpdated(Instant var1);

        public Builder arn(String var1);
    }
}

