/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.HostRole;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Host
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Host> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostName").getter(Host.getter(Host::hostName)).setter(Host.setter(Builder::hostName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostName").build()}).build();
    private static final SdkField<String> HOST_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostIp").getter(Host.getter(Host::hostIp)).setter(Host.setter(Builder::hostIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIp").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EC2InstanceId").getter(Host.getter(Host::ec2InstanceId)).setter(Host.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(Host.getter(Host::instanceId)).setter(Host.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> HOST_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostRole").getter(Host.getter(Host::hostRoleAsString)).setter(Host.setter(Builder::hostRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRole").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OsVersion").getter(Host.getter(Host::osVersion)).setter(Host.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD, HOST_IP_FIELD, EC2_INSTANCE_ID_FIELD, INSTANCE_ID_FIELD, HOST_ROLE_FIELD, OS_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Host.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostName;
    private final String hostIp;
    private final String ec2InstanceId;
    private final String instanceId;
    private final String hostRole;
    private final String osVersion;

    private Host(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.hostIp = builder.hostIp;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.instanceId = builder.instanceId;
        this.hostRole = builder.hostRole;
        this.osVersion = builder.osVersion;
    }

    public final String hostName() {
        return this.hostName;
    }

    public final String hostIp() {
        return this.hostIp;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final HostRole hostRole() {
        return HostRole.fromValue(this.hostRole);
    }

    public final String hostRoleAsString() {
        return this.hostRole;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        return Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.hostIp(), other.hostIp()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.hostRoleAsString(), other.hostRoleAsString()) && Objects.equals(this.osVersion(), other.osVersion());
    }

    public final String toString() {
        return ToString.builder((String)"Host").add("HostName", (Object)this.hostName()).add("HostIp", (Object)this.hostIp()).add("EC2InstanceId", (Object)this.ec2InstanceId()).add("InstanceId", (Object)this.instanceId()).add("HostRole", (Object)this.hostRoleAsString()).add("OsVersion", (Object)this.osVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostName": {
                return Optional.ofNullable(clazz.cast(this.hostName()));
            }
            case "HostIp": {
                return Optional.ofNullable(clazz.cast(this.hostIp()));
            }
            case "EC2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "HostRole": {
                return Optional.ofNullable(clazz.cast(this.hostRoleAsString()));
            }
            case "OsVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("HostName", HOST_NAME_FIELD);
        map.put("HostIp", HOST_IP_FIELD);
        map.put("EC2InstanceId", EC2_INSTANCE_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("HostRole", HOST_ROLE_FIELD);
        map.put("OsVersion", OS_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostName;
        private String hostIp;
        private String ec2InstanceId;
        private String instanceId;
        private String hostRole;
        private String osVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            this.hostName(model.hostName);
            this.hostIp(model.hostIp);
            this.ec2InstanceId(model.ec2InstanceId);
            this.instanceId(model.instanceId);
            this.hostRole(model.hostRole);
            this.osVersion(model.osVersion);
        }

        public final String getHostName() {
            return this.hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getHostIp() {
            return this.hostIp;
        }

        public final void setHostIp(String hostIp) {
            this.hostIp = hostIp;
        }

        @Override
        public final Builder hostIp(String hostIp) {
            this.hostIp = hostIp;
            return this;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getHostRole() {
            return this.hostRole;
        }

        public final void setHostRole(String hostRole) {
            this.hostRole = hostRole;
        }

        @Override
        public final Builder hostRole(String hostRole) {
            this.hostRole = hostRole;
            return this;
        }

        @Override
        public final Builder hostRole(HostRole hostRole) {
            this.hostRole(hostRole == null ? null : hostRole.toString());
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Host build() {
            return new Host(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Host> {
        public Builder hostName(String var1);

        public Builder hostIp(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder instanceId(String var1);

        public Builder hostRole(String var1);

        public Builder hostRole(HostRole var1);

        public Builder osVersion(String var1);
    }
}

