/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListSubCheckResultsResponse;
import software.amazon.awssdk.services.ssmsap.model.SubCheckResult;

public class ListSubCheckResultsPublisher
implements SdkPublisher<ListSubCheckResultsResponse> {
    private final SsmSapAsyncClient client;
    private final ListSubCheckResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubCheckResultsPublisher(SsmSapAsyncClient client, ListSubCheckResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubCheckResultsPublisher(SsmSapAsyncClient client, ListSubCheckResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubCheckResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubCheckResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SubCheckResult> subCheckResults() {
        Function<ListSubCheckResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subCheckResults() != null) {
                return response.subCheckResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSubCheckResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubCheckResultsResponseFetcher
    implements AsyncPageFetcher<ListSubCheckResultsResponse> {
        private ListSubCheckResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubCheckResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubCheckResultsResponse> nextPage(ListSubCheckResultsResponse previousPage) {
            if (previousPage == null) {
                return ListSubCheckResultsPublisher.this.client.listSubCheckResults(ListSubCheckResultsPublisher.this.firstRequest);
            }
            return ListSubCheckResultsPublisher.this.client.listSubCheckResults((ListSubCheckResultsRequest)((Object)ListSubCheckResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

