/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing a list of <a>DescribeStorediSCSIVolumesInput$VolumeARNs</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorediScsiVolumesRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DescribeStorediScsiVolumesRequest.Builder, DescribeStorediScsiVolumesRequest> {
    private static final SdkField<List<String>> VOLUME_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VolumeARNs")
            .getter(getter(DescribeStorediScsiVolumesRequest::volumeARNs))
            .setter(setter(Builder::volumeARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_AR_NS_FIELD));

    private final List<String> volumeARNs;

    private DescribeStorediScsiVolumesRequest(BuilderImpl builder) {
        super(builder);
        this.volumeARNs = builder.volumeARNs;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeARNs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumeARNs() {
        return volumeARNs != null && !(volumeARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of the
     * specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeARNs} method.
     * </p>
     * 
     * @return An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All
     *         of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs
     *         for a gateway.
     */
    public final List<String> volumeARNs() {
        return volumeARNs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeARNs() ? volumeARNs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorediScsiVolumesRequest)) {
            return false;
        }
        DescribeStorediScsiVolumesRequest other = (DescribeStorediScsiVolumesRequest) obj;
        return hasVolumeARNs() == other.hasVolumeARNs() && Objects.equals(volumeARNs(), other.volumeARNs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStorediScsiVolumesRequest").add("VolumeARNs", hasVolumeARNs() ? volumeARNs() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARNs":
            return Optional.ofNullable(clazz.cast(volumeARNs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorediScsiVolumesRequest, T> g) {
        return obj -> g.apply((DescribeStorediScsiVolumesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStorediScsiVolumesRequest> {
        /**
         * <p>
         * An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of
         * the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a
         * gateway.
         * </p>
         * 
         * @param volumeARNs
         *        An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume.
         *        All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get
         *        volume ARNs for a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARNs(Collection<String> volumeARNs);

        /**
         * <p>
         * An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of
         * the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get volume ARNs for a
         * gateway.
         * </p>
         * 
         * @param volumeARNs
         *        An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume.
         *        All of the specified stored volumes must be from the same gateway. Use <a>ListVolumes</a> to get
         *        volume ARNs for a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARNs(String... volumeARNs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private List<String> volumeARNs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorediScsiVolumesRequest model) {
            super(model);
            volumeARNs(model.volumeARNs);
        }

        public final Collection<String> getVolumeARNs() {
            if (volumeARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return volumeARNs;
        }

        public final void setVolumeARNs(Collection<String> volumeARNs) {
            this.volumeARNs = VolumeARNsCopier.copy(volumeARNs);
        }

        @Override
        public final Builder volumeARNs(Collection<String> volumeARNs) {
            this.volumeARNs = VolumeARNsCopier.copy(volumeARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeARNs(String... volumeARNs) {
            volumeARNs(Arrays.asList(volumeARNs));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStorediScsiVolumesRequest build() {
            return new DescribeStorediScsiVolumesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
