/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTapePoolsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListTapePoolsResponse.Builder, ListTapePoolsResponse> {
    private static final SdkField<List<PoolInfo>> POOL_INFOS_FIELD = SdkField
            .<List<PoolInfo>> builder(MarshallingType.LIST)
            .memberName("PoolInfos")
            .getter(getter(ListTapePoolsResponse::poolInfos))
            .setter(setter(Builder::poolInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PoolInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(PoolInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListTapePoolsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(POOL_INFOS_FIELD, MARKER_FIELD));

    private final List<PoolInfo> poolInfos;

    private final String marker;

    private ListTapePoolsResponse(BuilderImpl builder) {
        super(builder);
        this.poolInfos = builder.poolInfos;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the PoolInfos property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPoolInfos() {
        return poolInfos != null && !(poolInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there are no
     * custom tape pools, the <code>PoolInfos</code> is an empty array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPoolInfos} method.
     * </p>
     * 
     * @return An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If
     *         there are no custom tape pools, the <code>PoolInfos</code> is an empty array.
     */
    public final List<PoolInfo> poolInfos() {
        return poolInfos;
    }

    /**
     * <p>
     * A string that indicates the position at which to begin the returned list of tape pools. Use the marker in your
     * next request to continue pagination of tape pools. If there are no more tape pools to list, this element does not
     * appear in the response body.
     * </p>
     * 
     * @return A string that indicates the position at which to begin the returned list of tape pools. Use the marker in
     *         your next request to continue pagination of tape pools. If there are no more tape pools to list, this
     *         element does not appear in the response body.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPoolInfos() ? poolInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTapePoolsResponse)) {
            return false;
        }
        ListTapePoolsResponse other = (ListTapePoolsResponse) obj;
        return hasPoolInfos() == other.hasPoolInfos() && Objects.equals(poolInfos(), other.poolInfos())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTapePoolsResponse").add("PoolInfos", hasPoolInfos() ? poolInfos() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolInfos":
            return Optional.ofNullable(clazz.cast(poolInfos()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTapePoolsResponse, T> g) {
        return obj -> g.apply((ListTapePoolsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTapePoolsResponse> {
        /**
         * <p>
         * An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there
         * are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * </p>
         * 
         * @param poolInfos
         *        An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If
         *        there are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolInfos(Collection<PoolInfo> poolInfos);

        /**
         * <p>
         * An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there
         * are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * </p>
         * 
         * @param poolInfos
         *        An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If
         *        there are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolInfos(PoolInfo... poolInfos);

        /**
         * <p>
         * An array of <code>PoolInfo</code> objects, where each object describes a single custom tape pool. If there
         * are no custom tape pools, the <code>PoolInfos</code> is an empty array.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.PoolInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.storagegateway.model.PoolInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.PoolInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #poolInfos(List<PoolInfo>)}.
         * 
         * @param poolInfos
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.PoolInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #poolInfos(java.util.Collection<PoolInfo>)
         */
        Builder poolInfos(Consumer<PoolInfo.Builder>... poolInfos);

        /**
         * <p>
         * A string that indicates the position at which to begin the returned list of tape pools. Use the marker in
         * your next request to continue pagination of tape pools. If there are no more tape pools to list, this element
         * does not appear in the response body.
         * </p>
         * 
         * @param marker
         *        A string that indicates the position at which to begin the returned list of tape pools. Use the marker
         *        in your next request to continue pagination of tape pools. If there are no more tape pools to list,
         *        this element does not appear in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<PoolInfo> poolInfos = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTapePoolsResponse model) {
            super(model);
            poolInfos(model.poolInfos);
            marker(model.marker);
        }

        public final List<PoolInfo.Builder> getPoolInfos() {
            List<PoolInfo.Builder> result = PoolInfosCopier.copyToBuilder(this.poolInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPoolInfos(Collection<PoolInfo.BuilderImpl> poolInfos) {
            this.poolInfos = PoolInfosCopier.copyFromBuilder(poolInfos);
        }

        @Override
        public final Builder poolInfos(Collection<PoolInfo> poolInfos) {
            this.poolInfos = PoolInfosCopier.copy(poolInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolInfos(PoolInfo... poolInfos) {
            poolInfos(Arrays.asList(poolInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolInfos(Consumer<PoolInfo.Builder>... poolInfos) {
            poolInfos(Stream.of(poolInfos).map(c -> PoolInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListTapePoolsResponse build() {
            return new ListTapePoolsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
