/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * RefreshCacheInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshCacheRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<RefreshCacheRequest.Builder, RefreshCacheRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(RefreshCacheRequest::fileShareARN)).setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<List<String>> FOLDER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FolderList")
            .getter(getter(RefreshCacheRequest::folderList))
            .setter(setter(Builder::folderList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Recursive").getter(getter(RefreshCacheRequest::recursive)).setter(setter(Builder::recursive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recursive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD,
            FOLDER_LIST_FIELD, RECURSIVE_FIELD));

    private final String fileShareARN;

    private final List<String> folderList;

    private final Boolean recursive;

    private RefreshCacheRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.folderList = builder.folderList;
        this.recursive = builder.recursive;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file share you want to refresh.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file share you want to refresh.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the FolderList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFolderList() {
        return folderList != null && !(folderList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A comma-separated list of the paths of folders to refresh in the cache. The default is [<code>"/"</code>]. The
     * default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is set to
     * <code>true</code>, the entire S3 bucket that the file share has access to is refreshed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolderList} method.
     * </p>
     * 
     * @return A comma-separated list of the paths of folders to refresh in the cache. The default is [<code>"/"</code>
     *         ]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If
     *         <code>Recursive</code> is set to <code>true</code>, the entire S3 bucket that the file share has access
     *         to is refreshed.
     */
    public final List<String> folderList() {
        return folderList;
    }

    /**
     * <p>
     * A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders that
     * were in the cache the last time the gateway listed the folder's contents. If this value set to <code>true</code>,
     * each folder that is listed in <code>FolderList</code> is recursively updated. Otherwise, subfolders listed in
     * <code>FolderList</code> are not refreshed. Only objects that are in folders listed directly under
     * <code>FolderList</code> are found and used for the update. The default is <code>true</code>.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders
     *         that were in the cache the last time the gateway listed the folder's contents. If this value set to
     *         <code>true</code>, each folder that is listed in <code>FolderList</code> is recursively updated.
     *         Otherwise, subfolders listed in <code>FolderList</code> are not refreshed. Only objects that are in
     *         folders listed directly under <code>FolderList</code> are found and used for the update. The default is
     *         <code>true</code>.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean recursive() {
        return recursive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasFolderList() ? folderList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recursive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshCacheRequest)) {
            return false;
        }
        RefreshCacheRequest other = (RefreshCacheRequest) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN()) && hasFolderList() == other.hasFolderList()
                && Objects.equals(folderList(), other.folderList()) && Objects.equals(recursive(), other.recursive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshCacheRequest").add("FileShareARN", fileShareARN())
                .add("FolderList", hasFolderList() ? folderList() : null).add("Recursive", recursive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "FolderList":
            return Optional.ofNullable(clazz.cast(folderList()));
        case "Recursive":
            return Optional.ofNullable(clazz.cast(recursive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshCacheRequest, T> g) {
        return obj -> g.apply((RefreshCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, RefreshCacheRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file share you want to refresh.
         * </p>
         * 
         * @param fileShareARN
         *        The Amazon Resource Name (ARN) of the file share you want to refresh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * <p>
         * A comma-separated list of the paths of folders to refresh in the cache. The default is [<code>"/"</code>].
         * The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is
         * set to <code>true</code>, the entire S3 bucket that the file share has access to is refreshed.
         * </p>
         * 
         * @param folderList
         *        A comma-separated list of the paths of folders to refresh in the cache. The default is [
         *        <code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If
         *        <code>Recursive</code> is set to <code>true</code>, the entire S3 bucket that the file share has
         *        access to is refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderList(Collection<String> folderList);

        /**
         * <p>
         * A comma-separated list of the paths of folders to refresh in the cache. The default is [<code>"/"</code>].
         * The default refreshes objects and folders at the root of the Amazon S3 bucket. If <code>Recursive</code> is
         * set to <code>true</code>, the entire S3 bucket that the file share has access to is refreshed.
         * </p>
         * 
         * @param folderList
         *        A comma-separated list of the paths of folders to refresh in the cache. The default is [
         *        <code>"/"</code>]. The default refreshes objects and folders at the root of the Amazon S3 bucket. If
         *        <code>Recursive</code> is set to <code>true</code>, the entire S3 bucket that the file share has
         *        access to is refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderList(String... folderList);

        /**
         * <p>
         * A value that specifies whether to recursively refresh folders in the cache. The refresh includes folders that
         * were in the cache the last time the gateway listed the folder's contents. If this value set to
         * <code>true</code>, each folder that is listed in <code>FolderList</code> is recursively updated. Otherwise,
         * subfolders listed in <code>FolderList</code> are not refreshed. Only objects that are in folders listed
         * directly under <code>FolderList</code> are found and used for the update. The default is <code>true</code>.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param recursive
         *        A value that specifies whether to recursively refresh folders in the cache. The refresh includes
         *        folders that were in the cache the last time the gateway listed the folder's contents. If this value
         *        set to <code>true</code>, each folder that is listed in <code>FolderList</code> is recursively
         *        updated. Otherwise, subfolders listed in <code>FolderList</code> are not refreshed. Only objects that
         *        are in folders listed directly under <code>FolderList</code> are found and used for the update. The
         *        default is <code>true</code>.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursive(Boolean recursive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileShareARN;

        private List<String> folderList = DefaultSdkAutoConstructList.getInstance();

        private Boolean recursive;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshCacheRequest model) {
            super(model);
            fileShareARN(model.fileShareARN);
            folderList(model.folderList);
            recursive(model.recursive);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final Collection<String> getFolderList() {
            if (folderList instanceof SdkAutoConstructList) {
                return null;
            }
            return folderList;
        }

        public final void setFolderList(Collection<String> folderList) {
            this.folderList = FolderListCopier.copy(folderList);
        }

        @Override
        public final Builder folderList(Collection<String> folderList) {
            this.folderList = FolderListCopier.copy(folderList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderList(String... folderList) {
            folderList(Arrays.asList(folderList));
            return this;
        }

        public final Boolean getRecursive() {
            return recursive;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RefreshCacheRequest build() {
            return new RefreshCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
