/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStorediScsiVolumeRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, CreateStorediScsiVolumeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::gatewayARN)).setter(CreateStorediScsiVolumeRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> DISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskId").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::diskId)).setter(CreateStorediScsiVolumeRequest.setter(Builder::diskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::snapshotId)).setter(CreateStorediScsiVolumeRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<Boolean> PRESERVE_EXISTING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PreserveExistingData").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::preserveExistingData)).setter(CreateStorediScsiVolumeRequest.setter(Builder::preserveExistingData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveExistingData").build()}).build();
    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetName").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::targetName)).setter(CreateStorediScsiVolumeRequest.setter(Builder::targetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetName").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::networkInterfaceId)).setter(CreateStorediScsiVolumeRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KMSEncrypted").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::kmsEncrypted)).setter(CreateStorediScsiVolumeRequest.setter(Builder::kmsEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKey").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::kmsKey)).setter(CreateStorediScsiVolumeRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateStorediScsiVolumeRequest.getter(CreateStorediScsiVolumeRequest::tags)).setter(CreateStorediScsiVolumeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DISK_ID_FIELD, SNAPSHOT_ID_FIELD, PRESERVE_EXISTING_DATA_FIELD, TARGET_NAME_FIELD, NETWORK_INTERFACE_ID_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, TAGS_FIELD));
    private final String gatewayARN;
    private final String diskId;
    private final String snapshotId;
    private final Boolean preserveExistingData;
    private final String targetName;
    private final String networkInterfaceId;
    private final Boolean kmsEncrypted;
    private final String kmsKey;
    private final List<Tag> tags;

    private CreateStorediScsiVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskId = builder.diskId;
        this.snapshotId = builder.snapshotId;
        this.preserveExistingData = builder.preserveExistingData;
        this.targetName = builder.targetName;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.tags = builder.tags;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String diskId() {
        return this.diskId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Boolean preserveExistingData() {
        return this.preserveExistingData;
    }

    public final String targetName() {
        return this.targetName;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final Boolean kmsEncrypted() {
        return this.kmsEncrypted;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveExistingData());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorediScsiVolumeRequest)) {
            return false;
        }
        CreateStorediScsiVolumeRequest other = (CreateStorediScsiVolumeRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.diskId(), other.diskId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.preserveExistingData(), other.preserveExistingData()) && Objects.equals(this.targetName(), other.targetName()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(this.kmsKey(), other.kmsKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStorediScsiVolumeRequest").add("GatewayARN", (Object)this.gatewayARN()).add("DiskId", (Object)this.diskId()).add("SnapshotId", (Object)this.snapshotId()).add("PreserveExistingData", (Object)this.preserveExistingData()).add("TargetName", (Object)this.targetName()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("KMSEncrypted", (Object)this.kmsEncrypted()).add("KMSKey", (Object)this.kmsKey()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "DiskId": {
                return Optional.ofNullable(clazz.cast(this.diskId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "PreserveExistingData": {
                return Optional.ofNullable(clazz.cast(this.preserveExistingData()));
            }
            case "TargetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "KMSEncrypted": {
                return Optional.ofNullable(clazz.cast(this.kmsEncrypted()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStorediScsiVolumeRequest, T> g) {
        return obj -> g.apply((CreateStorediScsiVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String diskId;
        private String snapshotId;
        private Boolean preserveExistingData;
        private String targetName;
        private String networkInterfaceId;
        private Boolean kmsEncrypted;
        private String kmsKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorediScsiVolumeRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.diskId(model.diskId);
            this.snapshotId(model.snapshotId);
            this.preserveExistingData(model.preserveExistingData);
            this.targetName(model.targetName);
            this.networkInterfaceId(model.networkInterfaceId);
            this.kmsEncrypted(model.kmsEncrypted);
            this.kmsKey(model.kmsKey);
            this.tags(model.tags);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getDiskId() {
            return this.diskId;
        }

        public final void setDiskId(String diskId) {
            this.diskId = diskId;
        }

        @Override
        public final Builder diskId(String diskId) {
            this.diskId = diskId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Boolean getPreserveExistingData() {
            return this.preserveExistingData;
        }

        public final void setPreserveExistingData(Boolean preserveExistingData) {
            this.preserveExistingData = preserveExistingData;
        }

        @Override
        public final Builder preserveExistingData(Boolean preserveExistingData) {
            this.preserveExistingData = preserveExistingData;
            return this;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Boolean getKmsEncrypted() {
            return this.kmsEncrypted;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStorediScsiVolumeRequest build() {
            return new CreateStorediScsiVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStorediScsiVolumeRequest> {
        public Builder gatewayARN(String var1);

        public Builder diskId(String var1);

        public Builder snapshotId(String var1);

        public Builder preserveExistingData(Boolean var1);

        public Builder targetName(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder kmsEncrypted(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

