/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.StorageGatewayServiceClientConfiguration;
import software.amazon.awssdk.services.storagegateway.internal.StorageGatewayServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.storagegateway.model.ActivateGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.ActivateGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.AddCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.AddCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.AddUploadBufferRequest;
import software.amazon.awssdk.services.storagegateway.model.AddUploadBufferResponse;
import software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageRequest;
import software.amazon.awssdk.services.storagegateway.model.AddWorkingStorageResponse;
import software.amazon.awssdk.services.storagegateway.model.AssignTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.AssignTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemRequest;
import software.amazon.awssdk.services.storagegateway.model.AssociateFileSystemResponse;
import software.amazon.awssdk.services.storagegateway.model.AttachVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.AttachVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CancelArchivalRequest;
import software.amazon.awssdk.services.storagegateway.model.CancelArchivalResponse;
import software.amazon.awssdk.services.storagegateway.model.CancelCacheReportRequest;
import software.amazon.awssdk.services.storagegateway.model.CancelCacheReportResponse;
import software.amazon.awssdk.services.storagegateway.model.CancelRetrievalRequest;
import software.amazon.awssdk.services.storagegateway.model.CancelRetrievalResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateCachediScsiVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateNfsFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSmbFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateStorediScsiVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapeWithBarcodeRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapeWithBarcodeResponse;
import software.amazon.awssdk.services.storagegateway.model.CreateTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.CreateTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteAutomaticTapeCreationPolicyResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteCacheReportRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteCacheReportResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeArchiveResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapePoolResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteTapeResponse;
import software.amazon.awssdk.services.storagegateway.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeAvailabilityMonitorTestResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeCacheReportRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeCacheReportResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeCachediScsiVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeFileSystemAssociationsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeGatewayInformationResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeNfsFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSmbSettingsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeStorediScsiVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeUploadBufferResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse;
import software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeWorkingStorageResponse;
import software.amazon.awssdk.services.storagegateway.model.DetachVolumeRequest;
import software.amazon.awssdk.services.storagegateway.model.DetachVolumeResponse;
import software.amazon.awssdk.services.storagegateway.model.DisableGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.DisableGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemRequest;
import software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemResponse;
import software.amazon.awssdk.services.storagegateway.model.EvictFilesFailingUploadRequest;
import software.amazon.awssdk.services.storagegateway.model.EvictFilesFailingUploadResponse;
import software.amazon.awssdk.services.storagegateway.model.InternalServerErrorException;
import software.amazon.awssdk.services.storagegateway.model.InvalidGatewayRequestException;
import software.amazon.awssdk.services.storagegateway.model.JoinDomainRequest;
import software.amazon.awssdk.services.storagegateway.model.JoinDomainResponse;
import software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListAutomaticTapeCreationPoliciesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListCacheReportsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListCacheReportsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSharesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse;
import software.amazon.awssdk.services.storagegateway.model.ListLocalDisksRequest;
import software.amazon.awssdk.services.storagegateway.model.ListLocalDisksResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapePoolsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeInitiatorsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumeRecoveryPointsResponse;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedRequest;
import software.amazon.awssdk.services.storagegateway.model.NotifyWhenUploadedResponse;
import software.amazon.awssdk.services.storagegateway.model.RefreshCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.RefreshCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.storagegateway.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.storagegateway.model.ResetCacheRequest;
import software.amazon.awssdk.services.storagegateway.model.ResetCacheResponse;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveRequest;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeArchiveResponse;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointRequest;
import software.amazon.awssdk.services.storagegateway.model.RetrieveTapeRecoveryPointResponse;
import software.amazon.awssdk.services.storagegateway.model.ServiceUnavailableErrorException;
import software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordRequest;
import software.amazon.awssdk.services.storagegateway.model.SetLocalConsolePasswordResponse;
import software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordRequest;
import software.amazon.awssdk.services.storagegateway.model.SetSmbGuestPasswordResponse;
import software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.ShutdownGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestRequest;
import software.amazon.awssdk.services.storagegateway.model.StartAvailabilityMonitorTestResponse;
import software.amazon.awssdk.services.storagegateway.model.StartCacheReportRequest;
import software.amazon.awssdk.services.storagegateway.model.StartCacheReportResponse;
import software.amazon.awssdk.services.storagegateway.model.StartGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.StartGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayException;
import software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateAutomaticTapeCreationPolicyResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateChapCredentialsResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateFileSystemAssociationResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewayInformationResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateGatewaySoftwareNowResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateNfsFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbFileShareVisibilityResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbLocalGroupsResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSmbSecurityStrategyResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateSnapshotScheduleResponse;
import software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeRequest;
import software.amazon.awssdk.services.storagegateway.model.UpdateVtlDeviceTypeResponse;
import software.amazon.awssdk.services.storagegateway.transform.ActivateGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AddCacheRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AddUploadBufferRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AddWorkingStorageRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AssignTapePoolRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AssociateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.AttachVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CancelArchivalRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CancelCacheReportRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CancelRetrievalRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateCachediScsiVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateNfsFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateSmbFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateSnapshotFromVolumeRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateStorediScsiVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateTapePoolRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateTapeWithBarcodeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.CreateTapesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteAutomaticTapeCreationPolicyRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteBandwidthRateLimitRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteCacheReportRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteChapCredentialsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteTapeArchiveRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteTapePoolRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteTapeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeAvailabilityMonitorTestRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeBandwidthRateLimitRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeBandwidthRateLimitScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeCacheReportRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeCacheRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeCachediScsiVolumesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeChapCredentialsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeFileSystemAssociationsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeGatewayInformationRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeMaintenanceStartTimeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeNfsFileSharesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeSmbFileSharesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeSmbSettingsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeStorediScsiVolumesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeTapeArchivesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeTapeRecoveryPointsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeTapesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeUploadBufferRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeVtlDevicesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DescribeWorkingStorageRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DetachVolumeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DisableGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.DisassociateFileSystemRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.EvictFilesFailingUploadRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.JoinDomainRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListAutomaticTapeCreationPoliciesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListCacheReportsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListFileSharesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListFileSystemAssociationsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListLocalDisksRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListTapePoolsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListTapesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListVolumeInitiatorsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListVolumeRecoveryPointsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ListVolumesRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.NotifyWhenUploadedRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.RefreshCacheRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ResetCacheRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.RetrieveTapeArchiveRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.RetrieveTapeRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.SetLocalConsolePasswordRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.SetSmbGuestPasswordRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.ShutdownGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.StartAvailabilityMonitorTestRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.StartCacheReportRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.StartGatewayRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateAutomaticTapeCreationPolicyRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateBandwidthRateLimitRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateBandwidthRateLimitScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateChapCredentialsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateFileSystemAssociationRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateGatewayInformationRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateGatewaySoftwareNowRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateMaintenanceStartTimeRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateNfsFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSmbFileShareRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSmbFileShareVisibilityRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSmbLocalGroupsRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSmbSecurityStrategyRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.storagegateway.transform.UpdateVtlDeviceTypeRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultStorageGatewayAsyncClient
implements StorageGatewayAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultStorageGatewayAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultStorageGatewayAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Storage_Gateway#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<ActivateGatewayResponse> activateGateway(ActivateGatewayRequest activateGatewayRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)activateGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, activateGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ActivateGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ActivateGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ActivateGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ActivateGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)activateGatewayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$activateGateway$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$activateGateway$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddCacheResponse> addCache(AddCacheRequest addCacheRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, addCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$addCache$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$addCache$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsToResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addTagsToResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$addTagsToResource$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$addTagsToResource$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddUploadBufferResponse> addUploadBuffer(AddUploadBufferRequest addUploadBufferRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addUploadBufferRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, addUploadBufferRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddUploadBuffer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddUploadBufferResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddUploadBuffer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddUploadBufferRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addUploadBufferRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$addUploadBuffer$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$addUploadBuffer$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddWorkingStorageResponse> addWorkingStorage(AddWorkingStorageRequest addWorkingStorageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addWorkingStorageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, addWorkingStorageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddWorkingStorage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddWorkingStorageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddWorkingStorage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddWorkingStorageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addWorkingStorageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$addWorkingStorage$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$addWorkingStorage$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssignTapePoolResponse> assignTapePool(AssignTapePoolRequest assignTapePoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)assignTapePoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, assignTapePoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssignTapePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssignTapePoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssignTapePool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssignTapePoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)assignTapePoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$assignTapePool$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$assignTapePool$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssociateFileSystemResponse> associateFileSystem(AssociateFileSystemRequest associateFileSystemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, associateFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateFileSystem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateFileSystemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateFileSystemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$associateFileSystem$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$associateFileSystem$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachVolumeResponse> attachVolume(AttachVolumeRequest attachVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)attachVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, attachVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AttachVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$attachVolume$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$attachVolume$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelArchivalResponse> cancelArchival(CancelArchivalRequest cancelArchivalRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelArchivalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, cancelArchivalRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelArchival");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelArchivalResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelArchival").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelArchivalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelArchivalRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$cancelArchival$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$cancelArchival$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelCacheReportResponse> cancelCacheReport(CancelCacheReportRequest cancelCacheReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelCacheReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, cancelCacheReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelCacheReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelCacheReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelCacheReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelCacheReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelCacheReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$cancelCacheReport$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$cancelCacheReport$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelRetrievalResponse> cancelRetrieval(CancelRetrievalRequest cancelRetrievalRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelRetrievalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, cancelRetrievalRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelRetrieval");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelRetrievalResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelRetrieval").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelRetrievalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelRetrievalRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$cancelRetrieval$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$cancelRetrieval$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCachediScsiVolumeResponse> createCachediSCSIVolume(CreateCachediScsiVolumeRequest createCachediScsiVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCachediScsiVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createCachediScsiVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCachediSCSIVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCachediScsiVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCachediSCSIVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCachediScsiVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCachediScsiVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createCachediSCSIVolume$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createCachediSCSIVolume$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateNfsFileShareResponse> createNFSFileShare(CreateNfsFileShareRequest createNfsFileShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNfsFileShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createNfsFileShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNFSFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNfsFileShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNFSFileShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateNfsFileShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createNfsFileShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createNFSFileShare$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createNFSFileShare$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSmbFileShareResponse> createSMBFileShare(CreateSmbFileShareRequest createSmbFileShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSmbFileShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createSmbFileShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSMBFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSmbFileShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSMBFileShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSmbFileShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSmbFileShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createSMBFileShare$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createSMBFileShare$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createSnapshot$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createSnapshot$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSnapshotFromVolumeRecoveryPointResponse> createSnapshotFromVolumeRecoveryPoint(CreateSnapshotFromVolumeRecoveryPointRequest createSnapshotFromVolumeRecoveryPointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSnapshotFromVolumeRecoveryPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createSnapshotFromVolumeRecoveryPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSnapshotFromVolumeRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSnapshotFromVolumeRecoveryPointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSnapshotFromVolumeRecoveryPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSnapshotFromVolumeRecoveryPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSnapshotFromVolumeRecoveryPointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createSnapshotFromVolumeRecoveryPoint$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createSnapshotFromVolumeRecoveryPoint$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStorediScsiVolumeResponse> createStorediSCSIVolume(CreateStorediScsiVolumeRequest createStorediScsiVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStorediScsiVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createStorediScsiVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStorediSCSIVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStorediScsiVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStorediSCSIVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateStorediScsiVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStorediScsiVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createStorediSCSIVolume$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createStorediSCSIVolume$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTapePoolResponse> createTapePool(CreateTapePoolRequest createTapePoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTapePoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createTapePoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTapePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTapePoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTapePool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTapePoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTapePoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createTapePool$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createTapePool$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTapeWithBarcodeResponse> createTapeWithBarcode(CreateTapeWithBarcodeRequest createTapeWithBarcodeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTapeWithBarcodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createTapeWithBarcodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTapeWithBarcode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTapeWithBarcodeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTapeWithBarcode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTapeWithBarcodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTapeWithBarcodeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createTapeWithBarcode$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createTapeWithBarcode$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTapesResponse> createTapes(CreateTapesRequest createTapesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTapesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, createTapesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTapes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTapesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTapes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTapesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTapesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$createTapes$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$createTapes$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAutomaticTapeCreationPolicyResponse> deleteAutomaticTapeCreationPolicy(DeleteAutomaticTapeCreationPolicyRequest deleteAutomaticTapeCreationPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAutomaticTapeCreationPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAutomaticTapeCreationPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAutomaticTapeCreationPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAutomaticTapeCreationPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutomaticTapeCreationPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAutomaticTapeCreationPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAutomaticTapeCreationPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteAutomaticTapeCreationPolicy$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteAutomaticTapeCreationPolicy$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBandwidthRateLimitResponse> deleteBandwidthRateLimit(DeleteBandwidthRateLimitRequest deleteBandwidthRateLimitRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBandwidthRateLimitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBandwidthRateLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBandwidthRateLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBandwidthRateLimitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBandwidthRateLimit").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBandwidthRateLimitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBandwidthRateLimitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteBandwidthRateLimit$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteBandwidthRateLimit$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCacheReportResponse> deleteCacheReport(DeleteCacheReportRequest deleteCacheReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCacheReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCacheReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCacheReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCacheReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCacheReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCacheReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCacheReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteCacheReport$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteCacheReport$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteChapCredentialsResponse> deleteChapCredentials(DeleteChapCredentialsRequest deleteChapCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChapCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteChapCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChapCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChapCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChapCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteChapCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteChapCredentialsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteChapCredentials$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteChapCredentials$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFileShareResponse> deleteFileShare(DeleteFileShareRequest deleteFileShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFileShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteFileShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFileShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFileShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFileShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFileShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteFileShare$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteFileShare$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteGatewayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteGateway$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteGateway$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSnapshotScheduleResponse> deleteSnapshotSchedule(DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSnapshotScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSnapshotScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSnapshotSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSnapshotScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSnapshotSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSnapshotScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSnapshotScheduleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteSnapshotSchedule$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteSnapshotSchedule$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTapeResponse> deleteTape(DeleteTapeRequest deleteTapeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTapeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTapeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTape");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTapeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTape").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTapeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTapeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteTape$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteTape$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTapeArchiveResponse> deleteTapeArchive(DeleteTapeArchiveRequest deleteTapeArchiveRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTapeArchiveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTapeArchiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTapeArchive");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTapeArchiveResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTapeArchive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTapeArchiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTapeArchiveRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteTapeArchive$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteTapeArchive$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTapePoolResponse> deleteTapePool(DeleteTapePoolRequest deleteTapePoolRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTapePoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTapePoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTapePool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTapePoolResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTapePool").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTapePoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTapePoolRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteTapePool$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteTapePool$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteVolumeResponse> deleteVolume(DeleteVolumeRequest deleteVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, deleteVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$deleteVolume$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$deleteVolume$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAvailabilityMonitorTestResponse> describeAvailabilityMonitorTest(DescribeAvailabilityMonitorTestRequest describeAvailabilityMonitorTestRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAvailabilityMonitorTestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeAvailabilityMonitorTestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAvailabilityMonitorTest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAvailabilityMonitorTestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAvailabilityMonitorTest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeAvailabilityMonitorTestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAvailabilityMonitorTestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeAvailabilityMonitorTest$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeAvailabilityMonitorTest$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBandwidthRateLimitResponse> describeBandwidthRateLimit(DescribeBandwidthRateLimitRequest describeBandwidthRateLimitRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBandwidthRateLimitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeBandwidthRateLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBandwidthRateLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBandwidthRateLimitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBandwidthRateLimit").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeBandwidthRateLimitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeBandwidthRateLimitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeBandwidthRateLimit$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeBandwidthRateLimit$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBandwidthRateLimitScheduleResponse> describeBandwidthRateLimitSchedule(DescribeBandwidthRateLimitScheduleRequest describeBandwidthRateLimitScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBandwidthRateLimitScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeBandwidthRateLimitScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBandwidthRateLimitSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBandwidthRateLimitScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBandwidthRateLimitSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeBandwidthRateLimitScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeBandwidthRateLimitScheduleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeBandwidthRateLimitSchedule$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeBandwidthRateLimitSchedule$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCacheResponse> describeCache(DescribeCacheRequest describeCacheRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeCache$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeCache$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCacheReportResponse> describeCacheReport(DescribeCacheReportRequest describeCacheReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCacheReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeCacheReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCacheReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCacheReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCacheReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCacheReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCacheReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeCacheReport$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeCacheReport$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCachediScsiVolumesResponse> describeCachediSCSIVolumes(DescribeCachediScsiVolumesRequest describeCachediScsiVolumesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCachediScsiVolumesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeCachediScsiVolumesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCachediSCSIVolumes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCachediScsiVolumesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCachediSCSIVolumes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCachediScsiVolumesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCachediScsiVolumesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeCachediSCSIVolumes$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeCachediSCSIVolumes$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeChapCredentialsResponse> describeChapCredentials(DescribeChapCredentialsRequest describeChapCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeChapCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeChapCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeChapCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeChapCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeChapCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeChapCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeChapCredentialsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeChapCredentials$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeChapCredentials$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFileSystemAssociationsResponse> describeFileSystemAssociations(DescribeFileSystemAssociationsRequest describeFileSystemAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFileSystemAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeFileSystemAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFileSystemAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFileSystemAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFileSystemAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFileSystemAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFileSystemAssociationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeFileSystemAssociations$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeFileSystemAssociations$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeGatewayInformationResponse> describeGatewayInformation(DescribeGatewayInformationRequest describeGatewayInformationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGatewayInformationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeGatewayInformationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGatewayInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGatewayInformationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGatewayInformation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeGatewayInformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeGatewayInformationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeGatewayInformation$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeGatewayInformation$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMaintenanceStartTimeResponse> describeMaintenanceStartTime(DescribeMaintenanceStartTimeRequest describeMaintenanceStartTimeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMaintenanceStartTimeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeMaintenanceStartTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMaintenanceStartTime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMaintenanceStartTimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMaintenanceStartTime").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMaintenanceStartTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMaintenanceStartTimeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeMaintenanceStartTime$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeMaintenanceStartTime$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNfsFileSharesResponse> describeNFSFileShares(DescribeNfsFileSharesRequest describeNfsFileSharesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNfsFileSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeNfsFileSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNFSFileShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNfsFileSharesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNFSFileShares").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeNfsFileSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeNfsFileSharesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeNFSFileShares$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeNFSFileShares$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSmbFileSharesResponse> describeSMBFileShares(DescribeSmbFileSharesRequest describeSmbFileSharesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSmbFileSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeSmbFileSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSMBFileShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSmbFileSharesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSMBFileShares").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSmbFileSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSmbFileSharesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeSMBFileShares$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeSMBFileShares$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSmbSettingsResponse> describeSMBSettings(DescribeSmbSettingsRequest describeSmbSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSmbSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeSmbSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSMBSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSmbSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSMBSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSmbSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSmbSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeSMBSettings$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeSMBSettings$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSnapshotScheduleResponse> describeSnapshotSchedule(DescribeSnapshotScheduleRequest describeSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSnapshotScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeSnapshotScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSnapshotSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSnapshotScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSnapshotSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSnapshotScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSnapshotScheduleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeSnapshotSchedule$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeSnapshotSchedule$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStorediScsiVolumesResponse> describeStorediSCSIVolumes(DescribeStorediScsiVolumesRequest describeStorediScsiVolumesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStorediScsiVolumesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeStorediScsiVolumesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStorediSCSIVolumes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStorediScsiVolumesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStorediSCSIVolumes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeStorediScsiVolumesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeStorediScsiVolumesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeStorediSCSIVolumes$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeStorediSCSIVolumes$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTapeArchivesResponse> describeTapeArchives(DescribeTapeArchivesRequest describeTapeArchivesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTapeArchivesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeTapeArchivesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTapeArchives");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTapeArchivesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTapeArchives").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTapeArchivesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTapeArchivesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeTapeArchives$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeTapeArchives$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTapeRecoveryPointsResponse> describeTapeRecoveryPoints(DescribeTapeRecoveryPointsRequest describeTapeRecoveryPointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTapeRecoveryPointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeTapeRecoveryPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTapeRecoveryPoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTapeRecoveryPointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTapeRecoveryPoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTapeRecoveryPointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTapeRecoveryPointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeTapeRecoveryPoints$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeTapeRecoveryPoints$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTapesResponse> describeTapes(DescribeTapesRequest describeTapesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTapesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeTapesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTapes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTapesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTapes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTapesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTapesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeTapes$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeTapes$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeUploadBufferResponse> describeUploadBuffer(DescribeUploadBufferRequest describeUploadBufferRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeUploadBufferRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeUploadBufferRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUploadBuffer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUploadBufferResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUploadBuffer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeUploadBufferRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeUploadBufferRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeUploadBuffer$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeUploadBuffer$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeVtlDevicesResponse> describeVTLDevices(DescribeVtlDevicesRequest describeVtlDevicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeVtlDevicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeVtlDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVTLDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVtlDevicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVTLDevices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeVtlDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeVtlDevicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeVTLDevices$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeVTLDevices$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeWorkingStorageResponse> describeWorkingStorage(DescribeWorkingStorageRequest describeWorkingStorageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeWorkingStorageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, describeWorkingStorageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeWorkingStorage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWorkingStorageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWorkingStorage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeWorkingStorageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeWorkingStorageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$describeWorkingStorage$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$describeWorkingStorage$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachVolumeResponse> detachVolume(DetachVolumeRequest detachVolumeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detachVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, detachVolumeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachVolume");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachVolumeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachVolume").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DetachVolumeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachVolumeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$detachVolume$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$detachVolume$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableGatewayResponse> disableGateway(DisableGatewayRequest disableGatewayRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, disableGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableGatewayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$disableGateway$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$disableGateway$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateFileSystemResponse> disassociateFileSystem(DisassociateFileSystemRequest disassociateFileSystemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateFileSystemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateFileSystemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateFileSystem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateFileSystemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateFileSystem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateFileSystemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateFileSystemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$disassociateFileSystem$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$disassociateFileSystem$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EvictFilesFailingUploadResponse> evictFilesFailingUpload(EvictFilesFailingUploadRequest evictFilesFailingUploadRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)evictFilesFailingUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, evictFilesFailingUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EvictFilesFailingUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EvictFilesFailingUploadResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EvictFilesFailingUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EvictFilesFailingUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)evictFilesFailingUploadRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$evictFilesFailingUpload$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$evictFilesFailingUpload$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<JoinDomainResponse> joinDomain(JoinDomainRequest joinDomainRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)joinDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, joinDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"JoinDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, JoinDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("JoinDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new JoinDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)joinDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$joinDomain$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$joinDomain$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAutomaticTapeCreationPoliciesResponse> listAutomaticTapeCreationPolicies(ListAutomaticTapeCreationPoliciesRequest listAutomaticTapeCreationPoliciesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAutomaticTapeCreationPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listAutomaticTapeCreationPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAutomaticTapeCreationPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAutomaticTapeCreationPoliciesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAutomaticTapeCreationPolicies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAutomaticTapeCreationPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAutomaticTapeCreationPoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listAutomaticTapeCreationPolicies$230(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listAutomaticTapeCreationPolicies$231((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCacheReportsResponse> listCacheReports(ListCacheReportsRequest listCacheReportsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCacheReportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listCacheReportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCacheReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCacheReportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCacheReports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCacheReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCacheReportsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listCacheReports$234(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listCacheReports$235((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFileSharesResponse> listFileShares(ListFileSharesRequest listFileSharesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFileSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listFileSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFileShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFileSharesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFileShares").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListFileSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFileSharesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listFileShares$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listFileShares$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFileSystemAssociationsResponse> listFileSystemAssociations(ListFileSystemAssociationsRequest listFileSystemAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFileSystemAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listFileSystemAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFileSystemAssociations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFileSystemAssociationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFileSystemAssociations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListFileSystemAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFileSystemAssociationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listFileSystemAssociations$242(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listFileSystemAssociations$243((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listGatewaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGatewaysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGateways").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListGatewaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listGatewaysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listGateways$246(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listGateways$247((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLocalDisksResponse> listLocalDisks(ListLocalDisksRequest listLocalDisksRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLocalDisksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listLocalDisksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLocalDisks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLocalDisksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLocalDisks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLocalDisksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLocalDisksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listLocalDisks$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listLocalDisks$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listTagsForResource$254(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listTagsForResource$255((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTapePoolsResponse> listTapePools(ListTapePoolsRequest listTapePoolsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTapePoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listTapePoolsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTapePools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTapePoolsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTapePools").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTapePoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTapePoolsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listTapePools$258(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listTapePools$259((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTapesResponse> listTapes(ListTapesRequest listTapesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTapesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listTapesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTapes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTapesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTapes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTapesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTapesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listTapes$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listTapes$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListVolumeInitiatorsResponse> listVolumeInitiators(ListVolumeInitiatorsRequest listVolumeInitiatorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVolumeInitiatorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listVolumeInitiatorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVolumeInitiators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVolumeInitiatorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVolumeInitiators").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListVolumeInitiatorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listVolumeInitiatorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listVolumeInitiators$266(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listVolumeInitiators$267((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListVolumeRecoveryPointsResponse> listVolumeRecoveryPoints(ListVolumeRecoveryPointsRequest listVolumeRecoveryPointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVolumeRecoveryPointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listVolumeRecoveryPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVolumeRecoveryPoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVolumeRecoveryPointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVolumeRecoveryPoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListVolumeRecoveryPointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listVolumeRecoveryPointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listVolumeRecoveryPoints$270(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listVolumeRecoveryPoints$271((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListVolumesResponse> listVolumes(ListVolumesRequest listVolumesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVolumesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, listVolumesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVolumes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVolumesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVolumes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListVolumesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listVolumesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$listVolumes$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$listVolumes$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<NotifyWhenUploadedResponse> notifyWhenUploaded(NotifyWhenUploadedRequest notifyWhenUploadedRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)notifyWhenUploadedRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, notifyWhenUploadedRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyWhenUploaded");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyWhenUploadedResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyWhenUploaded").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new NotifyWhenUploadedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)notifyWhenUploadedRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$notifyWhenUploaded$278(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$notifyWhenUploaded$279((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RefreshCacheResponse> refreshCache(RefreshCacheRequest refreshCacheRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)refreshCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, refreshCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RefreshCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RefreshCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RefreshCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RefreshCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)refreshCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$refreshCache$282(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$refreshCache$283((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsFromResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeTagsFromResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$removeTagsFromResource$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$removeTagsFromResource$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetCacheResponse> resetCache(ResetCacheRequest resetCacheRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resetCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, resetCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetCache").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResetCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resetCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$resetCache$290(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$resetCache$291((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RetrieveTapeArchiveResponse> retrieveTapeArchive(RetrieveTapeArchiveRequest retrieveTapeArchiveRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retrieveTapeArchiveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, retrieveTapeArchiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetrieveTapeArchive");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetrieveTapeArchiveResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetrieveTapeArchive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RetrieveTapeArchiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)retrieveTapeArchiveRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$retrieveTapeArchive$294(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$retrieveTapeArchive$295((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RetrieveTapeRecoveryPointResponse> retrieveTapeRecoveryPoint(RetrieveTapeRecoveryPointRequest retrieveTapeRecoveryPointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retrieveTapeRecoveryPointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, retrieveTapeRecoveryPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetrieveTapeRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetrieveTapeRecoveryPointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetrieveTapeRecoveryPoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RetrieveTapeRecoveryPointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)retrieveTapeRecoveryPointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$retrieveTapeRecoveryPoint$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$retrieveTapeRecoveryPoint$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetLocalConsolePasswordResponse> setLocalConsolePassword(SetLocalConsolePasswordRequest setLocalConsolePasswordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setLocalConsolePasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, setLocalConsolePasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetLocalConsolePassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetLocalConsolePasswordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetLocalConsolePassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetLocalConsolePasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setLocalConsolePasswordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$setLocalConsolePassword$302(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$setLocalConsolePassword$303((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetSmbGuestPasswordResponse> setSMBGuestPassword(SetSmbGuestPasswordRequest setSmbGuestPasswordRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setSmbGuestPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, setSmbGuestPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetSMBGuestPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetSmbGuestPasswordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSMBGuestPassword").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetSmbGuestPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setSmbGuestPasswordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$setSMBGuestPassword$306(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$setSMBGuestPassword$307((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ShutdownGatewayResponse> shutdownGateway(ShutdownGatewayRequest shutdownGatewayRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)shutdownGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, shutdownGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ShutdownGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ShutdownGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ShutdownGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ShutdownGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)shutdownGatewayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$shutdownGateway$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$shutdownGateway$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartAvailabilityMonitorTestResponse> startAvailabilityMonitorTest(StartAvailabilityMonitorTestRequest startAvailabilityMonitorTestRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startAvailabilityMonitorTestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, startAvailabilityMonitorTestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAvailabilityMonitorTest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAvailabilityMonitorTestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAvailabilityMonitorTest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartAvailabilityMonitorTestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startAvailabilityMonitorTestRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$startAvailabilityMonitorTest$314(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$startAvailabilityMonitorTest$315((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartCacheReportResponse> startCacheReport(StartCacheReportRequest startCacheReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startCacheReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, startCacheReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCacheReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCacheReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCacheReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartCacheReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startCacheReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$startCacheReport$318(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$startCacheReport$319((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartGatewayResponse> startGateway(StartGatewayRequest startGatewayRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, startGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startGatewayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$startGateway$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$startGateway$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAutomaticTapeCreationPolicyResponse> updateAutomaticTapeCreationPolicy(UpdateAutomaticTapeCreationPolicyRequest updateAutomaticTapeCreationPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAutomaticTapeCreationPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateAutomaticTapeCreationPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAutomaticTapeCreationPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAutomaticTapeCreationPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAutomaticTapeCreationPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAutomaticTapeCreationPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAutomaticTapeCreationPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateAutomaticTapeCreationPolicy$326(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateAutomaticTapeCreationPolicy$327((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBandwidthRateLimitResponse> updateBandwidthRateLimit(UpdateBandwidthRateLimitRequest updateBandwidthRateLimitRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBandwidthRateLimitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateBandwidthRateLimitRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBandwidthRateLimit");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBandwidthRateLimitResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBandwidthRateLimit").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBandwidthRateLimitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBandwidthRateLimitRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateBandwidthRateLimit$330(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateBandwidthRateLimit$331((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBandwidthRateLimitScheduleResponse> updateBandwidthRateLimitSchedule(UpdateBandwidthRateLimitScheduleRequest updateBandwidthRateLimitScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBandwidthRateLimitScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateBandwidthRateLimitScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBandwidthRateLimitSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBandwidthRateLimitScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBandwidthRateLimitSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBandwidthRateLimitScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBandwidthRateLimitScheduleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateBandwidthRateLimitSchedule$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateBandwidthRateLimitSchedule$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateChapCredentialsResponse> updateChapCredentials(UpdateChapCredentialsRequest updateChapCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateChapCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateChapCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateChapCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChapCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChapCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateChapCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateChapCredentialsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateChapCredentials$338(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateChapCredentials$339((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFileSystemAssociationResponse> updateFileSystemAssociation(UpdateFileSystemAssociationRequest updateFileSystemAssociationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFileSystemAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateFileSystemAssociationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFileSystemAssociation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFileSystemAssociationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFileSystemAssociation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFileSystemAssociationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFileSystemAssociationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateFileSystemAssociation$342(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateFileSystemAssociation$343((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGatewayInformationResponse> updateGatewayInformation(UpdateGatewayInformationRequest updateGatewayInformationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGatewayInformationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateGatewayInformationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGatewayInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGatewayInformationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGatewayInformation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateGatewayInformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateGatewayInformationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateGatewayInformation$346(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateGatewayInformation$347((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGatewaySoftwareNowResponse> updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGatewaySoftwareNowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateGatewaySoftwareNowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGatewaySoftwareNow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGatewaySoftwareNowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGatewaySoftwareNow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateGatewaySoftwareNowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateGatewaySoftwareNowRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateGatewaySoftwareNow$350(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateGatewaySoftwareNow$351((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateMaintenanceStartTimeResponse> updateMaintenanceStartTime(UpdateMaintenanceStartTimeRequest updateMaintenanceStartTimeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMaintenanceStartTimeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateMaintenanceStartTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMaintenanceStartTime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMaintenanceStartTimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMaintenanceStartTime").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateMaintenanceStartTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateMaintenanceStartTimeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateMaintenanceStartTime$354(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateMaintenanceStartTime$355((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateNfsFileShareResponse> updateNFSFileShare(UpdateNfsFileShareRequest updateNfsFileShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNfsFileShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateNfsFileShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNFSFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNfsFileShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNFSFileShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateNfsFileShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateNfsFileShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateNFSFileShare$358(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateNFSFileShare$359((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSmbFileShareResponse> updateSMBFileShare(UpdateSmbFileShareRequest updateSmbFileShareRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSmbFileShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateSmbFileShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSMBFileShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSmbFileShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSMBFileShare").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSmbFileShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSmbFileShareRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateSMBFileShare$362(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateSMBFileShare$363((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSmbFileShareVisibilityResponse> updateSMBFileShareVisibility(UpdateSmbFileShareVisibilityRequest updateSmbFileShareVisibilityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSmbFileShareVisibilityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateSmbFileShareVisibilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSMBFileShareVisibility");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSmbFileShareVisibilityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSMBFileShareVisibility").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSmbFileShareVisibilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSmbFileShareVisibilityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateSMBFileShareVisibility$366(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateSMBFileShareVisibility$367((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSmbLocalGroupsResponse> updateSMBLocalGroups(UpdateSmbLocalGroupsRequest updateSmbLocalGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSmbLocalGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateSmbLocalGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSMBLocalGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSmbLocalGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSMBLocalGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSmbLocalGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSmbLocalGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateSMBLocalGroups$370(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateSMBLocalGroups$371((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSmbSecurityStrategyResponse> updateSMBSecurityStrategy(UpdateSmbSecurityStrategyRequest updateSmbSecurityStrategyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSmbSecurityStrategyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateSmbSecurityStrategyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSMBSecurityStrategy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSmbSecurityStrategyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSMBSecurityStrategy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSmbSecurityStrategyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSmbSecurityStrategyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateSMBSecurityStrategy$374(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateSMBSecurityStrategy$375((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSnapshotScheduleResponse> updateSnapshotSchedule(UpdateSnapshotScheduleRequest updateSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSnapshotScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateSnapshotScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSnapshotSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSnapshotScheduleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSnapshotSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSnapshotScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSnapshotScheduleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateSnapshotSchedule$378(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateSnapshotSchedule$379((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateVtlDeviceTypeResponse> updateVTLDeviceType(UpdateVtlDeviceTypeRequest updateVtlDeviceTypeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateVtlDeviceTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultStorageGatewayAsyncClient.resolveMetricPublishers(clientConfiguration, updateVtlDeviceTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Storage Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVTLDeviceType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVtlDeviceTypeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidGatewayRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGatewayRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidGatewayRequestException::builder).build());
                    }
                    case "ServiceUnavailableError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceUnavailableErrorException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVTLDeviceType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateVtlDeviceTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateVtlDeviceTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultStorageGatewayAsyncClient.lambda$updateVTLDeviceType$382(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultStorageGatewayAsyncClient.lambda$updateVTLDeviceType$383((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final StorageGatewayServiceClientConfiguration serviceClientConfiguration() {
        return new StorageGatewayServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "storagegateway";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(StorageGatewayException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        StorageGatewayServiceClientConfigurationBuilder serviceConfigBuilder = new StorageGatewayServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateVTLDeviceType$383(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVTLDeviceType$382(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateVtlDeviceTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSnapshotSchedule$379(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSnapshotSchedule$378(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSnapshotScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSMBSecurityStrategy$375(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSMBSecurityStrategy$374(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSmbSecurityStrategyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSMBLocalGroups$371(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSMBLocalGroups$370(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSmbLocalGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSMBFileShareVisibility$367(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSMBFileShareVisibility$366(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSmbFileShareVisibilityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSMBFileShare$363(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSMBFileShare$362(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSmbFileShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateNFSFileShare$359(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNFSFileShare$358(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateNfsFileShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateMaintenanceStartTime$355(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMaintenanceStartTime$354(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateMaintenanceStartTimeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateGatewaySoftwareNow$351(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGatewaySoftwareNow$350(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGatewaySoftwareNowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateGatewayInformation$347(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGatewayInformation$346(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGatewayInformationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFileSystemAssociation$343(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFileSystemAssociation$342(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFileSystemAssociationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateChapCredentials$339(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateChapCredentials$338(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateChapCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBandwidthRateLimitSchedule$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBandwidthRateLimitSchedule$334(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBandwidthRateLimitScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBandwidthRateLimit$331(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBandwidthRateLimit$330(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBandwidthRateLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAutomaticTapeCreationPolicy$327(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAutomaticTapeCreationPolicy$326(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAutomaticTapeCreationPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startGateway$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startGateway$322(List metricPublishers, MetricCollector apiCallMetricCollector, StartGatewayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startCacheReport$319(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCacheReport$318(List metricPublishers, MetricCollector apiCallMetricCollector, StartCacheReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startAvailabilityMonitorTest$315(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAvailabilityMonitorTest$314(List metricPublishers, MetricCollector apiCallMetricCollector, StartAvailabilityMonitorTestResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$shutdownGateway$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$shutdownGateway$310(List metricPublishers, MetricCollector apiCallMetricCollector, ShutdownGatewayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setSMBGuestPassword$307(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setSMBGuestPassword$306(List metricPublishers, MetricCollector apiCallMetricCollector, SetSmbGuestPasswordResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setLocalConsolePassword$303(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setLocalConsolePassword$302(List metricPublishers, MetricCollector apiCallMetricCollector, SetLocalConsolePasswordResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$retrieveTapeRecoveryPoint$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retrieveTapeRecoveryPoint$298(List metricPublishers, MetricCollector apiCallMetricCollector, RetrieveTapeRecoveryPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$retrieveTapeArchive$295(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retrieveTapeArchive$294(List metricPublishers, MetricCollector apiCallMetricCollector, RetrieveTapeArchiveResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resetCache$291(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetCache$290(List metricPublishers, MetricCollector apiCallMetricCollector, ResetCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeTagsFromResource$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTagsFromResource$286(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveTagsFromResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$refreshCache$283(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$refreshCache$282(List metricPublishers, MetricCollector apiCallMetricCollector, RefreshCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$notifyWhenUploaded$279(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$notifyWhenUploaded$278(List metricPublishers, MetricCollector apiCallMetricCollector, NotifyWhenUploadedResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listVolumes$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVolumes$274(List metricPublishers, MetricCollector apiCallMetricCollector, ListVolumesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listVolumeRecoveryPoints$271(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVolumeRecoveryPoints$270(List metricPublishers, MetricCollector apiCallMetricCollector, ListVolumeRecoveryPointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listVolumeInitiators$267(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVolumeInitiators$266(List metricPublishers, MetricCollector apiCallMetricCollector, ListVolumeInitiatorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTapes$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTapes$262(List metricPublishers, MetricCollector apiCallMetricCollector, ListTapesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTapePools$259(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTapePools$258(List metricPublishers, MetricCollector apiCallMetricCollector, ListTapePoolsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$255(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$254(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLocalDisks$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLocalDisks$250(List metricPublishers, MetricCollector apiCallMetricCollector, ListLocalDisksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listGateways$247(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGateways$246(List metricPublishers, MetricCollector apiCallMetricCollector, ListGatewaysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFileSystemAssociations$243(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFileSystemAssociations$242(List metricPublishers, MetricCollector apiCallMetricCollector, ListFileSystemAssociationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFileShares$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFileShares$238(List metricPublishers, MetricCollector apiCallMetricCollector, ListFileSharesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCacheReports$235(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCacheReports$234(List metricPublishers, MetricCollector apiCallMetricCollector, ListCacheReportsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAutomaticTapeCreationPolicies$231(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAutomaticTapeCreationPolicies$230(List metricPublishers, MetricCollector apiCallMetricCollector, ListAutomaticTapeCreationPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$joinDomain$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$joinDomain$226(List metricPublishers, MetricCollector apiCallMetricCollector, JoinDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$evictFilesFailingUpload$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$evictFilesFailingUpload$222(List metricPublishers, MetricCollector apiCallMetricCollector, EvictFilesFailingUploadResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateFileSystem$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateFileSystem$218(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateFileSystemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableGateway$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableGateway$214(List metricPublishers, MetricCollector apiCallMetricCollector, DisableGatewayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachVolume$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachVolume$210(List metricPublishers, MetricCollector apiCallMetricCollector, DetachVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeWorkingStorage$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeWorkingStorage$206(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeWorkingStorageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeVTLDevices$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVTLDevices$202(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeVtlDevicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeUploadBuffer$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUploadBuffer$198(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeUploadBufferResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTapes$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTapes$194(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTapesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTapeRecoveryPoints$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTapeRecoveryPoints$190(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTapeRecoveryPointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTapeArchives$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTapeArchives$186(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTapeArchivesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeStorediSCSIVolumes$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStorediSCSIVolumes$182(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeStorediScsiVolumesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSnapshotSchedule$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSnapshotSchedule$178(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSnapshotScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSMBSettings$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSMBSettings$174(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSmbSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSMBFileShares$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSMBFileShares$170(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSmbFileSharesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeNFSFileShares$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNFSFileShares$166(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeNfsFileSharesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMaintenanceStartTime$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMaintenanceStartTime$162(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMaintenanceStartTimeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeGatewayInformation$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGatewayInformation$158(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeGatewayInformationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFileSystemAssociations$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFileSystemAssociations$154(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFileSystemAssociationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeChapCredentials$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeChapCredentials$150(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeChapCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCachediSCSIVolumes$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCachediSCSIVolumes$146(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCachediScsiVolumesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCacheReport$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCacheReport$142(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCacheReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCache$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCache$138(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeBandwidthRateLimitSchedule$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBandwidthRateLimitSchedule$134(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBandwidthRateLimitScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeBandwidthRateLimit$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBandwidthRateLimit$130(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBandwidthRateLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAvailabilityMonitorTest$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAvailabilityMonitorTest$126(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAvailabilityMonitorTestResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteVolume$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVolume$122(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTapePool$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTapePool$118(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTapePoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTapeArchive$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTapeArchive$114(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTapeArchiveResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTape$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTape$110(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTapeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSnapshotSchedule$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSnapshotSchedule$106(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSnapshotScheduleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteGateway$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGateway$102(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteGatewayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFileShare$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFileShare$98(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFileShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteChapCredentials$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteChapCredentials$94(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteChapCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCacheReport$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCacheReport$90(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCacheReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBandwidthRateLimit$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBandwidthRateLimit$86(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBandwidthRateLimitResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAutomaticTapeCreationPolicy$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAutomaticTapeCreationPolicy$82(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAutomaticTapeCreationPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTapes$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTapes$78(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTapesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTapeWithBarcode$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTapeWithBarcode$74(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTapeWithBarcodeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTapePool$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTapePool$70(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTapePoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createStorediSCSIVolume$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStorediSCSIVolume$66(List metricPublishers, MetricCollector apiCallMetricCollector, CreateStorediScsiVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSnapshotFromVolumeRecoveryPoint$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshotFromVolumeRecoveryPoint$62(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSnapshotFromVolumeRecoveryPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSnapshot$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSnapshot$58(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSMBFileShare$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSMBFileShare$54(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSmbFileShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createNFSFileShare$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNFSFileShare$50(List metricPublishers, MetricCollector apiCallMetricCollector, CreateNfsFileShareResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCachediSCSIVolume$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCachediSCSIVolume$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCachediScsiVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelRetrieval$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelRetrieval$42(List metricPublishers, MetricCollector apiCallMetricCollector, CancelRetrievalResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelCacheReport$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelCacheReport$38(List metricPublishers, MetricCollector apiCallMetricCollector, CancelCacheReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelArchival$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelArchival$34(List metricPublishers, MetricCollector apiCallMetricCollector, CancelArchivalResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachVolume$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachVolume$30(List metricPublishers, MetricCollector apiCallMetricCollector, AttachVolumeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateFileSystem$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateFileSystem$26(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateFileSystemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$assignTapePool$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$assignTapePool$22(List metricPublishers, MetricCollector apiCallMetricCollector, AssignTapePoolResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addWorkingStorage$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addWorkingStorage$18(List metricPublishers, MetricCollector apiCallMetricCollector, AddWorkingStorageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addUploadBuffer$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addUploadBuffer$14(List metricPublishers, MetricCollector apiCallMetricCollector, AddUploadBufferResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addTagsToResource$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTagsToResource$10(List metricPublishers, MetricCollector apiCallMetricCollector, AddTagsToResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addCache$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addCache$6(List metricPublishers, MetricCollector apiCallMetricCollector, AddCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$activateGateway$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$activateGateway$2(List metricPublishers, MetricCollector apiCallMetricCollector, ActivateGatewayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

