/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.VTLDeviceARNsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVtlDevicesRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, DescribeVtlDevicesRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeVtlDevicesRequest.getter(DescribeVtlDevicesRequest::gatewayARN)).setter(DescribeVtlDevicesRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<String>> VTL_DEVICE_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VTLDeviceARNs").getter(DescribeVtlDevicesRequest.getter(DescribeVtlDevicesRequest::vtlDeviceARNs)).setter(DescribeVtlDevicesRequest.setter(Builder::vtlDeviceARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeVtlDevicesRequest.getter(DescribeVtlDevicesRequest::marker)).setter(DescribeVtlDevicesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeVtlDevicesRequest.getter(DescribeVtlDevicesRequest::limit)).setter(DescribeVtlDevicesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, VTL_DEVICE_AR_NS_FIELD, MARKER_FIELD, LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVtlDevicesRequest.memberNameToFieldInitializer();
    private final String gatewayARN;
    private final List<String> vtlDeviceARNs;
    private final String marker;
    private final Integer limit;

    private DescribeVtlDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.vtlDeviceARNs = builder.vtlDeviceARNs;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final boolean hasVtlDeviceARNs() {
        return this.vtlDeviceARNs != null && !(this.vtlDeviceARNs instanceof SdkAutoConstructList);
    }

    public final List<String> vtlDeviceARNs() {
        return this.vtlDeviceARNs;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVtlDeviceARNs() ? this.vtlDeviceARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVtlDevicesRequest)) {
            return false;
        }
        DescribeVtlDevicesRequest other = (DescribeVtlDevicesRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && this.hasVtlDeviceARNs() == other.hasVtlDeviceARNs() && Objects.equals(this.vtlDeviceARNs(), other.vtlDeviceARNs()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVtlDevicesRequest").add("GatewayARN", (Object)this.gatewayARN()).add("VTLDeviceARNs", this.hasVtlDeviceARNs() ? this.vtlDeviceARNs() : null).add("Marker", (Object)this.marker()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "VTLDeviceARNs": {
                return Optional.ofNullable(clazz.cast(this.vtlDeviceARNs()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("VTLDeviceARNs", VTL_DEVICE_AR_NS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVtlDevicesRequest, T> g) {
        return obj -> g.apply((DescribeVtlDevicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<String> vtlDeviceARNs = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVtlDevicesRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.vtlDeviceARNs(model.vtlDeviceARNs);
            this.marker(model.marker);
            this.limit(model.limit);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Collection<String> getVtlDeviceARNs() {
            if (this.vtlDeviceARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vtlDeviceARNs;
        }

        public final void setVtlDeviceARNs(Collection<String> vtlDeviceARNs) {
            this.vtlDeviceARNs = VTLDeviceARNsCopier.copy(vtlDeviceARNs);
        }

        @Override
        public final Builder vtlDeviceARNs(Collection<String> vtlDeviceARNs) {
            this.vtlDeviceARNs = VTLDeviceARNsCopier.copy(vtlDeviceARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vtlDeviceARNs(String ... vtlDeviceARNs) {
            this.vtlDeviceARNs(Arrays.asList(vtlDeviceARNs));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVtlDevicesRequest build() {
            return new DescribeVtlDevicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVtlDevicesRequest> {
        public Builder gatewayARN(String var1);

        public Builder vtlDeviceARNs(Collection<String> var1);

        public Builder vtlDeviceARNs(String ... var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

