/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSupportedLanguagesRequest extends SupportRequest implements
        ToCopyableBuilder<DescribeSupportedLanguagesRequest.Builder, DescribeSupportedLanguagesRequest> {
    private static final SdkField<String> ISSUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("issueType").getter(getter(DescribeSupportedLanguagesRequest::issueType))
            .setter(setter(Builder::issueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issueType").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(DescribeSupportedLanguagesRequest::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> CATEGORY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("categoryCode").getter(getter(DescribeSupportedLanguagesRequest::categoryCode))
            .setter(setter(Builder::categoryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoryCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUE_TYPE_FIELD,
            SERVICE_CODE_FIELD, CATEGORY_CODE_FIELD));

    private final String issueType;

    private final String serviceCode;

    private final String categoryCode;

    private DescribeSupportedLanguagesRequest(BuilderImpl builder) {
        super(builder);
        this.issueType = builder.issueType;
        this.serviceCode = builder.serviceCode;
        this.categoryCode = builder.categoryCode;
    }

    /**
     * <p>
     * The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>.
     * </p>
     * 
     * @return The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>.
     */
    public final String issueType() {
        return issueType;
    }

    /**
     * <p>
     * The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get the
     * possible <code>serviceCode</code> values.
     * </p>
     * 
     * @return The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get
     *         the possible <code>serviceCode</code> values.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get the
     * category code for a service. Each Amazon Web Services service defines its own set of category codes.
     * </p>
     * 
     * @return The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get
     *         the category code for a service. Each Amazon Web Services service defines its own set of category codes.
     */
    public final String categoryCode() {
        return categoryCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(issueType());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(categoryCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSupportedLanguagesRequest)) {
            return false;
        }
        DescribeSupportedLanguagesRequest other = (DescribeSupportedLanguagesRequest) obj;
        return Objects.equals(issueType(), other.issueType()) && Objects.equals(serviceCode(), other.serviceCode())
                && Objects.equals(categoryCode(), other.categoryCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSupportedLanguagesRequest").add("IssueType", issueType())
                .add("ServiceCode", serviceCode()).add("CategoryCode", categoryCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "issueType":
            return Optional.ofNullable(clazz.cast(issueType()));
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "categoryCode":
            return Optional.ofNullable(clazz.cast(categoryCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSupportedLanguagesRequest, T> g) {
        return obj -> g.apply((DescribeSupportedLanguagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SupportRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSupportedLanguagesRequest> {
        /**
         * <p>
         * The type of issue for the case. You can specify <code>customer-service</code> or <code>technical</code>.
         * </p>
         * 
         * @param issueType
         *        The type of issue for the case. You can specify <code>customer-service</code> or
         *        <code>technical</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueType(String issueType);

        /**
         * <p>
         * The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get the
         * possible <code>serviceCode</code> values.
         * </p>
         * 
         * @param serviceCode
         *        The code for the Amazon Web Services service. You can use the <a>DescribeServices</a> operation to get
         *        the possible <code>serviceCode</code> values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The category of problem for the support case. You also use the <a>DescribeServices</a> operation to get the
         * category code for a service. Each Amazon Web Services service defines its own set of category codes.
         * </p>
         * 
         * @param categoryCode
         *        The category of problem for the support case. You also use the <a>DescribeServices</a> operation to
         *        get the category code for a service. Each Amazon Web Services service defines its own set of category
         *        codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryCode(String categoryCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SupportRequest.BuilderImpl implements Builder {
        private String issueType;

        private String serviceCode;

        private String categoryCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSupportedLanguagesRequest model) {
            super(model);
            issueType(model.issueType);
            serviceCode(model.serviceCode);
            categoryCode(model.categoryCode);
        }

        public final String getIssueType() {
            return issueType;
        }

        public final void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        @Override
        public final Builder issueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getCategoryCode() {
            return categoryCode;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSupportedLanguagesRequest build() {
            return new DescribeSupportedLanguagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
