/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.CcEmailAddressListCopier;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCaseRequest
extends SupportRequest
implements ToCopyableBuilder<Builder, CreateCaseRequest> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subject").getter(CreateCaseRequest.getter(CreateCaseRequest::subject)).setter(CreateCaseRequest.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(CreateCaseRequest.getter(CreateCaseRequest::serviceCode)).setter(CreateCaseRequest.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> SEVERITY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severityCode").getter(CreateCaseRequest.getter(CreateCaseRequest::severityCode)).setter(CreateCaseRequest.setter(Builder::severityCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCode").build()}).build();
    private static final SdkField<String> CATEGORY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("categoryCode").getter(CreateCaseRequest.getter(CreateCaseRequest::categoryCode)).setter(CreateCaseRequest.setter(Builder::categoryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoryCode").build()}).build();
    private static final SdkField<String> COMMUNICATION_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("communicationBody").getter(CreateCaseRequest.getter(CreateCaseRequest::communicationBody)).setter(CreateCaseRequest.setter(Builder::communicationBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationBody").build()}).build();
    private static final SdkField<List<String>> CC_EMAIL_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ccEmailAddresses").getter(CreateCaseRequest.getter(CreateCaseRequest::ccEmailAddresses)).setter(CreateCaseRequest.setter(Builder::ccEmailAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccEmailAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(CreateCaseRequest.getter(CreateCaseRequest::language)).setter(CreateCaseRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<String> ISSUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issueType").getter(CreateCaseRequest.getter(CreateCaseRequest::issueType)).setter(CreateCaseRequest.setter(Builder::issueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issueType").build()}).build();
    private static final SdkField<String> ATTACHMENT_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentSetId").getter(CreateCaseRequest.getter(CreateCaseRequest::attachmentSetId)).setter(CreateCaseRequest.setter(Builder::attachmentSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, SERVICE_CODE_FIELD, SEVERITY_CODE_FIELD, CATEGORY_CODE_FIELD, COMMUNICATION_BODY_FIELD, CC_EMAIL_ADDRESSES_FIELD, LANGUAGE_FIELD, ISSUE_TYPE_FIELD, ATTACHMENT_SET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCaseRequest.memberNameToFieldInitializer();
    private final String subject;
    private final String serviceCode;
    private final String severityCode;
    private final String categoryCode;
    private final String communicationBody;
    private final List<String> ccEmailAddresses;
    private final String language;
    private final String issueType;
    private final String attachmentSetId;

    private CreateCaseRequest(BuilderImpl builder) {
        super(builder);
        this.subject = builder.subject;
        this.serviceCode = builder.serviceCode;
        this.severityCode = builder.severityCode;
        this.categoryCode = builder.categoryCode;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.language = builder.language;
        this.issueType = builder.issueType;
        this.attachmentSetId = builder.attachmentSetId;
    }

    public final String subject() {
        return this.subject;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String severityCode() {
        return this.severityCode;
    }

    public final String categoryCode() {
        return this.categoryCode;
    }

    public final String communicationBody() {
        return this.communicationBody;
    }

    public final boolean hasCcEmailAddresses() {
        return this.ccEmailAddresses != null && !(this.ccEmailAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> ccEmailAddresses() {
        return this.ccEmailAddresses;
    }

    public final String language() {
        return this.language;
    }

    public final String issueType() {
        return this.issueType;
    }

    public final String attachmentSetId() {
        return this.attachmentSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.communicationBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCcEmailAddresses() ? this.ccEmailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueType());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentSetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRequest)) {
            return false;
        }
        CreateCaseRequest other = (CreateCaseRequest)((Object)obj);
        return Objects.equals(this.subject(), other.subject()) && Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.severityCode(), other.severityCode()) && Objects.equals(this.categoryCode(), other.categoryCode()) && Objects.equals(this.communicationBody(), other.communicationBody()) && this.hasCcEmailAddresses() == other.hasCcEmailAddresses() && Objects.equals(this.ccEmailAddresses(), other.ccEmailAddresses()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.issueType(), other.issueType()) && Objects.equals(this.attachmentSetId(), other.attachmentSetId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCaseRequest").add("Subject", (Object)this.subject()).add("ServiceCode", (Object)this.serviceCode()).add("SeverityCode", (Object)this.severityCode()).add("CategoryCode", (Object)this.categoryCode()).add("CommunicationBody", (Object)this.communicationBody()).add("CcEmailAddresses", this.hasCcEmailAddresses() ? this.ccEmailAddresses() : null).add("Language", (Object)this.language()).add("IssueType", (Object)this.issueType()).add("AttachmentSetId", (Object)this.attachmentSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "severityCode": {
                return Optional.ofNullable(clazz.cast(this.severityCode()));
            }
            case "categoryCode": {
                return Optional.ofNullable(clazz.cast(this.categoryCode()));
            }
            case "communicationBody": {
                return Optional.ofNullable(clazz.cast(this.communicationBody()));
            }
            case "ccEmailAddresses": {
                return Optional.ofNullable(clazz.cast(this.ccEmailAddresses()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "issueType": {
                return Optional.ofNullable(clazz.cast(this.issueType()));
            }
            case "attachmentSetId": {
                return Optional.ofNullable(clazz.cast(this.attachmentSetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subject", SUBJECT_FIELD);
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("severityCode", SEVERITY_CODE_FIELD);
        map.put("categoryCode", CATEGORY_CODE_FIELD);
        map.put("communicationBody", COMMUNICATION_BODY_FIELD);
        map.put("ccEmailAddresses", CC_EMAIL_ADDRESSES_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("issueType", ISSUE_TYPE_FIELD);
        map.put("attachmentSetId", ATTACHMENT_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCaseRequest, T> g) {
        return obj -> g.apply((CreateCaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportRequest.BuilderImpl
    implements Builder {
        private String subject;
        private String serviceCode;
        private String severityCode;
        private String categoryCode;
        private String communicationBody;
        private List<String> ccEmailAddresses = DefaultSdkAutoConstructList.getInstance();
        private String language;
        private String issueType;
        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseRequest model) {
            super(model);
            this.subject(model.subject);
            this.serviceCode(model.serviceCode);
            this.severityCode(model.severityCode);
            this.categoryCode(model.categoryCode);
            this.communicationBody(model.communicationBody);
            this.ccEmailAddresses(model.ccEmailAddresses);
            this.language(model.language);
            this.issueType(model.issueType);
            this.attachmentSetId(model.attachmentSetId);
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getSeverityCode() {
            return this.severityCode;
        }

        public final void setSeverityCode(String severityCode) {
            this.severityCode = severityCode;
        }

        @Override
        public final Builder severityCode(String severityCode) {
            this.severityCode = severityCode;
            return this;
        }

        public final String getCategoryCode() {
            return this.categoryCode;
        }

        public final void setCategoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
        }

        @Override
        public final Builder categoryCode(String categoryCode) {
            this.categoryCode = categoryCode;
            return this;
        }

        public final String getCommunicationBody() {
            return this.communicationBody;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final Collection<String> getCcEmailAddresses() {
            if (this.ccEmailAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ccEmailAddresses;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String ... ccEmailAddresses) {
            this.ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getIssueType() {
            return this.issueType;
        }

        public final void setIssueType(String issueType) {
            this.issueType = issueType;
        }

        @Override
        public final Builder issueType(String issueType) {
            this.issueType = issueType;
            return this;
        }

        public final String getAttachmentSetId() {
            return this.attachmentSetId;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCaseRequest build() {
            return new CreateCaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SupportRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCaseRequest> {
        public Builder subject(String var1);

        public Builder serviceCode(String var1);

        public Builder severityCode(String var1);

        public Builder categoryCode(String var1);

        public Builder communicationBody(String var1);

        public Builder ccEmailAddresses(Collection<String> var1);

        public Builder ccEmailAddresses(String ... var1);

        public Builder language(String var1);

        public Builder issueType(String var1);

        public Builder attachmentSetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

