/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.ServiceCodeListCopier;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServicesRequest
extends SupportRequest
implements ToCopyableBuilder<Builder, DescribeServicesRequest> {
    private static final SdkField<List<String>> SERVICE_CODE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceCodeList").getter(DescribeServicesRequest.getter(DescribeServicesRequest::serviceCodeList)).setter(DescribeServicesRequest.setter(Builder::serviceCodeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCodeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(DescribeServicesRequest.getter(DescribeServicesRequest::language)).setter(DescribeServicesRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_LIST_FIELD, LANGUAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServicesRequest.memberNameToFieldInitializer();
    private final List<String> serviceCodeList;
    private final String language;

    private DescribeServicesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCodeList = builder.serviceCodeList;
        this.language = builder.language;
    }

    public final boolean hasServiceCodeList() {
        return this.serviceCodeList != null && !(this.serviceCodeList instanceof SdkAutoConstructList);
    }

    public final List<String> serviceCodeList() {
        return this.serviceCodeList;
    }

    public final String language() {
        return this.language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceCodeList() ? this.serviceCodeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesRequest)) {
            return false;
        }
        DescribeServicesRequest other = (DescribeServicesRequest)((Object)obj);
        return this.hasServiceCodeList() == other.hasServiceCodeList() && Objects.equals(this.serviceCodeList(), other.serviceCodeList()) && Objects.equals(this.language(), other.language());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServicesRequest").add("ServiceCodeList", this.hasServiceCodeList() ? this.serviceCodeList() : null).add("Language", (Object)this.language()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceCodeList": {
                return Optional.ofNullable(clazz.cast(this.serviceCodeList()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceCodeList", SERVICE_CODE_LIST_FIELD);
        map.put("language", LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServicesRequest, T> g) {
        return obj -> g.apply((DescribeServicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportRequest.BuilderImpl
    implements Builder {
        private List<String> serviceCodeList = DefaultSdkAutoConstructList.getInstance();
        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesRequest model) {
            super(model);
            this.serviceCodeList(model.serviceCodeList);
            this.language(model.language);
        }

        public final Collection<String> getServiceCodeList() {
            if (this.serviceCodeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceCodeList;
        }

        public final void setServiceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
        }

        @Override
        public final Builder serviceCodeList(Collection<String> serviceCodeList) {
            this.serviceCodeList = ServiceCodeListCopier.copy(serviceCodeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodeList(String ... serviceCodeList) {
            this.serviceCodeList(Arrays.asList(serviceCodeList));
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServicesRequest build() {
            return new DescribeServicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SupportRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServicesRequest> {
        public Builder serviceCodeList(Collection<String> var1);

        public Builder serviceCodeList(String ... var1);

        public Builder language(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

