/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.services.support.model.SupportedLanguage;
import software.amazon.awssdk.services.support.model.SupportedLanguagesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSupportedLanguagesResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeSupportedLanguagesResponse> {
    private static final SdkField<List<SupportedLanguage>> SUPPORTED_LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedLanguages").getter(DescribeSupportedLanguagesResponse.getter(DescribeSupportedLanguagesResponse::supportedLanguages)).setter(DescribeSupportedLanguagesResponse.setter(Builder::supportedLanguages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedLanguages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportedLanguage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_LANGUAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSupportedLanguagesResponse.memberNameToFieldInitializer();
    private final List<SupportedLanguage> supportedLanguages;

    private DescribeSupportedLanguagesResponse(BuilderImpl builder) {
        super(builder);
        this.supportedLanguages = builder.supportedLanguages;
    }

    public final boolean hasSupportedLanguages() {
        return this.supportedLanguages != null && !(this.supportedLanguages instanceof SdkAutoConstructList);
    }

    public final List<SupportedLanguage> supportedLanguages() {
        return this.supportedLanguages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedLanguages() ? this.supportedLanguages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSupportedLanguagesResponse)) {
            return false;
        }
        DescribeSupportedLanguagesResponse other = (DescribeSupportedLanguagesResponse)((Object)obj);
        return this.hasSupportedLanguages() == other.hasSupportedLanguages() && Objects.equals(this.supportedLanguages(), other.supportedLanguages());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSupportedLanguagesResponse").add("SupportedLanguages", this.hasSupportedLanguages() ? this.supportedLanguages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "supportedLanguages": {
                return Optional.ofNullable(clazz.cast(this.supportedLanguages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<SupportedLanguage>>> map = new HashMap<String, SdkField<List<SupportedLanguage>>>();
        map.put("supportedLanguages", SUPPORTED_LANGUAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSupportedLanguagesResponse, T> g) {
        return obj -> g.apply((DescribeSupportedLanguagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<SupportedLanguage> supportedLanguages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSupportedLanguagesResponse model) {
            super(model);
            this.supportedLanguages(model.supportedLanguages);
        }

        public final List<SupportedLanguage.Builder> getSupportedLanguages() {
            List<SupportedLanguage.Builder> result = SupportedLanguagesListCopier.copyToBuilder(this.supportedLanguages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedLanguages(Collection<SupportedLanguage.BuilderImpl> supportedLanguages) {
            this.supportedLanguages = SupportedLanguagesListCopier.copyFromBuilder(supportedLanguages);
        }

        @Override
        public final Builder supportedLanguages(Collection<SupportedLanguage> supportedLanguages) {
            this.supportedLanguages = SupportedLanguagesListCopier.copy(supportedLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLanguages(SupportedLanguage ... supportedLanguages) {
            this.supportedLanguages(Arrays.asList(supportedLanguages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLanguages(Consumer<SupportedLanguage.Builder> ... supportedLanguages) {
            this.supportedLanguages(Stream.of(supportedLanguages).map(c -> (SupportedLanguage)((SupportedLanguage.Builder)SupportedLanguage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSupportedLanguagesResponse build() {
            return new DescribeSupportedLanguagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SupportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSupportedLanguagesResponse> {
        public Builder supportedLanguages(Collection<SupportedLanguage> var1);

        public Builder supportedLanguages(SupportedLanguage ... var1);

        public Builder supportedLanguages(Consumer<SupportedLanguage.Builder> ... var1);
    }
}

