/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssociatedGroupsResponse extends SyntheticsResponse implements
        ToCopyableBuilder<ListAssociatedGroupsResponse.Builder, ListAssociatedGroupsResponse> {
    private static final SdkField<List<GroupSummary>> GROUPS_FIELD = SdkField
            .<List<GroupSummary>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(ListAssociatedGroupsResponse::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAssociatedGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GROUPS_FIELD, NEXT_TOKEN_FIELD));

    private final List<GroupSummary> groups;

    private final String nextToken;

    private ListAssociatedGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.groups = builder.groups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that contain information about the groups that this canary is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return An array of structures that contain information about the groups that this canary is associated with.
     */
    public final List<GroupSummary> groups() {
        return groups;
    }

    /**
     * <p>
     * A token that indicates that there is more data available. You can use this token in a subsequent
     * <code>ListAssociatedGroups</code> operation to retrieve the next set of results.
     * </p>
     * 
     * @return A token that indicates that there is more data available. You can use this token in a subsequent
     *         <code>ListAssociatedGroups</code> operation to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedGroupsResponse)) {
            return false;
        }
        ListAssociatedGroupsResponse other = (ListAssociatedGroupsResponse) obj;
        return hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssociatedGroupsResponse").add("Groups", hasGroups() ? groups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedGroupsResponse, T> g) {
        return obj -> g.apply((ListAssociatedGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SyntheticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAssociatedGroupsResponse> {
        /**
         * <p>
         * An array of structures that contain information about the groups that this canary is associated with.
         * </p>
         * 
         * @param groups
         *        An array of structures that contain information about the groups that this canary is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupSummary> groups);

        /**
         * <p>
         * An array of structures that contain information about the groups that this canary is associated with.
         * </p>
         * 
         * @param groups
         *        An array of structures that contain information about the groups that this canary is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupSummary... groups);

        /**
         * <p>
         * An array of structures that contain information about the groups that this canary is associated with.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.synthetics.model.GroupSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.synthetics.model.GroupSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.synthetics.model.GroupSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #groups(List<GroupSummary>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.synthetics.model.GroupSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<GroupSummary>)
         */
        Builder groups(Consumer<GroupSummary.Builder>... groups);

        /**
         * <p>
         * A token that indicates that there is more data available. You can use this token in a subsequent
         * <code>ListAssociatedGroups</code> operation to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there is more data available. You can use this token in a subsequent
         *        <code>ListAssociatedGroups</code> operation to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SyntheticsResponse.BuilderImpl implements Builder {
        private List<GroupSummary> groups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedGroupsResponse model) {
            super(model);
            groups(model.groups);
            nextToken(model.nextToken);
        }

        public final List<GroupSummary.Builder> getGroups() {
            List<GroupSummary.Builder> result = GroupSummaryListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<GroupSummary.BuilderImpl> groups) {
            this.groups = GroupSummaryListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<GroupSummary> groups) {
            this.groups = GroupSummaryListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupSummary... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupSummary.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociatedGroupsResponse build() {
            return new ListAssociatedGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
