/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.BaseScreenshotIgnoreCoordinatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BaseScreenshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BaseScreenshot> {
    private static final SdkField<String> SCREENSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScreenshotName").getter(BaseScreenshot.getter(BaseScreenshot::screenshotName)).setter(BaseScreenshot.setter(Builder::screenshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenshotName").build()}).build();
    private static final SdkField<List<String>> IGNORE_COORDINATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IgnoreCoordinates").getter(BaseScreenshot.getter(BaseScreenshot::ignoreCoordinates)).setter(BaseScreenshot.setter(Builder::ignoreCoordinates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreCoordinates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCREENSHOT_NAME_FIELD, IGNORE_COORDINATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BaseScreenshot.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String screenshotName;
    private final List<String> ignoreCoordinates;

    private BaseScreenshot(BuilderImpl builder) {
        this.screenshotName = builder.screenshotName;
        this.ignoreCoordinates = builder.ignoreCoordinates;
    }

    public final String screenshotName() {
        return this.screenshotName;
    }

    public final boolean hasIgnoreCoordinates() {
        return this.ignoreCoordinates != null && !(this.ignoreCoordinates instanceof SdkAutoConstructList);
    }

    public final List<String> ignoreCoordinates() {
        return this.ignoreCoordinates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.screenshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIgnoreCoordinates() ? this.ignoreCoordinates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseScreenshot)) {
            return false;
        }
        BaseScreenshot other = (BaseScreenshot)obj;
        return Objects.equals(this.screenshotName(), other.screenshotName()) && this.hasIgnoreCoordinates() == other.hasIgnoreCoordinates() && Objects.equals(this.ignoreCoordinates(), other.ignoreCoordinates());
    }

    public final String toString() {
        return ToString.builder((String)"BaseScreenshot").add("ScreenshotName", (Object)this.screenshotName()).add("IgnoreCoordinates", this.hasIgnoreCoordinates() ? this.ignoreCoordinates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScreenshotName": {
                return Optional.ofNullable(clazz.cast(this.screenshotName()));
            }
            case "IgnoreCoordinates": {
                return Optional.ofNullable(clazz.cast(this.ignoreCoordinates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScreenshotName", SCREENSHOT_NAME_FIELD);
        map.put("IgnoreCoordinates", IGNORE_COORDINATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BaseScreenshot, T> g) {
        return obj -> g.apply((BaseScreenshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String screenshotName;
        private List<String> ignoreCoordinates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BaseScreenshot model) {
            this.screenshotName(model.screenshotName);
            this.ignoreCoordinates(model.ignoreCoordinates);
        }

        public final String getScreenshotName() {
            return this.screenshotName;
        }

        public final void setScreenshotName(String screenshotName) {
            this.screenshotName = screenshotName;
        }

        @Override
        public final Builder screenshotName(String screenshotName) {
            this.screenshotName = screenshotName;
            return this;
        }

        public final Collection<String> getIgnoreCoordinates() {
            if (this.ignoreCoordinates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ignoreCoordinates;
        }

        public final void setIgnoreCoordinates(Collection<String> ignoreCoordinates) {
            this.ignoreCoordinates = BaseScreenshotIgnoreCoordinatesCopier.copy(ignoreCoordinates);
        }

        @Override
        public final Builder ignoreCoordinates(Collection<String> ignoreCoordinates) {
            this.ignoreCoordinates = BaseScreenshotIgnoreCoordinatesCopier.copy(ignoreCoordinates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ignoreCoordinates(String ... ignoreCoordinates) {
            this.ignoreCoordinates(Arrays.asList(ignoreCoordinates));
            return this;
        }

        public BaseScreenshot build() {
            return new BaseScreenshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BaseScreenshot> {
        public Builder screenshotName(String var1);

        public Builder ignoreCoordinates(Collection<String> var1);

        public Builder ignoreCoordinates(String ... var1);
    }
}

